/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Empty;
import com.elixirtech.report2.logical.model.Graph;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.report2.util.ContextSubstitution;
import java.awt.Rectangle;

public class GraphRenderer
extends BasicLogicalRenderer {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GraphRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        com.elixirtech.report2.raw.model.Graph graph = (com.elixirtech.report2.raw.model.Graph)rawModelElement;
        if (graph.isVisible()) {
            boolean bl;
            String string = this.getValue(logicalRenderContext, graph);
            boolean bl2 = bl = string != null && string.length() > 0;
            if (!bl) {
                Rectangle rectangle = this.getInsetBorder(graph);
                Empty empty = new Empty();
                empty.setRaw(graph);
                empty.setId(graph.getName());
                empty.setLeft(rectangle.x);
                empty.setWidth(rectangle.width);
                empty.setTop(rectangle.y);
                if (!graph.isShrinkable()) {
                    empty.setHeight(rectangle.height);
                }
                logicalRenderContext.addElement(empty);
            } else {
                com.elixirtech.report2.logical.model.Rectangle rectangle = new com.elixirtech.report2.logical.model.Rectangle();
                com.elixirtech.report2.logical.model.Rectangle rectangle2 = GraphRenderer.buildRect(graph);
                this.insetBorder(graph, rectangle);
                Graph graph2 = new Graph();
                this.insetBorder(graph, graph2);
                graph2.setRaw(graph);
                graph2.setSizeMode(graph.getSizeMode());
                graph2.setGraphLayout(graph.getGraphLayout());
                ReportSubstitution reportSubstitution = new ReportSubstitution();
                String string2 = ArgumentMap.substitute(graph.getURL(), reportSubstitution);
                String string3 = ArgumentMap.substitute(graph.getURLDescription(), reportSubstitution);
                String string4 = ArgumentMap.substitute(graph.getURLTarget(), reportSubstitution);
                graph2.setURL(string2);
                graph2.setURLTarget(string4);
                graph2.setURLDescription(string3);
                graph2.setJSONData(string);
                rectangle2.addLogicalElement(graph2);
                logicalRenderContext.addElement(rectangle2);
            }
        } else {
            ControlSource controlSource = graph.getControlSource();
            if ("Script".equals(controlSource.getType())) {
                ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
                scriptEngine.evaluate(controlSource.getText());
            }
        }
    }

    protected String getValue(LogicalRenderContext logicalRenderContext, com.elixirtech.report2.raw.model.Graph graph) {
        Object object = ControlSourceProcessor.getData(graph.getControlSource());
        if (object == null) {
            return null;
        }
        return ContextSubstitution.substitute(logicalRenderContext, String.valueOf(object));
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

