/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.Empty;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.logical.renderer.VBoxRenderer;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.VBox;
import com.elixirtech.report2.script.ScriptEngine;
import java.util.ArrayList;
import java.util.Iterator;

public class HBoxRenderer
extends BasicLogicalRenderer {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(HBoxRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        HBox hBox = (HBox)rawModelElement;
        if (hBox.isVisible()) {
            Rectangle rectangle = new Rectangle();
            rectangle.setRaw(hBox);
            rectangle.setLeft(hBox.getLeft());
            rectangle.setTop(hBox.getTop());
            rectangle.setWidth(hBox.getWidth());
            rectangle.setHeight(hBox.getHeight());
            rectangle.setKeepTogether(hBox.isKeepTogether());
            rectangle.setNoClip(true);
            ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
            ArrayList<Cell> arrayList = new ArrayList<Cell>();
            for (Cell object2 : hBox.getCellList()) {
                Script n2 = object2.getRenderIf();
                if (!Script.notEmpty(n2) || !Boolean.FALSE.equals(scriptEngine.evaluate(n2))) continue;
                arrayList.add(object2);
            }
            ArrayList<Cell> arrayList2 = new ArrayList<Cell>(hBox.getCellList());
            if (!arrayList.isEmpty()) {
                int n;
                int[] n2 = new int[arrayList.size()];
                for (n = 0; n < n2.length; ++n) {
                    Cell cell = (Cell)arrayList.get(n);
                    n2[n] = cell.getWeight();
                    cell.setWeight(0);
                }
                hBox.layoutCells();
                for (n = 0; n < n2.length; ++n) {
                    ((Cell)arrayList.get(n)).setWeight(n2[n]);
                }
                arrayList2.removeAll(arrayList);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Cell cell = (Cell)iterator.next();
                for (RawModelElement rawModelElement2 : cell.getRawElementList()) {
                    rawModelElement2.setLeft(cell.getLeft());
                    rawModelElement2.setTop(cell.getTop());
                    rawModelElement2.setWidth(cell.getWidth());
                    rawModelElement2.setHeight(cell.getHeight());
                    logicalRenderContext.renderChild(rawModelElement2, rectangle);
                }
            }
            RenderUtil.growShrinkRectangle(rectangle);
            int n = rectangle.getTop();
            int n3 = rectangle.getHeight();
            this.ensureConsistentHeights(rectangle, n, n3);
            logicalRenderContext.addElement(rectangle);
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    private void ensureConsistentHeights(ILogicalElementHolder iLogicalElementHolder, int n, int n2) {
        for (LogicalElement logicalElement : iLogicalElementHolder.getLogicalElementList()) {
            this.setPosition(logicalElement, n, n2);
        }
    }

    private void setPosition(LogicalElement logicalElement, int n, int n2) {
        VBoxRenderer.moveTop(logicalElement, n - logicalElement.getTop());
        logicalElement.setHeight(n2);
        if (logicalElement instanceof Empty) {
            return;
        }
        RawModelElement rawModelElement = logicalElement.getRaw();
        if (rawModelElement instanceof HBox && logicalElement instanceof ILogicalElementHolder) {
            this.ensureConsistentHeights((ILogicalElementHolder)((Object)logicalElement), n, n2);
        } else if (rawModelElement instanceof VBox && logicalElement instanceof Rectangle) {
            this.adjustVBoxHeight((Rectangle)logicalElement);
        }
    }

    private void adjustVBoxHeight(Rectangle rectangle) {
        int n;
        int n2 = rectangle.getHeight();
        VBox vBox = (VBox)rectangle.getRaw();
        int n3 = 0;
        long l = 0L;
        for (Cell cell : vBox.getCellList()) {
            l += (long)cell.getWeight();
        }
        int n4 = rectangle.getTop();
        int n5 = Math.min(vBox.getCellCount(), rectangle.getLogicalElementCount());
        for (n = 0; n < n5; ++n) {
            n3 += rectangle.getLogicalElement(n).getHeight();
        }
        n = n2 - n3;
        assert (n >= 0);
        if (n > 0) {
            for (int i = 0; i < n5; ++i) {
                Cell cell = vBox.getCell(i);
                long l2 = cell.getWeight();
                LogicalElement logicalElement = rectangle.getLogicalElement(i);
                int n6 = (int)(l2 * (long)n / l);
                this.setPosition(logicalElement, n4, logicalElement.getHeight() + n6);
                l -= l2;
                n -= n6;
                n4 += logicalElement.getHeight();
            }
        }
    }
}

