/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.arch.util.URLUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.jdom.Document;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.SVG;
import com.elixirtech.report2.util.ContextSubstitution;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.svg.ElxSVGFactory;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.FileUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

public class SVGRenderer
extends BasicLogicalRenderer {
    protected URL m_URL;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SVGRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        SVG sVG = (SVG)rawModelElement;
        if (sVG.isVisible()) {
            Rectangle rectangle = this.buildRect(sVG);
            com.elixirtech.report2.logical.model.SVG sVG2 = new com.elixirtech.report2.logical.model.SVG();
            if (rectangle != null) {
                this.insetBorder(sVG, sVG2);
                rectangle.setCurvedClip(true);
            } else {
                SVGRenderer.copyRectAttrs(sVG, sVG2);
            }
            this.copyBackgroundAttrs(sVG, sVG2);
            sVG2.setImageResolution(Math.max(72, sVG.getImageResolution()));
            SVGDocument sVGDocument = this.buildSVGContent(logicalRenderContext, sVG);
            if (sVG.isDynamic()) {
                this.adjustDocument(logicalRenderContext, sVGDocument);
            }
            sVG2.setDocument(sVGDocument);
            if (rectangle != null) {
                rectangle.addLogicalElement(sVG2);
                logicalRenderContext.addElement(rectangle);
            } else {
                sVG2.setRaw(sVG);
                logicalRenderContext.addElement(sVG2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVGDocument buildSVGContent(LogicalRenderContext logicalRenderContext, SVG sVG) {
        Document document = sVG.getDocument();
        if (document != null) {
            try {
                return ElxSVGFactory.buildFromJDOM(document);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Unable to convert JDOM to SVGDocument: " + String.valueOf(exception)), (Throwable)exception);
                return null;
            }
        }
        String string = sVG.getLocation();
        if (string == null) {
            m_Log.error((Object)"No SVG Location found");
            return null;
        }
        string = ArgumentMap.substitute(string, new ReportSubstitution());
        if ((string = string.trim()).endsWith(".wmf")) {
            SVGDocument sVGDocument;
            InputStream inputStream = null;
            try {
                inputStream = SVGRenderer.getInputStream(string);
                TranscoderInput transcoderInput = new TranscoderInput(inputStream);
                TranscoderOutput transcoderOutput = new TranscoderOutput();
                WMFTranscoder wMFTranscoder = new WMFTranscoder();
                wMFTranscoder.transcode(transcoderInput, transcoderOutput);
                sVGDocument = (SVGDocument)transcoderOutput.getDocument();
            }
            catch (Exception exception) {
                SVGDocument sVGDocument2;
                try {
                    m_Log.error((Object)("Error reading WMF: " + String.valueOf(exception)), (Throwable)exception);
                    sVGDocument2 = null;
                }
                catch (Throwable throwable) {
                    FileUtil.close(inputStream);
                    throw throwable;
                }
                FileUtil.close(inputStream);
                return sVGDocument2;
            }
            FileUtil.close(inputStream);
            return sVGDocument;
        }
        try {
            return ElxSVGFactory.buildFromURI(string);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error reading SVG (" + string + "): " + String.valueOf(exception)), (Throwable)exception);
            return null;
        }
    }

    private static InputStream getInputStream(String string) throws IOException {
        if (URLUtil.isURL(string)) {
            return URLLoader.getInputStream(string);
        }
        RMLFileObject rMLFileObject = RenderStack.current().getFile(string);
        if (rMLFileObject != null) {
            return rMLFileObject.getInputStream();
        }
        m_Log.error((Object)("Location not found: " + string));
        return null;
    }

    protected Rectangle buildRect(SVG sVG) {
        boolean bl;
        String string = sVG.getBorderStyle();
        boolean bl2 = bl = string != null && !string.equals("Transparent");
        if (!bl) {
            String string2 = sVG.getBackgroundColor();
            Color color = StandardColor.lookup(string2);
            boolean bl3 = bl = color.getAlpha() > 0;
        }
        if (bl) {
            return BasicLogicalRenderer.buildRect(sVG);
        }
        return null;
    }

    protected void adjustDocument(LogicalRenderContext logicalRenderContext, SVGDocument sVGDocument) {
        Element element = sVGDocument.getDocumentElement();
        this.adjustElement(logicalRenderContext, element);
    }

    protected void adjustElement(LogicalRenderContext logicalRenderContext, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                this.adjustElement(logicalRenderContext, (Element)node);
            }
            if (node.getNodeType() != 3) continue;
            this.adjustTextNode(logicalRenderContext, node);
        }
    }

    protected void adjustTextNode(LogicalRenderContext logicalRenderContext, Node node) {
        String string = node.getNodeValue();
        string = ContextSubstitution.substitute(logicalRenderContext, string);
        node.setNodeValue(string);
    }

    public void copyBackgroundAttrs(RawElement rawElement, com.elixirtech.report2.logical.model.SVG sVG) {
        sVG.setBackgroundColor(rawElement.getBackgroundColor());
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

