/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ReportFooter;
import com.elixirtech.report2.logical.renderer.IChunkRenderer;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.SectionFooter;

public class SectionFooterRenderer
implements IChunkRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SectionFooterRenderer.class);

    @Override
    public BodyPart render(LogicalRenderContext logicalRenderContext, Chunk chunk) {
        SectionFooter sectionFooter = (SectionFooter)chunk;
        ReportFooter reportFooter = new ReportFooter();
        reportFooter.setRaw(sectionFooter);
        if (sectionFooter.isVisible()) {
            reportFooter.setWidth(logicalRenderContext.getBodyWidth());
            reportFooter.setHeight(sectionFooter.getHeight());
            reportFooter.setBackgroundColor(sectionFooter.getBackgroundColor());
            ReportSubstitution reportSubstitution = new ReportSubstitution();
            String string = ArgumentMap.substitute(sectionFooter.getURL(), reportSubstitution);
            String string2 = ArgumentMap.substitute(sectionFooter.getURLDescription(), reportSubstitution);
            String string3 = ArgumentMap.substitute(sectionFooter.getURLTarget(), reportSubstitution);
            reportFooter.setURL(string);
            reportFooter.setURLDescription(string2);
            reportFooter.setURLTarget(string3);
            reportFooter.setTableOfContents(sectionFooter.isTableOfContents());
            reportFooter.setKeepTogether(sectionFooter.isKeepTogether());
            reportFooter.setVerticalAlign(sectionFooter.getVerticalAlign());
            reportFooter.setCaption(sectionFooter.getCaption());
            logicalRenderContext.renderChildren(sectionFooter, reportFooter);
            if (sectionFooter.isTableOfContents()) {
                reportFooter.setTableOfContents(true);
                logicalRenderContext.decTOCLevel();
            }
        }
        return reportFooter;
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

