/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.report2.data.DataCache;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.data.MasterDataCache;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.report2.raw.model.TableSection;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.sax.IBean;
import java.util.Iterator;

public class TableRenderer
extends BasicLogicalRenderer {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TableRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        block21: {
            Table table = (Table)rawModelElement;
            try {
                if (!table.isVisible()) break block21;
                IDataCacheManager iDataCacheManager = logicalRenderContext.getDataCacheManager();
                String string = table.getCache();
                Object object = iDataCacheManager.getCacheName(string);
                boolean bl = iDataCacheManager.hasCache(object);
                try {
                    Object object2;
                    TableBody tableBody;
                    Object object3;
                    String string2;
                    IDataCache iDataCache = null;
                    if (bl) {
                        iDataCache = iDataCacheManager.getCache(object);
                    }
                    if (iDataCache == null) {
                        Data data = logicalRenderContext.getData();
                        string2 = data.getDataSourceName();
                        if (string.equals(string2)) {
                            iDataCache = new DataCache(string2, data.getDataTable());
                            iDataCache.moveToRow(data.getRecordIndex());
                            iDataCacheManager.putCache(object, iDataCache);
                        } else {
                            object3 = new DataHolder((String)object);
                            iDataCache = iDataCacheManager.loadCache((String)object, ((DataHolder)object3).getProperties());
                        }
                    }
                    if (iDataCache.getRecordCount() <= 0 && !table.isShowEmptyTable()) break block21;
                    int n = iDataCache.getRecordIndex();
                    string2 = table.getDataRange();
                    object3 = new Rectangle();
                    ((LogicalModelElement)object3).setRaw(table);
                    ((SizableElement)object3).setKeepTogether(table.isKeepTogether());
                    TableRenderer.copyRectAttrs(table, (LogicalElement)object3);
                    TableRenderer.copyBackgroundAttrs(table, (Rectangle)object3);
                    TableRenderer.copyBorderAttrs(table, (Rectangle)object3);
                    if ("All".equals(string2)) {
                        iDataCache.moveToRow(0);
                    }
                    int n2 = ((LogicalElement)object3).getTop() + RenderUtil.getBorderTop((IBean)object3) + RenderUtil.getPaddingTop((IBean)object3);
                    TableHeader tableHeader = table.getHeader();
                    if (tableHeader != null) {
                        n2 = this.renderElement(logicalRenderContext, (Rectangle)object3, n2, tableHeader);
                    }
                    if (iDataCache.hasNext() && (tableBody = table.getBody()) != null) {
                        if ("Group".equals(string2)) {
                            if (iDataCache instanceof MasterDataCache) {
                                int n3;
                                object2 = logicalRenderContext.getData();
                                GroupNode groupNode = object2.getGroup();
                                int n4 = groupNode.getStop();
                                for (int i = n3 = iDataCache.getRecordIndex(); i <= n4; ++i) {
                                    n2 = this.renderElement(logicalRenderContext, (Rectangle)object3, n2, tableBody);
                                    iDataCache.next();
                                }
                            } else {
                                while (iDataCache.hasNext()) {
                                    n2 = this.renderElement(logicalRenderContext, (Rectangle)object3, n2, tableBody);
                                    iDataCache.next();
                                    if (!iDataCache.isGroupStart()) continue;
                                    break;
                                }
                            }
                        } else {
                            while (iDataCache.hasNext()) {
                                n2 = this.renderElement(logicalRenderContext, (Rectangle)object3, n2, tableBody);
                                iDataCache.next();
                                if (!"Record".equals(string2)) continue;
                            }
                        }
                    }
                    int n5 = iDataCache.getRecordIndex();
                    iDataCache.moveToRow(n5 - 1);
                    object2 = table.getFooter();
                    if (object2 != null) {
                        n2 = this.renderElement(logicalRenderContext, (Rectangle)object3, n2, (TableSection)object2);
                    }
                    if (!bl && iDataCache.hasParameters()) {
                        iDataCacheManager.removeCache(object);
                    } else {
                        iDataCache.moveToRow(n);
                    }
                    RenderUtil.growShrinkRectangle((Rectangle)object3);
                    logicalRenderContext.addElement((LogicalElement)object3);
                }
                catch (DataException dataException) {
                    m_Log.error((Object)("Can't access data cache: " + String.valueOf(object) + " : " + String.valueOf(dataException)));
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't render table: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int renderElement(LogicalRenderContext logicalRenderContext, Rectangle rectangle, int n, TableSection tableSection) {
        Rectangle rectangle2;
        Script script = tableSection.getRenderIf();
        Script script2 = tableSection.getOnRenderBegin();
        Script script3 = tableSection.getOnRenderEnd();
        boolean bl = script != null || script2 != null || script3 != null;
        ScriptEngine scriptEngine = null;
        if (bl) {
            scriptEngine = RenderStack.current().getScriptEngine();
            scriptEngine.pushJSScope(tableSection);
        }
        try {
            if (script != null) {
                assert (scriptEngine != null);
                if (scriptEngine.evaluate(script) == Boolean.FALSE) {
                    int n2 = n;
                    return n2;
                }
            }
            if (script2 != null) {
                assert (scriptEngine != null);
                scriptEngine.evaluate(script2);
            }
            rectangle2 = new Rectangle();
            rectangle2.setRaw(tableSection);
            rectangle2.setLeft(rectangle.getLeft());
            rectangle2.setTop(n);
            rectangle2.setWidth(rectangle.getWidth());
            rectangle2.setHeight(tableSection.getHeight());
            logicalRenderContext.renderChildren(tableSection, rectangle2);
            this.shiftChildrenDown(rectangle2, n - tableSection.getTop());
            RenderUtil.growShrinkRectangle(rectangle2);
            rectangle.addLogicalElement(rectangle2);
            if (script3 != null) {
                assert (scriptEngine != null);
                scriptEngine.define("javascript", "result", rectangle2);
                scriptEngine.evaluate(script3);
            }
        }
        finally {
            if (bl) {
                assert (scriptEngine != null);
                scriptEngine.popJSScope();
            }
        }
        return n += rectangle2.getHeight();
    }

    protected void shiftChildrenDown(ILogicalElementHolder iLogicalElementHolder, int n) {
        Iterator<LogicalElement> iterator = iLogicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalModelElement logicalModelElement = iterator.next();
            if (logicalModelElement instanceof LogicalElement) {
                LogicalElement logicalElement = (LogicalElement)logicalModelElement;
                logicalElement.setTop(logicalElement.getTop() + n);
            }
            if (!(logicalModelElement instanceof ILogicalElementHolder)) continue;
            this.shiftChildrenDown((ILogicalElementHolder)((Object)logicalModelElement), n);
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

