/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.VBox;
import com.elixirtech.report2.script.ScriptEngine;
import java.util.ArrayList;
import java.util.Iterator;

public class VBoxRenderer
extends BasicLogicalRenderer {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(VBoxRenderer.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        VBox vBox = (VBox)rawModelElement;
        if (vBox.isVisible()) {
            Rectangle rectangle = new Rectangle();
            rectangle.setRaw(vBox);
            rectangle.setLeft(vBox.getLeft());
            rectangle.setTop(vBox.getTop());
            rectangle.setWidth(vBox.getWidth());
            rectangle.setHeight(vBox.getHeight());
            rectangle.setKeepTogether(vBox.isKeepTogether());
            rectangle.setNoClip(true);
            ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
            ArrayList<Cell> arrayList = new ArrayList<Cell>();
            for (Cell object2 : vBox.getCellList()) {
                Script script = object2.getRenderIf();
                if (!Script.notEmpty(script) || !Boolean.FALSE.equals(scriptEngine.evaluate(script))) continue;
                arrayList.add(object2);
            }
            ArrayList<Cell> arrayList2 = new ArrayList<Cell>(vBox.getCellList());
            if (!arrayList.isEmpty()) {
                int n;
                int[] n2 = new int[arrayList.size()];
                for (n = 0; n < n2.length; ++n) {
                    Cell cell = (Cell)arrayList.get(n);
                    n2[n] = cell.getWeight();
                    cell.setWeight(0);
                }
                vBox.layoutCells();
                for (n = 0; n < n2.length; ++n) {
                    ((Cell)arrayList.get(n)).setWeight(n2[n]);
                }
                arrayList2.removeAll(arrayList);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Cell cell = (Cell)iterator.next();
                for (RawModelElement rawModelElement2 : cell.getRawElementList()) {
                    rawModelElement2.setLeft(cell.getLeft());
                    rawModelElement2.setTop(cell.getTop());
                    rawModelElement2.setWidth(cell.getWidth());
                    rawModelElement2.setHeight(cell.getHeight());
                    logicalRenderContext.renderChild(rawModelElement2, rectangle);
                }
            }
            int n = rectangle.getTop();
            for (LogicalElement logicalElement : rectangle.getLogicalElementList()) {
                void var8_13;
                void var11_24;
                if (logicalElement instanceof Rectangle) {
                    RenderUtil.growShrinkRectangle((Rectangle)logicalElement);
                }
                if ((var11_24 = var8_13 - logicalElement.getTop()) != false) {
                    VBoxRenderer.moveTop(logicalElement, (int)var11_24);
                }
                var8_13 += logicalElement.getHeight();
            }
            RenderUtil.growShrinkRectangle(rectangle);
            logicalRenderContext.addElement(rectangle);
        }
    }

    protected static void moveTop(LogicalElement logicalElement, int n) {
        if (n != 0) {
            logicalElement.setTop(logicalElement.getTop() + n);
            if (logicalElement instanceof ILogicalElementHolder) {
                ILogicalElementHolder iLogicalElementHolder = (ILogicalElementHolder)((Object)logicalElement);
                for (LogicalElement logicalElement2 : iLogicalElementHolder.getLogicalElementList()) {
                    VBoxRenderer.moveTop(logicalElement2, n);
                }
            }
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

