/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.TOC;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.Annotation;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Detail;
import com.elixirtech.report2.logical.model.GroupFooter;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.ReportFooter;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.IPhysicalRendererFactory;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.Translator;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.util.MetricConvertor;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PhysicalRenderer
implements PageListener {
    protected PageSource m_PageSource;
    protected int m_HorizontalWidth;
    protected TOC m_MasterTOC;
    protected TOC m_CurrentTOC;
    protected IPhysicalRendererFactory m_PhysicalRendererFactory;
    protected Map<String, Object> m_Cache = new HashMap<String, Object>();
    protected int m_TOCLevel;
    protected static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PhysicalRenderer.class);

    public PhysicalRenderer(IPhysicalRendererFactory iPhysicalRendererFactory) {
        this.m_PhysicalRendererFactory = iPhysicalRendererFactory;
    }

    public void setRendererFactory(IPhysicalRendererFactory iPhysicalRendererFactory) {
        this.m_PhysicalRendererFactory = iPhysicalRendererFactory;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.m_PageSource = pageSource;
            this.m_CurrentTOC = this.m_MasterTOC = new TOC(null, "Master", 0, 0, 0);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("PhysicalRenderer: " + String.valueOf(throwable)));
            throw new RenderException("PhysicalRenderer: " + String.valueOf(throwable), throwable);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) {
        this.disposeCache();
        this.m_PageSource = null;
        this.m_MasterTOC = null;
        this.m_CurrentTOC = null;
    }

    public RenderDetails getRenderDetails(MimeType mimeType) {
        LogicalReport logicalReport = this.m_PageSource.getLogicalReport();
        return logicalReport.getRenderDetails(mimeType.value());
    }

    public Iterator<TOC> getTOCIterator() {
        return this.m_MasterTOC.getChildIterator();
    }

    public TOC getRootTOC() {
        return this.m_MasterTOC;
    }

    protected boolean isRenderAnnotations() {
        LogicalReport logicalReport = this.m_PageSource.getLogicalReport();
        Parameter parameter = logicalReport.getParameter("render.annotations");
        return parameter != null && "Yes".equals(parameter.getValue());
    }

    protected void disposeCache() {
        for (Object object : this.m_Cache.values()) {
            if (!(object instanceof Image)) continue;
            ((Image)object).flush();
        }
        this.m_Cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage renderPageToImage(Page page, int n, int n2, int n3) {
        PageSetup pageSetup = page.getPageSetup();
        int n4 = pageSetup.getWidth() * n2 / 1440;
        int n5 = pageSetup.getHeight() * n2 / 1440;
        BufferedImage bufferedImage = new BufferedImage(n4, n5, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n4, n5);
            graphics2D.setColor(Color.black);
            graphics2D.scale((double)n2 / 72.0, (double)n2 / 72.0);
            this.renderPage(page, n, graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(Page page, int n, Graphics graphics) {
        GraphicalRenderContext graphicalRenderContext = new GraphicalRenderContext(this, graphics, n + 1, page, this.m_Cache);
        try {
            this.renderPage(graphicalRenderContext, page);
        }
        finally {
            graphicalRenderContext.dispose();
        }
    }

    public void renderPage(GraphicalRenderContext graphicalRenderContext, Page page) {
        Object object;
        Body body;
        int n = 0;
        PageSetup pageSetup = page.getPageSetup();
        int n2 = MetricConvertor.twipToPoint(pageSetup.getLeft());
        int n3 = MetricConvertor.twipToPoint(pageSetup.getTop());
        Page page2 = page.getWatermark();
        if (page2 != null) {
            this.renderPage(graphicalRenderContext, page2);
        }
        graphicalRenderContext.translate(n2, n3);
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            this.renderChunk2(graphicalRenderContext, pageHeader);
            n = MetricConvertor.twipToPoint(pageHeader.getHeight());
            graphicalRenderContext.translate(0, n);
        }
        if ((body = page.getBody()) != null) {
            object = new Translator(graphicalRenderContext);
            this.renderBody(graphicalRenderContext, body, (Translator)object);
            ((Translator)object).revert();
        }
        graphicalRenderContext.translate(0, -n);
        object = page.getPageFooter();
        if (object != null) {
            int n4 = ((SizableElement)object).getHeight();
            int n5 = MetricConvertor.twipToPoint(pageSetup.getHeight() - pageSetup.getTop() - pageSetup.getBottom() - n4);
            graphicalRenderContext.translate(0, n5);
            this.renderChunk2(graphicalRenderContext, (LogicalElementHolder)object);
            graphicalRenderContext.translate(0, -n5);
        }
        graphicalRenderContext.translate(-n2, -n3);
        if (this.isRenderAnnotations()) {
            m_Log.debug((Object)"Rendering annotations");
            Iterator<Annotation> iterator = page.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = iterator.next();
                m_Log.debug((Object)("Rendering annotation for page " + annotation.getPage()));
                this.renderChunk2(graphicalRenderContext, annotation);
            }
        }
    }

    protected void renderBody(GraphicalRenderContext graphicalRenderContext, Body body, Translator translator) {
        Iterator<BodyPart> iterator = body.getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            if (bodyPart instanceof Columns) {
                this.renderColumns(graphicalRenderContext, (Columns)bodyPart, translator);
                continue;
            }
            this.renderChunk2(graphicalRenderContext, bodyPart);
            int n = MetricConvertor.twipToPoint(bodyPart.getHeight());
            int n2 = MetricConvertor.twipToPoint(bodyPart.getSpaceAfter());
            translator.translate(0, n + n2);
        }
    }

    protected void renderColumns(GraphicalRenderContext graphicalRenderContext, Columns columns, Translator translator) {
        int n = 0;
        Translator translator2 = new Translator(graphicalRenderContext);
        Iterator<Column> iterator = columns.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = iterator.next();
            this.renderColumn(graphicalRenderContext, column, translator2);
            n = Math.max(n, translator2.getY());
            if (!iterator.hasNext()) continue;
            int n2 = MetricConvertor.twipToPoint(column.getWidth());
            int n3 = MetricConvertor.twipToPoint(column.getSpaceAfter());
            translator2.revertY();
            translator2.translate(n2 + n3, 0);
        }
        translator2.revert();
        translator.translate(0, n);
    }

    protected void renderColumn(GraphicalRenderContext graphicalRenderContext, Column column, Translator translator) {
        Iterator<BodyPart> iterator = column.getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            this.renderChunk2(graphicalRenderContext, bodyPart);
            int n = MetricConvertor.twipToPoint(bodyPart.getHeight());
            int n2 = MetricConvertor.twipToPoint(bodyPart.getSpaceAfter());
            translator.translate(0, n + n2);
        }
    }

    protected void renderChunk2(GraphicalRenderContext graphicalRenderContext, LogicalElementHolder logicalElementHolder) {
        String string;
        boolean bl;
        boolean bl2 = bl = logicalElementHolder instanceof ITOCElement && RenderUtil.isValidTOC(logicalElementHolder);
        if (bl) {
            this.pushTOC(graphicalRenderContext, (ITOCElement)((Object)logicalElementHolder));
        }
        if (StringUtil.notEmpty(string = logicalElementHolder.getBackgroundColor())) {
            int n = logicalElementHolder.getWidth() / 20;
            int n2 = logicalElementHolder.getHeight() / 20;
            Graphics graphics = graphicalRenderContext.getGraphics();
            graphics.setColor(StandardColor.lookup(string));
            graphics.fillRect(0, 0, n, n2);
        }
        Iterator<LogicalElement> iterator = logicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            this.render2(graphicalRenderContext, logicalElement);
        }
        if (RenderUtil.isValidTOC(logicalElementHolder) && this.m_TOCLevel > 0) {
            if (logicalElementHolder instanceof Detail) {
                if (((Detail)logicalElementHolder).isTableOfContents()) {
                    this.popTOC();
                }
            } else if (logicalElementHolder instanceof GroupFooter) {
                if (((GroupFooter)logicalElementHolder).isTableOfContents()) {
                    this.popTOC();
                }
            } else if (logicalElementHolder instanceof ReportFooter && ((ReportFooter)logicalElementHolder).isTableOfContents()) {
                this.popTOC();
            }
        }
    }

    protected void render2(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        int n;
        Object object;
        boolean bl;
        boolean bl2 = bl = logicalElement instanceof Rectangle && RenderUtil.isValidTOC(logicalElement);
        if (bl) {
            this.pushTOC(physicalRenderContext, (ITOCElement)((Object)logicalElement));
        }
        String string = logicalElement.getTagName();
        try {
            object = this.m_PhysicalRendererFactory.getRenderer(string);
            if (object != null) {
                object.render(physicalRenderContext, logicalElement);
            }
        }
        catch (RenderException renderException) {
            m_Log.error((Object)("Error rendering " + string + ": " + String.valueOf(renderException)), (Throwable)renderException);
        }
        if (logicalElement instanceof Rectangle && RenderUtil.isValidTOC(logicalElement) && (n = ((Rectangle)(object = (Rectangle)logicalElement)).getTOCLevel()) == -1) {
            this.m_CurrentTOC = this.m_CurrentTOC.getParent();
        }
    }

    protected void pushTOC(PhysicalRenderContext physicalRenderContext, ITOCElement iTOCElement) {
        if (iTOCElement.isTableOfContents()) {
            while (this.m_TOCLevel > iTOCElement.getTOCLevel()) {
                this.popTOC();
            }
            String string = iTOCElement.getTOCTitle();
            Page page = physicalRenderContext.getPage();
            Point point = physicalRenderContext.getOffset();
            PageSetup pageSetup = page.getPageSetup();
            int n = MetricConvertor.twipToPoint(pageSetup.getHeight()) - point.y;
            this.m_CurrentTOC = new TOC(this.m_CurrentTOC, string, page.getPageNumber(), point.x, n);
            ++this.m_TOCLevel;
        }
    }

    protected void popTOC() {
        this.m_CurrentTOC = this.m_CurrentTOC.getParent();
        --this.m_TOCLevel;
    }
}

