/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.GlintInput;
import com.elixirtech.glint.GlintMerger;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.report2.logical.model.ByteArray;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import java.io.ByteArrayInputStream;

public class GlintRenderer
extends BasicPhysicalRenderer {
    private GlintMerger m_Merger = new GlintMerger();
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GlintRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        ByteArray byteArray;
        Glint glint = (Glint)logicalElement;
        GlintRenderContext glintRenderContext = (GlintRenderContext)physicalRenderContext;
        IGlint iGlint = glintRenderContext.getGlint();
        int n = glint.getLeft();
        int n2 = glint.getTop();
        int n3 = glint.getWidth();
        int n4 = glint.getHeight();
        iGlint.pushClip(n, n2, n3, n4);
        if (n != 0 || n2 != 0) {
            iGlint.offsetOrigin(n, n2);
        }
        if ((byteArray = glint.getByteArray()) != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getBytes());
                this.m_Merger.setNext(iGlint);
                GlintInput.read(byteArrayInputStream, true, this.m_Merger);
            }
            catch (Exception exception) {
                m_Log.error((Object)exception.toString());
            }
        }
        if (n != 0 || n2 != 0) {
            iGlint.offsetOrigin(-n, -n2);
        }
        iGlint.popClip();
    }
}

