/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.RTF;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import com.elixirtech.report2.util.MetricConvertor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.View;
import javax.swing.text.rtf.RTFEditorKit;

public class RTFRenderer
extends BasicPhysicalRenderer {
    private RTFEditorKit m_RTFEditorKit;
    private JEditorPane m_EditorPane = new JEditorPane();
    private Document m_Document;
    private int m_KeyId;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RTFRenderer.class);

    public RTFRenderer() {
        this.m_RTFEditorKit = new RTFEditorKit();
        this.m_EditorPane.setEditorKit(this.m_RTFEditorKit);
        this.m_Document = this.m_EditorPane.getDocument();
        this.m_EditorPane.updateUI();
    }

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        m_Log.debug((Object)"Entered");
        RTF rTF = (RTF)logicalElement;
        GlintRenderContext glintRenderContext = (GlintRenderContext)physicalRenderContext;
        IGlint iGlint = glintRenderContext.getGlint();
        int n = MetricConvertor.twipToPoint(rTF.getWidth());
        int n2 = MetricConvertor.twipToPoint(rTF.getHeight());
        this.m_EditorPane.setLocation(0, 0);
        this.m_EditorPane.setSize(new Dimension(n, n2));
        try {
            this.m_Document.remove(0, this.m_Document.getLength());
            StringReader stringReader = new StringReader(rTF.getText());
            this.m_RTFEditorKit.read(stringReader, this.m_Document, 0);
            View view = this.m_EditorPane.getUI().getRootView(this.m_EditorPane);
            int n3 = n * 72 / 72;
            int n4 = n2 * 72 / 72;
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.clipRect(0, 0, n3, n4);
            graphics2D.scale(1.0, 1.0);
            view.paint(graphics2D, new Rectangle(0, 0, n, n2));
            graphics2D.dispose();
            iGlint.drawScaledImage(iGlint.defineImage(Image.getInstance(bufferedImage, "RTF" + this.m_KeyId)), rTF.getLeft(), rTF.getTop(), rTF.getWidth(), rTF.getHeight());
            ++this.m_KeyId;
            bufferedImage.flush();
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }
}

