/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.ColorManager;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.report2.font.FontUtil;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import com.elixirtech.report2.util.TextUtil;

public class TextRenderer
extends BasicPhysicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TextRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        Text text = (Text)logicalElement;
        if (StringUtil.notEmpty(text.getText())) {
            int n;
            GlintRenderContext glintRenderContext = (GlintRenderContext)physicalRenderContext;
            IGlint iGlint = glintRenderContext.getGlint();
            String string = text.getURL();
            if (StringUtil.notEmpty(string)) {
                iGlint.setURL(text.getURL(), text.getURLDescription());
            }
            for (n = text.getOrientation(); n >= 360; n -= 360) {
            }
            while (n < 0) {
                n += 360;
            }
            if (n < 90) {
                this.render0(glintRenderContext, text);
            } else if (n < 180) {
                this.render90(glintRenderContext, text);
            } else if (n < 270) {
                this.render180(glintRenderContext, text);
            } else if (n < 360) {
                this.render270(glintRenderContext, text);
            }
            if (StringUtil.notEmpty(string)) {
                iGlint.resetURL();
            }
        }
    }

    protected void render0(GlintRenderContext glintRenderContext, Text text) {
        IGlint iGlint = glintRenderContext.getGlint();
        int n = text.getLeft();
        int n2 = text.getTop();
        int n3 = text.getWidth();
        int n4 = n + n3;
        String string = glintRenderContext.substituteVariables(text.getText());
        TextAlignment textAlignment = TextAlignment.get(text.getTextAlign());
        IGlint.FontId fontId = iGlint.defineFont(this.getGlintFont(glintRenderContext, text));
        Color color = ColorManager.lookup(text.getFontColor());
        IGlint.ColorId colorId = iGlint.defineColor(color);
        int n5 = text.getAscent();
        if (textAlignment == TextAlignment.LEFT) {
            iGlint.drawText(fontId, colorId, n, n2 + n5, 1, string);
        } else if (textAlignment == TextAlignment.RIGHT) {
            iGlint.drawText(fontId, colorId, n4, n2 + n5, 2, string);
        } else if (textAlignment == TextAlignment.CENTER) {
            iGlint.drawText(fontId, colorId, (n + n4) / 2, n2 + n5, 3, string);
        } else if (textAlignment == TextAlignment.JUSTIFY) {
            iGlint.drawJustifiedText(fontId, colorId, n, n2 + n5, n3, string);
        } else {
            m_Log.warn((Object)("Unknown alignment: " + String.valueOf(textAlignment)));
        }
    }

    protected void render90(GlintRenderContext glintRenderContext, Text text) {
        IGlint iGlint = glintRenderContext.getGlint();
        int n = text.getLeft();
        int n2 = text.getTop();
        int n3 = text.getWidth();
        int n4 = text.getHeight();
        int n5 = n + n3;
        int n6 = n2 + n4;
        String string = glintRenderContext.substituteVariables(text.getText());
        TextAlignment textAlignment = TextAlignment.get(text.getTextAlign());
        IGlint.FontId fontId = iGlint.defineFont(this.getGlintFont(glintRenderContext, text));
        Color color = ColorManager.lookup(text.getFontColor());
        IGlint.ColorId colorId = iGlint.defineColor(color);
        int n7 = text.getAscent();
        if (textAlignment == TextAlignment.LEFT) {
            iGlint.drawRotatedText(fontId, colorId, n5 - n7, n2, 1, 270, string);
        } else if (textAlignment == TextAlignment.RIGHT) {
            string = TextUtil.rightTrim(string);
            iGlint.drawRotatedText(fontId, colorId, n5 - n7, n6, 2, 270, string);
        } else if (textAlignment == TextAlignment.CENTER) {
            iGlint.drawRotatedText(fontId, colorId, n5 - n7, n2 + n4 / 2, 3, 270, string);
        } else if (textAlignment == TextAlignment.JUSTIFY) {
            iGlint.drawRotatedJustifiedText(fontId, colorId, n5 - n7, n2, n3, 270, string);
        } else {
            m_Log.warn((Object)("Unknown alignment: " + String.valueOf(textAlignment)));
        }
    }

    protected void render180(GlintRenderContext glintRenderContext, Text text) {
        IGlint iGlint = glintRenderContext.getGlint();
        int n = text.getLeft();
        int n2 = text.getTop();
        int n3 = text.getWidth();
        int n4 = n + n3;
        String string = glintRenderContext.substituteVariables(text.getText());
        TextAlignment textAlignment = TextAlignment.get(text.getTextAlign());
        IGlint.FontId fontId = iGlint.defineFont(this.getGlintFont(glintRenderContext, text));
        Color color = ColorManager.lookup(text.getFontColor());
        IGlint.ColorId colorId = iGlint.defineColor(color);
        int n5 = text.getHeight() - text.getAscent();
        if (textAlignment == TextAlignment.LEFT) {
            iGlint.drawRotatedText(fontId, colorId, n4, n2 + n5, 1, 180, string);
        } else if (textAlignment == TextAlignment.RIGHT) {
            string = TextUtil.rightTrim(string);
            iGlint.drawRotatedText(fontId, colorId, n, n2 + n5, 2, 180, string);
        } else if (textAlignment == TextAlignment.CENTER) {
            iGlint.drawRotatedText(fontId, colorId, (n + n4) / 2, n2 + n5, 3, 180, string);
        } else if (textAlignment == TextAlignment.JUSTIFY) {
            iGlint.drawRotatedJustifiedText(fontId, colorId, n, n2 + n5, n3, 180, string);
        } else {
            m_Log.warn((Object)("Unknown alignment: " + String.valueOf(textAlignment)));
        }
    }

    protected void render270(GlintRenderContext glintRenderContext, Text text) {
        IGlint iGlint = glintRenderContext.getGlint();
        int n = text.getLeft();
        int n2 = text.getTop();
        int n3 = text.getWidth();
        int n4 = text.getHeight();
        int n5 = n2 + n4;
        String string = glintRenderContext.substituteVariables(text.getText());
        TextAlignment textAlignment = TextAlignment.get(text.getTextAlign());
        IGlint.FontId fontId = iGlint.defineFont(this.getGlintFont(glintRenderContext, text));
        Color color = ColorManager.lookup(text.getFontColor());
        IGlint.ColorId colorId = iGlint.defineColor(color);
        int n6 = text.getAscent();
        if (textAlignment == TextAlignment.LEFT) {
            iGlint.drawRotatedText(fontId, colorId, n + n6, n5, 1, 90, string);
        } else if (textAlignment == TextAlignment.RIGHT) {
            string = TextUtil.rightTrim(string);
            iGlint.drawRotatedText(fontId, colorId, n + n6, n2, 2, 90, string);
        } else if (textAlignment == TextAlignment.CENTER) {
            iGlint.drawRotatedText(fontId, colorId, n + n6, n2 + n4 / 2, 3, 90, string);
        } else if (textAlignment == TextAlignment.JUSTIFY) {
            iGlint.drawRotatedJustifiedText(fontId, colorId, n + n6, n5, n3, 90, string);
        } else {
            m_Log.warn((Object)("Unknown alignment: " + String.valueOf(textAlignment)));
        }
    }

    protected com.elixirtech.glint.Font getGlintFont(PhysicalRenderContext physicalRenderContext, Text text) {
        int n;
        Font font = FontUtil.getFont(text);
        boolean bl = text.isFontUnderline();
        boolean bl2 = text.isFontStrikethrough();
        int n2 = n = bl ? 4 : 0;
        if (font.isBold()) {
            n |= 1;
        }
        if (font.isItalic()) {
            n |= 2;
        }
        if (bl2) {
            n |= 8;
        }
        return com.elixirtech.glint.Font.newInstance(font.getName(), n, font.getSize());
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

