/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.odf;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.physical.odf.OdfGenerator;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.IOException;
import java.io.OutputStream;

public class OdfPageListener
implements PageListener {
    private final Result result;
    private PageSource m_PageSource;
    private boolean m_bInit;
    private OutputStream m_Out;
    private OdfGenerator m_Generator;

    public OdfPageListener(Result result) {
        this.result = result;
        this.m_PageSource = null;
        this.m_bInit = false;
        this.m_Out = null;
        this.m_Generator = null;
    }

    @Override
    public void startReport(PageSource psrc) {
        this.m_PageSource = psrc;
    }

    public void initParameters() {
        this.m_bInit = true;
        RenderDetails rd = this.m_PageSource.getRenderDetails();
        boolean snap = rd.isSet("Snap");
        try {
            this.m_Out = this.result.getOutputStream();
            this.m_Generator = new OdfGenerator(this.m_PageSource.getLogicalReport(), this.m_Out);
            this.m_Generator.setSnap(snap);
        }
        catch (IOException ex) {
            throw new RenderException("Error opening stream: " + ex, ex);
        }
    }

    @Override
    public void startPageSequence(PageSequence ps) {
        if (!this.m_bInit) {
            this.initParameters();
            return;
        }
    }

    @Override
    public void addPage(Page p) {
        try {
            this.m_Generator.renderPage(p);
        }
        catch (IOException ex) {
            throw new RenderException("Error writing page: " + ex, ex);
        }
    }

    @Override
    public void endPageSequence(PageSequence ps) {
    }

    @Override
    public void endReport(PageSource psrc) {
        if (this.m_bInit) {
            try {
                this.m_Generator.close();
                this.m_Out.close();
            }
            catch (IOException ex) {
                throw new RenderException("Error closing stream: " + ex, ex);
            }
            this.m_Generator = null;
            this.m_Out = null;
            return;
        }
    }
}

