/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.pdf.BasicPhysicalRenderer;
import com.elixirtech.report2.physical.pdf.PDFRenderContext;
import com.elixirtech.report2.raw.constants.Alignment;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ImageRenderer
extends BasicPhysicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        Image image = (Image)logicalElement;
        java.awt.Image image2 = image.getImage();
        com.lowagie.text.Image image3 = null;
        if (image2 == null) {
            String string = image.getPicture();
            image3 = ((PDFRenderContext)physicalRenderContext).getITextImage(string);
        } else {
            try {
                image3 = com.lowagie.text.Image.getInstance(image2, null);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't process image: " + String.valueOf(exception)));
            }
        }
        if (image3 != null) {
            this.renderImage((PDFRenderContext)physicalRenderContext, image, image3);
        }
    }

    protected void renderImage(PDFRenderContext pDFRenderContext, Image image, com.lowagie.text.Image image2) {
        Graphics2D graphics2D = (Graphics2D)pDFRenderContext.getGraphics();
        float f = image.getTop();
        float f2 = image.getLeft();
        float f3 = image.getWidth();
        float f4 = image.getHeight();
        int n = Alignment.getAlignmentId(image.getHorizontalAlign(), image.getVerticalAlign());
        String string = image.getSizeMode();
        float f5 = image2.getWidth() * 20.0f;
        float f6 = image2.getHeight() * 20.0f;
        Rectangle2D rectangle2D = new Rectangle2D.Double(f2, f, f3, f4);
        if (string.equals("Clip")) {
            rectangle2D = Alignment.positionRect(rectangle2D, f5, f6, n);
            this.drawImage((PhysicalRenderContext)pDFRenderContext, (Graphics)graphics2D, image2, (float)rectangle2D.getMinX(), (float)rectangle2D.getMinY());
        } else if (string.equals("Stretch")) {
            this.drawImage((PhysicalRenderContext)pDFRenderContext, (Graphics)graphics2D, image2, rectangle2D, new Rectangle2D.Float(0.0f, 0.0f, f5, f6));
        } else if (string.equals("Zoom")) {
            float f7 = f3 / f5;
            float f8 = f4 / f6;
            if (f7 >= f8) {
                f5 = f8 * f5;
                f6 = f4;
            } else {
                f5 = f3;
                f6 = f7 * f6;
            }
            rectangle2D = Alignment.positionRect(rectangle2D, f5, f6, n);
            this.drawImage((PhysicalRenderContext)pDFRenderContext, (Graphics)graphics2D, image2, rectangle2D, new Rectangle2D.Float(0.0f, 0.0f, f5, f6));
        }
        String string2 = image.getURL();
        if (StringUtil.notEmpty(string2)) {
            PdfContentByte pdfContentByte = pDFRenderContext.getDirectContent();
            PdfAction pdfAction = new PdfAction(string2);
            Point2D point2D = pDFRenderContext.transform(f2 / 20.0f, (f + f4) / 20.0f);
            Point2D point2D2 = pDFRenderContext.transform((f2 + f3) / 20.0f, f / 20.0f);
            pdfContentByte.setAction(pdfAction, (float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY());
        }
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

