/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.report2.physical.IPhysicalRendererFactory;
import com.elixirtech.report2.physical.pdf.GlintRenderer;
import com.elixirtech.report2.physical.pdf.GridRenderer;
import com.elixirtech.report2.physical.pdf.ImageRenderer;
import com.elixirtech.report2.physical.pdf.LineRenderer;
import com.elixirtech.report2.physical.pdf.RTFRenderer;
import com.elixirtech.report2.physical.pdf.RectRenderer;
import com.elixirtech.report2.physical.pdf.SVGRenderer;
import com.elixirtech.report2.physical.pdf.TextRenderer2;
import com.elixirtech.report2.physical.renderer.IPhysicalRenderer;
import java.util.HashMap;
import java.util.Map;

public class PDFFactory
implements IPhysicalRendererFactory {
    private Map<String, IPhysicalRenderer> m_Map = new HashMap<String, IPhysicalRenderer>();

    public PDFFactory() {
        this.m_Map.put("rect", new RectRenderer());
        this.m_Map.put("text", new TextRenderer2());
        this.m_Map.put("image", new ImageRenderer());
        this.m_Map.put("line", new LineRenderer());
        this.m_Map.put("svg", new SVGRenderer());
        this.m_Map.put("rtf", new RTFRenderer());
        this.m_Map.put("glint", new GlintRenderer());
        this.m_Map.put("grid", new GridRenderer());
    }

    @Override
    public MimeType getMimeType() {
        return MimeTypes.PDF();
    }

    @Override
    public IPhysicalRenderer getRenderer(String string) {
        return this.m_Map.get(string);
    }
}

