/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.glint.TOC;
import com.elixirtech.pdf.ElxPdfGraphics2D;
import com.elixirtech.report2.IRenderFactory;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.physical.pdf.PDFPhysicalRenderer;
import com.elixirtech.report2.physical.pdf.PDFReportFontMapper;
import com.elixirtech.report2.physical.pdf.TextRenderer2;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.util.MetricConvertor;
import com.elixirtech.report2.util.ParameterManager;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.typesafe.config.Config;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PDFGenerator
implements RenderConstants {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PDFGenerator.class);
    public static boolean FORCED_API_MODE = System.getProperties().containsKey("elx.pdf.force.api.mode");
    public static boolean FORCED_GRAPHICS_MODE = System.getProperties().containsKey("elx.pdf.force.graphics.mode");
    public static boolean MERGE_IMAGES = true;
    public static final String CJK_MAPPING_URL = "CJKMappingURL";
    public static final String[] TYPE_TRUE_TYPE_FONTS = new String[]{"Courier New", "Courier New Bold", "Courier New Italic", "Courier New Bold Italic", "Times New Roman", "Times New Roman Bold", "Times New Roman Italic", "Times New Roman Bold Italic"};
    public static final String[] TYPE1_PDF_FONTS = new String[]{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic"};
    public static final String PLAIN = "plain".intern();
    public static final String BOLD = "bold.intern()";
    public static final String ITALIC = "italic".intern();
    public static final String BOLD_ITALIC = "bold+italic".intern();
    public static final String[] STYLES = new String[]{PLAIN, "bold.intern()", ITALIC, BOLD_ITALIC};
    protected PageSource m_PageSource;
    protected LogicalReport m_Logical;
    protected OutputStream m_Output;
    protected PdfWriter m_Writer;
    protected FontMapper m_FontMapper;
    protected int m_DPI = 72;
    protected int m_Type;
    protected boolean m_IsRenderImage;
    protected boolean m_IsCmykTransparencyBlending;
    protected PhysicalRenderer m_Renderer;
    protected Document m_Document;
    protected int m_PageCount;
    protected boolean m_UseTemplatePageCount;
    protected PdfTemplate m_PageCountTemplate;
    protected BaseFont m_PageCountFont;
    protected float m_PageCountSize;
    protected static final PDFReportFontMapper m_DefaultFontMapper = new PDFReportFontMapper();
    protected static Set<String> m_SelectorFontNames = Collections.emptySet();
    protected static boolean m_IsSelector = false;
    protected static final HashMap<String, String[]> m_FontFaceNameMap;

    public PDFGenerator(OutputStream outputStream) {
        this.m_Output = outputStream;
    }

    public int getPageCount() {
        return this.m_PageCount;
    }

    public static PDFReportFontMapper getDefaultFontMapper() {
        return m_DefaultFontMapper;
    }

    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageSource = pageSource;
        this.m_Logical = pageSource.getLogicalReport();
    }

    private void initDocument(Page page) {
        this.m_UseTemplatePageCount = page.getPageCount() == 0;
        try {
            String string;
            Document.compress = true;
            PageSetup pageSetup = page.getPageSetup();
            Rectangle rectangle = new Rectangle((float)pageSetup.getWidth() / 20.0f, (float)pageSetup.getHeight() / 20.0f);
            this.m_Document = new Document(rectangle, pageSetup.getLeft() / 20, pageSetup.getRight() / 20, pageSetup.getTop() / 20, pageSetup.getBottom() / 20);
            this.m_Writer = PdfWriter.getInstance(this.m_Document, this.m_Output);
            this.m_Document.addCreator("Elixir Repertoire");
            ParameterManager parameterManager = new ParameterManager();
            parameterManager.addParameters(this.m_Logical.getParameterIterator());
            this.m_FontMapper = this.registerMapFont(parameterManager);
            RenderDetails renderDetails = this.m_Logical.getRenderDetails(MimeTypes.PDF().value());
            this.m_IsRenderImage = false;
            if (renderDetails != null) {
                if (renderDetails.isSet("Encryption")) {
                    String string2 = renderDetails.getParameterValue("OwnerPassword");
                    string = renderDetails.getParameterValue("UserPassword");
                    String string3 = renderDetails.getParameterValue("EncryptionStrength");
                    int n = 0;
                    if ("128 bits".equals(string3)) {
                        n = 1;
                    }
                    int n2 = 0;
                    if (renderDetails.isSet("AllowPrinting")) {
                        n2 |= 0x804;
                    }
                    if (renderDetails.isSet("AllowModifyContents")) {
                        n2 |= 8;
                    }
                    if (renderDetails.isSet("AllowCopy")) {
                        n2 |= 0x10;
                    }
                    if (renderDetails.isSet("AllowModifyAnnotations")) {
                        n2 |= 0x20;
                    }
                    if (renderDetails.isSet("AllowFillIn")) {
                        n2 |= 0x100;
                    }
                    if (renderDetails.isSet("AllowScreenReaders")) {
                        n2 |= 0x200;
                    }
                    if (renderDetails.isSet("AllowAssembly")) {
                        n2 |= 0x400;
                    }
                    if (renderDetails.isSet("AllowDegradedPrinting")) {
                        n2 |= 4;
                    }
                    byte[] byArray = PdfWriter.getISOBytes(string);
                    byte[] byArray2 = PdfWriter.getISOBytes(string2);
                    this.m_Writer.setEncryption(byArray, byArray2, n2, n);
                }
                this.m_IsRenderImage = renderDetails.isSet("RenderAsImage");
                this.m_IsCmykTransparencyBlending = renderDetails.isSet("CmykTransparencyBlending");
            }
            this.m_Writer.setRgbTransparencyBlending(!this.m_IsCmykTransparencyBlending);
            boolean bl = false;
            if (renderDetails != null) {
                bl = renderDetails.isSet("RenderTextAPI");
            }
            if (FORCED_GRAPHICS_MODE) {
                bl = false;
            }
            if (FORCED_API_MODE) {
                bl = true;
            }
            if (bl) {
                this.m_Document.addCreator("Elixir Report [iText API mode]");
            } else {
                this.m_Document.addCreator("Elixir Report [graphics mode]");
            }
            this.m_Document.addTitle(this.m_Logical.getCaption());
            this.m_DPI = 72;
            this.m_Type = 2;
            if (this.m_IsRenderImage && renderDetails != null) {
                string = renderDetails.getParameterValue("RenderAsImageDPI");
                if (StringUtil.notEmpty(string)) {
                    try {
                        this.m_DPI = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.error((Object)("Can't parse RenderAsImageDPI value: " + string));
                    }
                }
                if (renderDetails.isSet("Greyscale")) {
                    this.m_Type = 10;
                }
            }
            this.m_Document.open();
            this.m_Renderer = this.m_IsRenderImage ? new EyeRenderer(true) : new PDFPhysicalRenderer(this, this.m_Writer, this.m_FontMapper);
            this.m_Renderer.startReport(this.m_PageSource);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPage(Page page) throws RenderException {
        if (this.m_Document == null) {
            this.initDocument(page);
        }
        try {
            PageSetup pageSetup = page.getPageSetup();
            int n = pageSetup.getHorizontalPageCount();
            this.m_Writer.flush();
            Rectangle rectangle = new Rectangle((float)pageSetup.getWidth() / 20.0f, (float)pageSetup.getHeight() / 20.0f);
            for (int i = 0; i < n; ++i) {
                this.m_Document.setPageSize(rectangle);
                this.m_Document.setMargins(pageSetup.getLeft() / 20, pageSetup.getRight() / 20, pageSetup.getTop() / 20, pageSetup.getBottom() / 20);
                if (i != 0 || this.m_PageCount != 0) {
                    this.m_Document.newPage();
                }
                int n2 = MetricConvertor.twipToPoint(pageSetup.getWidth());
                int n3 = MetricConvertor.twipToPoint(pageSetup.getHeight());
                PdfContentByte pdfContentByte = this.m_Writer.getDirectContent();
                pdfContentByte.saveState();
                pdfContentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                ElxPdfGraphics2D elxPdfGraphics2D = new ElxPdfGraphics2D(pdfContentByte, n2, n3, this.m_FontMapper, false);
                try {
                    if (this.m_IsRenderImage) {
                        BufferedImage bufferedImage = this.m_Renderer.renderPageToImage(page, i, this.m_DPI, this.m_Type);
                        ((Graphics)elxPdfGraphics2D).drawImage(bufferedImage, 0, 0, n2, n3, 0, 0, ((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null), null);
                        bufferedImage.flush();
                    } else {
                        this.m_Renderer.renderPage(page, i, elxPdfGraphics2D);
                    }
                }
                finally {
                    ((Graphics)elxPdfGraphics2D).dispose();
                    pdfContentByte.restoreState();
                }
                ++this.m_PageCount;
            }
        }
        catch (Exception exception) {
            throw new RenderException("Error writing page: " + String.valueOf(exception), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReport(PageSource pageSource) {
        if (this.m_Document != null) {
            Object object;
            Object object2;
            Object object3;
            RenderDetails renderDetails = this.m_Logical.getRenderDetails(MimeTypes.PDF().value());
            if (renderDetails != null && StringUtil.notEmpty((String)(object3 = renderDetails.getParameterValue("InitialZoom")))) {
                try {
                    float f;
                    object2 = object3;
                    object2 = ((String)object2).trim();
                    if (((String)object2).endsWith("%")) {
                        object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                        object2 = ((String)object2).trim();
                    }
                    if ((f = Float.parseFloat((String)object2)) > 0.0f) {
                        object = PdfAction.gotoLocalPage(1, new PdfDestination(0, -1.0f, -1.0f, f / 100.0f), this.m_Writer);
                        this.m_Writer.setOpenAction((PdfAction)object);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.warn((Object)("Invalid initialZoom value: " + (String)object3));
                }
            }
            if ((object3 = this.m_Renderer.getTOCIterator()).hasNext()) {
                object2 = this.m_Writer.getDirectContent();
                PdfOutline pdfOutline = ((PdfContentByte)object2).getRootOutline();
                while (object3.hasNext()) {
                    object = (TOC)object3.next();
                    this.processTOC((PdfContentByte)object2, pdfOutline, (TOC)object);
                }
            }
            this.m_Document.close();
        } else {
            boolean bl;
            RenderDetails renderDetails = this.m_Logical.getRenderDetails(MimeTypes.PDF().value());
            boolean bl2 = renderDetails != null && renderDetails.isSet("BlankPageOnEmptyFile");
            boolean bl3 = bl = System.getProperty("elx.pdf.blankpageonemptyfile") != null;
            if (bl2 || bl) {
                Rectangle rectangle = new Rectangle(595.25f, 841.85f);
                this.m_Document = new Document(rectangle);
                try {
                    this.m_Writer = PdfWriter.getInstance(this.m_Document, this.m_Output);
                    this.m_Document.addTitle(this.m_Logical.getCaption());
                    this.m_Document.addCreator("Elixir Repertoire");
                    this.m_Document.open();
                    this.m_Document.newPage();
                    PdfContentByte pdfContentByte = this.m_Writer.getDirectContent();
                    pdfContentByte.saveState();
                    pdfContentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                    pdfContentByte.restoreState();
                    this.m_Writer.flush();
                }
                catch (DocumentException documentException) {
                }
                finally {
                    if (this.m_Document.isOpen()) {
                        this.m_Document.close();
                    }
                }
            }
        }
    }

    public boolean useTemplatePageCount() {
        return this.m_UseTemplatePageCount;
    }

    public boolean hasPageCountTemplate() {
        return this.m_PageCountTemplate != null;
    }

    public void completePageCountTemplate(int n) {
        if (this.m_PageCountTemplate != null) {
            this.m_PageCountTemplate.beginText();
            this.m_PageCountTemplate.setFontAndSize(this.m_PageCountFont, this.m_PageCountSize);
            this.m_PageCountTemplate.setTextMatrix(0.0f, 0.0f);
            this.m_PageCountTemplate.showText(String.valueOf(n));
            this.m_PageCountTemplate.endText();
            this.m_PageCountTemplate = null;
        }
    }

    public void definePageCountTemplate(BaseFont baseFont, float f) {
        this.m_PageCountTemplate = this.m_Writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.m_PageCountTemplate.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        this.m_PageCountFont = baseFont;
        this.m_PageCountSize = f;
    }

    public PdfTemplate getPageCountTemplate() {
        return this.m_PageCountTemplate;
    }

    private void processTOC(PdfContentByte pdfContentByte, PdfOutline pdfOutline, TOC tOC) {
        PdfOutline pdfOutline2 = pdfOutline;
        String string = tOC.getTitle();
        if (StringUtil.notEmpty(string)) {
            int n = tOC.getPageNo();
            if (this.m_Renderer instanceof PDFPhysicalRenderer) {
                int n2 = ((PDFPhysicalRenderer)this.m_Renderer).lookupPageIndex(n);
                if (n2 >= 0) {
                    PdfDestination pdfDestination = new PdfDestination(0, tOC.getLeft(), tOC.getTop(), 0.0f);
                    PdfAction pdfAction = PdfAction.gotoLocalPage(n2 + 1, pdfDestination, this.m_Writer);
                    pdfOutline2 = new PdfOutline(pdfOutline, pdfAction, string);
                }
            } else {
                return;
            }
        }
        Iterator<TOC> iterator = tOC.getChildIterator();
        while (iterator.hasNext()) {
            TOC tOC2 = iterator.next();
            this.processTOC(pdfContentByte, pdfOutline2, tOC2);
        }
    }

    private FontMapper registerMapFont(ParameterManager parameterManager) {
        try {
            PDFReportFontMapper pDFReportFontMapper = (PDFReportFontMapper)m_DefaultFontMapper.clone();
            IRenderFactory iRenderFactory = (IRenderFactory)Elixir.get(IRenderFactory.class);
            Map<String, String> map = iRenderFactory.getPDFFontEncodingMap();
            pDFReportFontMapper.mapFontEncoding(map);
            Config config = (Config)Elixir.get(Config.class);
            RenderDetails renderDetails = this.m_PageSource.getRenderDetails();
            String string = renderDetails.getParameterValue(CJK_MAPPING_URL);
            if (StringUtil.notEmpty(string)) {
                PDFGenerator.registerCJKFontMap(string, pDFReportFontMapper);
            }
            return pDFReportFontMapper;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            m_Log.error((Object)"Can't clone FontMapper");
            return m_DefaultFontMapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void registerCJKFontMap(String var0, DefaultFontMapper var1_1) {
        var2_2 = null;
        try {
            var3_3 = (IRenderFactory)Elixir.get(IRenderFactory.class);
            var4_7 = URLLoader.getInputStream(var0);
            var2_2 = new BufferedReader(new InputStreamReader(var4_7, "UTF-8"));
            block11: while (true) {
                if ((var5_8 = var2_2.readLine()) == null) {
                    break;
                }
                if ((var5_8 = var5_8.trim()).length() == 0 || var5_8.startsWith("#")) continue;
                var6_9 = StringUtil.keyAndValue(var5_8);
                var7_10 = var3_3.getPDFFontEncodingMap().get(var6_9[1]);
                var8_11 = PDFGenerator.getAWTNames(var6_9[0]);
                var9_12 = new DefaultFontMapper.BaseFontParameters(var6_9[1]);
                var9_12.encoding = var7_10;
                var9_12.embedded = false;
                var10_13 = 0;
                while (true) {
                    if (var10_13 < var8_11.length) ** break;
                    continue block11;
                    var1_1.putName(var8_11[var10_13], var9_12);
                    ++var10_13;
                }
                break;
            }
        }
        catch (Exception var3_5) {
            PDFGenerator.m_Log.error((Object)("Unable to load CJKFontMap: " + String.valueOf(var3_5)), (Throwable)var3_5);
        }
        finally {
            if (var2_2 != null) {
                try {
                    var2_2.close();
                }
                catch (IOException var3_6) {}
            }
        }
    }

    public static String[] getAWTNames(String string) {
        String[] stringArray = m_FontFaceNameMap.get(string);
        if (stringArray == null) {
            stringArray = new String[]{PDFGenerator.getFontName(string, false, false, "10"), PDFGenerator.getFontName(string, true, false, "10"), PDFGenerator.getFontName(string, false, true, "10"), PDFGenerator.getFontName(string, true, true, "10")};
            m_FontFaceNameMap.put(string, stringArray);
        }
        return stringArray;
    }

    private static String getFontName(String string, boolean bl, boolean bl2, String string2) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, string);
        hashMap.put(TextAttribute.SIZE, new Float(string2));
        hashMap.put(TextAttribute.WEIGHT, bl ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        hashMap.put(TextAttribute.POSTURE, bl2 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        Font font = new Font(hashMap);
        return font.getFontName();
    }

    private static void registerType1Fonts(DefaultFontMapper defaultFontMapper) {
        for (int i = 0; i < TYPE1_PDF_FONTS.length; ++i) {
            DefaultFontMapper.BaseFontParameters baseFontParameters = new DefaultFontMapper.BaseFontParameters(TYPE1_PDF_FONTS[i]);
            baseFontParameters.encoding = "Cp1252";
            baseFontParameters.embedded = false;
            defaultFontMapper.putName(TYPE_TRUE_TYPE_FONTS[i], baseFontParameters);
            m_Log.debug((Object)("registerType1Fonts: " + TYPE1_PDF_FONTS[i]));
        }
    }

    static {
        try {
            Object object;
            IRenderFactory iRenderFactory = (IRenderFactory)Elixir.get(IRenderFactory.class);
            String string = iRenderFactory.getProperty("elixirtech.fonts.path");
            m_Log.info((Object)("elixir.rml.fonts.path:" + string));
            PDFGenerator.registerType1Fonts(m_DefaultFontMapper);
            if (StringUtil.notEmpty(string) && new File(string).exists()) {
                m_Log.info((Object)("Setting fontsPath to " + new File(string).getAbsolutePath()));
                m_DefaultFontMapper.insertDirectory(string);
                object = iRenderFactory.getPDFFontEncodingMap();
                m_DefaultFontMapper.mapFontEncoding((Map<String, String>)object);
            } else {
                m_DefaultFontMapper.setPDFEncodingMapped(true);
                m_Log.warn((Object)"elixirtech.fonts.path not setup, font embedding in report for pdf format is not enabled. To setup please change the path elixir.rml.fonts.path in etc/application.conf.");
            }
            object = iRenderFactory.getPDFSelectorFontNames();
            if (object != null && !object.isEmpty()) {
                m_SelectorFontNames = object;
                m_IsSelector = !m_SelectorFontNames.isEmpty();
                TextRenderer2.OPTIMIZED = !m_IsSelector;
            } else {
                m_IsSelector = false;
                TextRenderer2.OPTIMIZED = true;
            }
            if (m_IsSelector) {
                m_Log.info((Object)"Font selection is enabled, PDF optimization is disabled.");
            } else {
                m_Log.info((Object)"Font selection is disabled, PDF optimization is enabled.");
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Get System font path warning, will use default PDF generation behavior:" + exception.toString()));
        }
        m_FontFaceNameMap = new HashMap();
    }
}

