/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.ppt;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.report2.html.ImageUtil;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.physical.ppt.PPTRenderContext;
import com.elixirtech.report2.physical.ppt.PPTRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.util.ImageLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ImageRenderer {
    private final PPTRenderer m_Renderer;
    private final Slide m_Slide;
    private final Image m_Image;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageRenderer.class);

    public ImageRenderer(PPTRenderer pPTRenderer, Slide slide, Image image) throws IOException {
        this.m_Renderer = pPTRenderer;
        this.m_Slide = slide;
        this.m_Image = image;
        PPTRenderContext.ImageInfo imageInfo = this.load();
        if (imageInfo != null) {
            this.output(imageInfo);
        }
    }

    private PPTRenderContext.ImageInfo load() {
        java.awt.Image image = this.m_Image.getImage();
        BufferedImage bufferedImage = null;
        if (image != null) {
            bufferedImage = (BufferedImage)image;
            return new PPTRenderContext.ImageInfo(null, null, bufferedImage);
        }
        PPTRenderContext pPTRenderContext = this.m_Renderer.getRenderContext();
        PPTRenderContext.ImageInfo imageInfo = pPTRenderContext.getImageInfo(this.m_Image.getPicture());
        if (imageInfo != null) {
            return imageInfo;
        }
        java.awt.Image image2 = ImageLoader.loadFromPath(this.m_Image.getPicture());
        if (image2 == null) {
            m_Log.warn((Object)("Actual image may not be available, check url of the image: " + this.m_Image.getPicture()));
            return null;
        }
        if (!(image2 instanceof BufferedImage)) {
            bufferedImage = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image2, 0, 0, null);
            graphics.dispose();
        } else {
            bufferedImage = (BufferedImage)image2;
        }
        imageInfo = new PPTRenderContext.ImageInfo(this.m_Image.getPicture(), null, bufferedImage);
        pPTRenderContext.setImageInfo(imageInfo);
        return imageInfo;
    }

    public void output(PPTRenderContext.ImageInfo imageInfo) throws IOException {
        int n = this.m_Renderer.getXOffset();
        int n2 = this.m_Renderer.getYOffset();
        int n3 = this.m_Image.getLeft();
        int n4 = this.m_Image.getTop();
        int n5 = this.m_Image.getWidth();
        int n6 = this.m_Image.getHeight();
        int n7 = Alignment.getAlignmentId(this.m_Image.getHorizontalAlign(), this.m_Image.getVerticalAlign());
        BufferedImage bufferedImage = imageInfo.image;
        Rectangle rectangle = null;
        boolean bl = true;
        if ("Clip".equals(this.m_Image.getSizeMode())) {
            BufferedImage bufferedImage2 = ImageUtil.clip(bufferedImage, new Dimension(n5 / 20, n6 / 20), n7);
            if (bufferedImage2 != bufferedImage) {
                bufferedImage = bufferedImage2;
                bl = false;
            }
            Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            Point point = Alignment.getTopLeft(dimension, new Dimension(n5 / 20, n6 / 20), n7);
            rectangle = new Rectangle(n + n3 + point.x * 20, n2 + n4 + point.y * 20, dimension.width * 20, dimension.height * 20);
        } else if ("Stretch".equals(this.m_Image.getSizeMode())) {
            Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            Point point = Alignment.getTopLeft(dimension, new Dimension(n5 / 20, n6 / 20), n7);
            rectangle = new Rectangle(n + n3 + point.x * 20, n2 + n4 + point.y * 20, n5, n6);
        } else if ("Zoom".equals(this.m_Image.getSizeMode())) {
            double d = (double)n5 / 20.0 / (double)bufferedImage.getWidth();
            double d2 = (double)n6 / 20.0 / (double)bufferedImage.getHeight();
            double d3 = Math.min(d, d2);
            Dimension dimension = new Dimension((int)((double)bufferedImage.getWidth() * d3), (int)((double)bufferedImage.getHeight() * d3));
            Point point = Alignment.getTopLeft(dimension, new Dimension(n5 / 20, n6 / 20), n7);
            rectangle = new Rectangle(n + n3 + point.x * 20, n2 + n4 + point.y * 20, dimension.width * 20, dimension.height * 20);
        }
        if (rectangle != null) {
            if (bl && imageInfo.location != null) {
                this.m_Slide.addImage(rectangle, imageInfo.location);
            } else {
                String string = this.m_Slide.addImage(rectangle, bufferedImage);
                if (bl) {
                    imageInfo.location = string;
                }
            }
        }
    }
}

