/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.ppt;

import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GLine;
import com.elixirtech.graphics.GraphicsLineDrawable;
import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.physical.ppt.PPTRenderer;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class LineRenderer {
    private final PPTRenderer m_Renderer;
    private final Slide m_Slide;
    private final Line m_Line;

    public LineRenderer(PPTRenderer pPTRenderer, Slide slide, Line line) throws IOException {
        this.m_Renderer = pPTRenderer;
        this.m_Slide = slide;
        this.m_Line = line;
        int n = this.m_Renderer.getXOffset();
        int n2 = this.m_Renderer.getYOffset();
        int n3 = this.m_Line.getLeft();
        int n4 = this.m_Line.getTop();
        int n5 = this.m_Line.getWidth();
        int n6 = this.m_Line.getHeight();
        int n7 = this.m_Line.getDivisor();
        int n8 = n3 + this.m_Line.getX1() * n5 / n7;
        int n9 = n4 + this.m_Line.getY1() * n6 / n7;
        int n10 = n3 + this.m_Line.getX2() * n5 / n7;
        int n11 = n4 + this.m_Line.getY2() * n6 / n7;
        GLine gLine = new GLine();
        gLine.setLine(n8, n9, n10, n11);
        gLine.setLineColor(StandardColor.lookup(this.m_Line.getLineColor(), Color.BLACK));
        gLine.setLineWidth(this.m_Line.getLineWidth());
        gLine.setLineStyle(BorderStyle.get(this.m_Line.getLineStyle()));
        gLine.setArrowStyle1(this.m_Line.getArrowStyle1());
        gLine.setArrowStyle2(this.m_Line.getArrowStyle2());
        gLine.setArrowWidth1(this.m_Line.getArrowWidth1());
        gLine.setArrowWidth2(this.m_Line.getArrowWidth2());
        gLine.setArrowColor1(StandardColor.lookup(this.m_Line.getArrowColor1(), Color.BLACK));
        gLine.setArrowColor2(StandardColor.lookup(this.m_Line.getArrowColor2(), Color.BLACK));
        BufferedImage bufferedImage = new BufferedImage(n5 / 20, n6 / 20, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(0.05, 0.05);
        graphics2D.translate(-n3, -n4);
        gLine.draw(new GraphicsLineDrawable(graphics2D));
        graphics2D.dispose();
        Rectangle rectangle = new Rectangle(n3 + n, n4 + n2, n5, n6);
        this.m_Slide.addImage(rectangle, bufferedImage);
    }
}

