/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.ppt;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.opc.ContentTypes;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.ZipWriter;
import com.elixirtech.opc.ppt.Presentation;
import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.ppt.GlintRenderer;
import com.elixirtech.report2.physical.ppt.GridRenderer;
import com.elixirtech.report2.physical.ppt.ImageRenderer;
import com.elixirtech.report2.physical.ppt.LineRenderer;
import com.elixirtech.report2.physical.ppt.PPTRenderContext;
import com.elixirtech.report2.physical.ppt.RectRenderer;
import com.elixirtech.report2.physical.ppt.SVGRenderer;
import com.elixirtech.report2.physical.ppt.TextRenderer;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.VariableSubstitution;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class PPTRenderer
implements VariableSubstitution.ICallback {
    private final RenderDetails m_RenderDetails;
    private final Package m_Package;
    private final Presentation m_Presentation;
    private final PPTRenderContext m_RenderContext = new PPTRenderContext();
    private Slide m_CurrentSlide;
    private int m_SlideNumber;
    private int m_XOffset;
    private int m_YOffset;
    private int m_PageNo;
    private int m_PageCount;

    public PPTRenderer(RenderDetails renderDetails, PageSetup pageSetup) throws IOException {
        this.m_RenderDetails = renderDetails;
        int n = (int)((long)pageSetup.getWidth() * 635L);
        int n2 = (int)((long)pageSetup.getHeight() * 635L);
        Dimension dimension = new Dimension(n, n2);
        this.m_Package = new Package();
        RelationshipsPart relationshipsPart = this.m_Package.getRelationships();
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument", "ppt/presentation.xml"));
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties", "docProps/app.xml"));
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", "docProps/core.xml"));
        relationshipsPart.addRelationship(new Relationship("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail", "docProps/thumbnail.wmf"));
        this.m_Presentation = new Presentation("/ppt/presentation.xml", dimension);
    }

    public void addPage(Page page) throws IOException {
        if (this.m_CurrentSlide != null) {
            this.m_Presentation.addSlide(this.m_CurrentSlide);
        }
        this.renderPage(page);
    }

    public int getXOffset() {
        return this.m_XOffset;
    }

    public int getYOffset() {
        return this.m_YOffset;
    }

    public PPTRenderContext getRenderContext() {
        return this.m_RenderContext;
    }

    public RenderDetails getRenderDetails() {
        return this.m_RenderDetails;
    }

    @Override
    public String getValue(String string) {
        if ("#".equals(string)) {
            return String.valueOf(this.m_PageNo);
        }
        if ("##".equals(string)) {
            return String.valueOf(this.m_PageCount);
        }
        return null;
    }

    private void renderPage(Page page) throws IOException {
        this.m_CurrentSlide = new Slide(this.m_Presentation.getIDGenerator(), "/ppt/slides/slide" + ++this.m_SlideNumber + ".xml");
        Page page2 = page.getWatermark();
        if (page2 != null) {
            this.renderPageContents(page2);
        }
        this.renderPageContents(page);
    }

    private void renderPageContents(Page page) throws IOException {
        PageSetup pageSetup = page.getPageSetup();
        this.m_XOffset = pageSetup.getLeft();
        this.m_YOffset = pageSetup.getTop();
        this.m_PageNo = page.getPageNumber();
        this.m_PageCount = page.getPageCount();
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            this.renderChunk(pageHeader);
            this.m_YOffset += pageHeader.getHeight();
        }
        for (BodyPart bodyPart : page.getBody().getBodyPartList()) {
            this.renderChunk(bodyPart);
            this.m_YOffset += bodyPart.getHeight();
        }
        PageFooter pageFooter = page.getPageFooter();
        if (pageFooter != null) {
            int n;
            int n2 = pageFooter.getHeight();
            this.m_YOffset = n = pageSetup.getHeight() - pageSetup.getBottom() - n2;
            this.renderChunk(pageFooter);
        }
    }

    private void renderChunk(LogicalElementHolder logicalElementHolder) throws IOException {
        if (logicalElementHolder instanceof Columns) {
            Columns columns = (Columns)logicalElementHolder;
            int n = 0;
            int n2 = this.m_XOffset;
            int n3 = this.m_YOffset;
            Iterator<Column> iterator = columns.getColumnIterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                int n4 = this.renderColumn(column);
                n = Math.max(n, n4);
                if (iterator.hasNext()) {
                    int n5 = column.getWidth() + column.getSpaceAfter();
                    this.m_XOffset += n5;
                }
                this.m_YOffset = n3;
            }
            this.m_XOffset = n2;
            this.m_YOffset = n3 + n;
        } else {
            String string = logicalElementHolder.getBackgroundColor();
            if (StringUtil.notEmpty(string)) {
                int n = logicalElementHolder.getWidth();
                int n6 = logicalElementHolder.getHeight();
                java.awt.Rectangle rectangle = new java.awt.Rectangle(this.m_XOffset, this.m_YOffset, n, n6);
                this.m_CurrentSlide.addRectangle(rectangle, StandardColor.lookup(string), 0, null, 0);
            }
            for (LogicalElement logicalElement : logicalElementHolder.getLogicalElementList()) {
                this.renderElement(logicalElement);
            }
        }
    }

    private int renderColumn(Column column) throws IOException {
        int n = 0;
        for (BodyPart bodyPart : column.getBodyPartList()) {
            this.renderChunk(bodyPart);
            this.m_YOffset += bodyPart.getHeight();
            int n2 = bodyPart.getHeight() + bodyPart.getSpaceAfter();
            n += n2;
        }
        return n;
    }

    public void renderElement(LogicalElement logicalElement) throws IOException {
        if (logicalElement == null) {
            return;
        }
        if (logicalElement instanceof Rectangle) {
            new RectRenderer(this, this.m_CurrentSlide, (Rectangle)logicalElement);
        } else if (logicalElement instanceof Grid) {
            new GridRenderer(this, this.m_CurrentSlide, (Grid)logicalElement);
        } else if (logicalElement instanceof Text) {
            new TextRenderer(this, this.m_CurrentSlide, (Text)logicalElement);
        } else if (logicalElement instanceof Image) {
            new ImageRenderer(this, this.m_CurrentSlide, (Image)logicalElement);
        } else if (logicalElement instanceof Line) {
            new LineRenderer(this, this.m_CurrentSlide, (Line)logicalElement);
        } else if (logicalElement instanceof Glint) {
            new GlintRenderer(this, this.m_CurrentSlide, (Glint)logicalElement);
        } else if (logicalElement instanceof SVG) {
            new SVGRenderer(this, this.m_CurrentSlide, (SVG)logicalElement);
        }
    }

    public void endReport(OutputStream outputStream) throws IOException {
        if (this.m_CurrentSlide != null) {
            this.m_Presentation.addSlide(this.m_CurrentSlide);
        }
        this.m_Package.addPart(this.m_Presentation);
        for (Part part : this.m_Presentation.getSubParts()) {
            this.m_Package.addPart(part);
        }
        this.m_Package.addPart(new ContentTypes(this.m_Package));
        ZipWriter.write(this.m_Package, outputStream);
    }
}

