/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.ppt;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.ppt.PPTRenderer;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class RectRenderer {
    private final PPTRenderer m_Renderer;
    private final Slide m_Slide;
    private final com.elixirtech.report2.logical.model.Rectangle m_Rectangle;

    public RectRenderer(PPTRenderer pPTRenderer, Slide slide, com.elixirtech.report2.logical.model.Rectangle rectangle) throws IOException {
        this.m_Renderer = pPTRenderer;
        this.m_Slide = slide;
        this.m_Rectangle = rectangle;
        if (this.canRenderNativeRect(rectangle)) {
            this.renderNative();
        } else {
            this.renderImage();
        }
        for (LogicalElement logicalElement : rectangle.getLogicalElementList()) {
            this.m_Renderer.renderElement(logicalElement);
        }
    }

    private boolean canRenderNativeRect(com.elixirtech.report2.logical.model.Rectangle rectangle) {
        if (rectangle.getBorderRadius() > 0) {
            return false;
        }
        if (StringUtil.isEmpty(rectangle.getBorderColor())) {
            return true;
        }
        if (rectangle.getBorderWidth() == 0) {
            return true;
        }
        if (!this.hasAllBorders()) {
            return false;
        }
        BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
        switch (borderStyle.ID) {
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 6: {
                return false;
            }
            case 11: {
                return false;
            }
        }
        return true;
    }

    private void renderNative() throws IOException {
        int n = this.m_Rectangle.getBorderWidth();
        int n2 = this.m_Renderer.getXOffset();
        int n3 = this.m_Renderer.getYOffset();
        int n4 = this.m_Rectangle.getLeft();
        int n5 = this.m_Rectangle.getTop();
        int n6 = this.m_Rectangle.getWidth();
        int n7 = this.m_Rectangle.getHeight();
        if (n <= 20) {
            Rectangle rectangle = new Rectangle(n2 + n4, n3 + n5, n6, n7);
            String string = this.m_Rectangle.getBackgroundColor();
            Color color = StringUtil.notEmpty(string) ? StandardColor.lookup(string) : null;
            BorderStyle borderStyle = BorderStyle.get(this.m_Rectangle.getBorderStyle());
            Color color2 = StandardColor.lookup(this.m_Rectangle.getBorderColor(), (Color)null);
            this.m_Slide.addRectangle(rectangle, color, borderStyle.ID, color2, n);
        } else {
            Rectangle rectangle = new Rectangle(n2 + n4, n3 + n5, n6, n7);
            String string = this.m_Rectangle.getBackgroundColor();
            Color color = StringUtil.notEmpty(string) ? StandardColor.lookup(string) : null;
            this.m_Slide.addRectangle(rectangle, color, 0, null, 0);
            rectangle.x += n / 2;
            rectangle.y += n / 2;
            rectangle.width -= n;
            rectangle.height -= n;
            BorderStyle borderStyle = BorderStyle.get(this.m_Rectangle.getBorderStyle());
            Color color3 = StandardColor.lookup(this.m_Rectangle.getBorderColor(), (Color)null);
            this.m_Slide.addRectangle(rectangle, null, borderStyle.ID, color3, n);
        }
    }

    private void renderImage() throws IOException {
        Transparency transparency;
        int n = this.m_Renderer.getXOffset();
        int n2 = this.m_Renderer.getYOffset();
        int n3 = this.m_Rectangle.getLeft();
        int n4 = this.m_Rectangle.getTop();
        int n5 = this.m_Rectangle.getWidth();
        int n6 = this.m_Rectangle.getHeight();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        GRectangle gRectangle = new GRectangle(new Rectangle(0, 0, n5, n6));
        gRectangle.setPadding(this.m_Rectangle.getPaddingLeft(), this.m_Rectangle.getPaddingTop(), this.m_Rectangle.getPaddingRight(), this.m_Rectangle.getPaddingBottom());
        gRectangle.setCurvedClip(this.m_Rectangle.isCurvedClip());
        gRectangle.setPaddedClip(this.m_Rectangle.isPaddedClip());
        String string = this.m_Rectangle.getBackgroundColor();
        if (string != null) {
            gRectangle.setBackground(StandardColor.lookup(string));
        }
        BorderStyle borderStyle = BorderStyle.get(this.m_Rectangle.getBorderStyle());
        int n7 = this.m_Rectangle.getBorderRadius();
        int n8 = this.m_Rectangle.getBorderWidth();
        int n9 = 0;
        if (borderStyle != BorderStyle.NONE) {
            if (this.m_Rectangle.isBorderLeft()) {
                n9 |= 1;
            }
            if (this.m_Rectangle.isBorderTop()) {
                n9 |= 2;
            }
            if (this.m_Rectangle.isBorderRight()) {
                n9 |= 4;
            }
            if (this.m_Rectangle.isBorderBottom()) {
                n9 |= 8;
            }
            transparency = StandardColor.lookup(this.m_Rectangle.getBorderColor());
            gRectangle.setBorder(borderStyle, n8, (Color)transparency, n9);
        }
        if (n7 > 0) {
            gRectangle.setBorderRadius(n7, n7);
        }
        transparency = new BufferedImage(n5 / 20, n6 / 20, 2);
        Graphics2D graphics2D = transparency.createGraphics();
        if (gRectangle.willDraw()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.scale(0.05, 0.05);
            gRectangle.draw(graphics2D);
            graphics2D.scale(20.0, 20.0);
        }
        graphics2D.dispose();
        Rectangle rectangle = new Rectangle(n + n3, n2 + n4, n5, n6);
        this.m_Slide.addImage(rectangle, (BufferedImage)transparency);
    }

    private boolean hasAllBorders() {
        return this.m_Rectangle.isBorderLeft() && this.m_Rectangle.isBorderTop() && this.m_Rectangle.isBorderRight() && this.m_Rectangle.isBorderBottom();
    }
}

