/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw;

import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;

public class CacheBuilder {
    public static void build(RawReport rawReport) {
        rawReport.cacheProperties();
        for (Section section : rawReport.getSectionList()) {
            CacheBuilder.build(section);
        }
    }

    public static void build(Section section) {
        section.cacheProperties();
        CacheBuilder.build(section.getSectionHeader());
        CacheBuilder.build(section.getPageHeader());
        for (Group group : section.getGroupList()) {
            CacheBuilder.build(group);
        }
        CacheBuilder.build(section.getDetail());
        CacheBuilder.build(section.getPageFooter());
        CacheBuilder.build(section.getSectionFooter());
    }

    public static void build(Group group) {
        group.cacheProperties();
        CacheBuilder.build(group.getGroupHeader());
        CacheBuilder.build(group.getGroupFooter());
    }

    public static void build(IRawElementHolder iRawElementHolder) {
        if (iRawElementHolder != null) {
            iRawElementHolder.cacheProperties();
            for (RawModelElement rawModelElement : iRawElementHolder.getRawElementList()) {
                if (rawModelElement instanceof IRawElementHolder) {
                    CacheBuilder.build((IRawElementHolder)((Object)rawModelElement));
                    continue;
                }
                rawModelElement.cacheProperties();
            }
        }
    }
}

