/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.raw.Migrator;
import com.elixirtech.report2.raw.RMLUtil;
import com.elixirtech.report2.raw.model.Metadata;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RawReportSAX;
import com.elixirtech.sax.BasicSAXDelegate;
import com.elixirtech.sax.delegates.EncryptedSAX;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RMLSAXUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RMLSAXUtil.class);

    public static RawReport readRML(InputStream inputStream) throws IOException {
        m_Log.debug((Object)"readRML(is");
        try {
            int n;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            EncryptedSAX encryptedSAX = new EncryptedSAX(new RawReportSAX());
            sAXParser.parse(inputStream, (DefaultHandler)encryptedSAX);
            RawReport rawReport = (RawReport)((BasicSAXDelegate)encryptedSAX).getObject();
            rawReport.loaded();
            Metadata metadata = rawReport.getMetadata();
            int n2 = n = metadata == null ? 1 : metadata.getVersion();
            if (n != RMLUtil.VERSION()) {
                new Migrator(rawReport, n);
            }
            return rawReport;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            m_Log.error((Object)("readRML: " + String.valueOf(parserConfigurationException)), (Throwable)parserConfigurationException);
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            m_Log.error((Object)("readRML: " + String.valueOf(sAXException)), (Throwable)sAXException);
            throw new IOException(sAXException.toString());
        }
    }
}

