/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.IStyledElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ElementTreeModel
implements TreeModel {
    private IRawElementHolder m_Root;
    private List<TreeModelListener> m_Listeners = new ArrayList<TreeModelListener>();
    private boolean m_IsDirty;

    public ElementTreeModel(IRawElementHolder iRawElementHolder) {
        this.m_Root = iRawElementHolder;
    }

    public boolean isDirty() {
        return this.m_IsDirty;
    }

    public void setDirty(boolean bl) {
        this.m_IsDirty = bl;
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.add(treeModelListener);
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.remove(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        IRawElementHolder iRawElementHolder = (IRawElementHolder)object;
        return iRawElementHolder.getRawElement(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (!(object instanceof IRawElementHolder)) {
            return 0;
        }
        IRawElementHolder iRawElementHolder = (IRawElementHolder)object;
        return iRawElementHolder.getRawElementCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object2 instanceof RawModelElement && object != null) {
            IRawElementHolder iRawElementHolder = (IRawElementHolder)object;
            return iRawElementHolder.indexOfRawElement((RawModelElement)object2);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.m_Root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return !(object instanceof IRawElementHolder);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public TreePath getTreePath(RawModelElement rawModelElement) {
        ArrayList<IStyledElement> arrayList = new ArrayList<IStyledElement>();
        arrayList.add(0, rawModelElement);
        for (IRawElementHolder iRawElementHolder = rawModelElement.getParent(); iRawElementHolder != null; iRawElementHolder = iRawElementHolder.getParent()) {
            arrayList.add(0, iRawElementHolder);
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return new TreePath(objectArray);
    }

    public void fireInsertedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireInsertedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireStructureChangedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireStructureChangedEvent(treeModelEvent);
    }

    private void fireInsertedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireRemovedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireChangedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    private void fireStructureChangedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }
}

