/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.report2.raw.model.IFormatHolder;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.TextElement;
import com.elixirtech.report2.raw.property.LineHeight;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;

public class Field
extends TextElement
implements IBean,
PropertyImplementor,
IControlSourceHolder,
IFormatHolder {
    protected Format m_Format;
    protected ControlSource m_ControlSource;
    protected Locale m_Locale;
    protected Boolean m_HideDuplicates;
    protected Boolean m_AutoWrap = true;
    protected Integer m_Orientation;
    protected String m_LineHeight;
    private LineHeight m_LineHeightValue;
    private static String[] m_PropertyNameStrings = new String[]{"Common.Locale".intern(), "Field.HideDuplicates".intern(), "Field.AutoWrap".intern(), "Field.Orientation".intern(), "Field.LineHeight".intern(), "Field.Format".intern(), "Field.ControlSource".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Locale", "Boolean", "Boolean", "Integer", "String", "Format", "ControlSource"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "field";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Format != null) {
            this.m_Format.loaded();
        }
        if (this.m_ControlSource != null) {
            this.m_ControlSource.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Format != null) {
            if (this.m_Format != null) {
                this.m_Format.dispose();
            }
            this.m_Format = null;
        }
        if (this.m_ControlSource != null) {
            if (this.m_ControlSource != null) {
                this.m_ControlSource.dispose();
            }
            this.m_ControlSource = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Locale != null) {
            element.setAttribute("locale", this.m_Locale.toString());
        }
        if (this.m_HideDuplicates != null) {
            element.setAttribute("hide-duplicates", this.m_HideDuplicates != false ? "Yes" : "No");
        }
        if (this.m_AutoWrap != null) {
            element.setAttribute("auto-wrap", this.m_AutoWrap != false ? "Yes" : "No");
        }
        if (this.m_Orientation != null) {
            element.setAttribute("orientation", this.m_Orientation.toString());
        }
        if (this.m_LineHeight != null) {
            element.setAttribute("line-height", this.m_LineHeight);
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Field field = (Field)super.shallowCopy();
        return field;
    }

    public String getText() {
        return this.getControlSource().getText();
    }

    public String getType() {
        return this.getControlSource().getType();
    }

    public void setText(String string) {
        try {
            this.m_ControlSource = (ControlSource)this.getControlSource().shallowCopy();
            this.m_ControlSource.setText(string);
        }
        catch (Exception exception) {
            Field.logError("setText error: " + String.valueOf(exception));
        }
    }

    public void setType(String string) {
        try {
            this.m_ControlSource = (ControlSource)this.getControlSource().shallowCopy();
            this.m_ControlSource.setType(string);
        }
        catch (Exception exception) {
            Field.logError("setType error: " + String.valueOf(exception));
        }
    }

    @Override
    protected String getDefaultStyle() {
        if (this.m_ControlSource != null && "Literal".equals(this.m_ControlSource.getType())) {
            return "field.literal";
        }
        return super.getDefaultStyle();
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    @Override
    public Format getFormat() {
        if (this.m_Format != null) {
            return this.m_Format;
        }
        return (Format)this.getDefaultPropertyValue(m_IndexOffset + 6 - 1);
    }

    @Override
    public void setFormat(Format format) {
        this.m_Format = format;
    }

    @Override
    public ControlSource getControlSource() {
        if (this.m_ControlSource != null) {
            return this.m_ControlSource;
        }
        return (ControlSource)this.getDefaultPropertyValue(m_IndexOffset + 7 - 1);
    }

    @Override
    public void setControlSource(ControlSource controlSource) {
        this.m_ControlSource = controlSource;
    }

    @Override
    public Locale getLocale() {
        if (this.m_Locale != null) {
            return this.m_Locale;
        }
        return (Locale)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setLocale(Locale locale) {
        this.m_Locale = locale;
    }

    public boolean isHideDuplicates() {
        Boolean bl = this.m_HideDuplicates;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
        }
        return bl;
    }

    public void setHideDuplicates(boolean bl) {
        this.m_HideDuplicates = bl;
    }

    public void setHideDuplicates(Boolean bl) {
        this.m_HideDuplicates = bl;
    }

    public boolean isAutoWrap() {
        Boolean bl = this.m_AutoWrap;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
        }
        return bl;
    }

    public void setAutoWrap(boolean bl) {
        this.m_AutoWrap = bl;
    }

    public void setAutoWrap(Boolean bl) {
        this.m_AutoWrap = bl;
    }

    public int getOrientation() {
        Integer n = this.m_Orientation;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
        }
        return n;
    }

    public void setOrientation(int n) {
        this.m_Orientation = n;
    }

    public void setOrientation(Integer n) {
        this.m_Orientation = n;
    }

    public String getLineHeight() {
        if (this.m_LineHeight != null) {
            return this.m_LineHeight;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 5 - 1);
    }

    public void setLineHeight(String string) {
        this.m_LineHeight = string;
        this.m_LineHeightValue = null;
    }

    public LineHeight getLineHeightValue() {
        if (this.m_LineHeightValue == null) {
            this.m_LineHeightValue = LineHeight.getInstance(this.getLineHeight());
        }
        return this.m_LineHeightValue;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_Locale = (Locale)object;
                        break;
                    }
                    case 1: {
                        this.m_HideDuplicates = (Boolean)object;
                        break;
                    }
                    case 2: {
                        this.m_AutoWrap = (Boolean)object;
                        break;
                    }
                    case 3: {
                        this.m_Orientation = (Integer)object;
                        break;
                    }
                    case 4: {
                        this.m_LineHeight = (String)object;
                        this.m_LineHeightValue = null;
                        break;
                    }
                    case 5: {
                        this.m_Format = (Format)object;
                        break;
                    }
                    case 6: {
                        this.m_ControlSource = (ControlSource)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + String.valueOf(this.getClass()));
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ") : " + String.valueOf(exception));
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_Locale;
            }
            case 1: {
                return this.m_HideDuplicates;
            }
            case 2: {
                return this.m_AutoWrap;
            }
            case 3: {
                return this.m_Orientation;
            }
            case 4: {
                return this.m_LineHeight;
            }
            case 5: {
                return this.m_Format;
            }
            case 6: {
                return this.m_ControlSource;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + String.valueOf(this.getClass()));
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public Field deepCopy() {
        Field field = new Field();
        this.copyInto(field);
        return field;
    }

    protected void copyInto(Field field) {
        super.copyInto(field);
        field.m_Locale = this.m_Locale;
        field.m_HideDuplicates = this.m_HideDuplicates;
        field.m_AutoWrap = this.m_AutoWrap;
        field.m_Orientation = this.m_Orientation;
        field.m_LineHeight = this.m_LineHeight;
        if (this.m_Format != null) {
            field.m_Format = this.m_Format.deepCopy();
        }
        if (this.m_ControlSource != null) {
            field.m_ControlSource = this.m_ControlSource.deepCopy();
        }
    }

    static {
        try {
            m_IndexOffset = TextElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                Field.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                Field.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            Field.logError("Error in property initialization", throwable);
        }
    }
}

