/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.property;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import java.util.Locale;

public abstract class LineHeight {
    public static final LineHeight NORMAL = new NormalLineHeight();
    public static final String NORMAL_ID = "normal";
    private static final String[] UNITS = new String[]{"px", "in", "mm", "tw"};
    private static final float[] MULTIPLIER = new float[]{20.0f, 1440.0f, 56.692913f, 1.0f};
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LineHeight.class);

    public static LineHeight getInstance(String string) {
        String string2 = string;
        if (StringUtil.isEmpty(string2)) {
            return NORMAL;
        }
        if (NORMAL_ID.equals(string2 = string2.trim().toLowerCase(Locale.getDefault()))) {
            return NORMAL;
        }
        try {
            if (string2.endsWith("%")) {
                String string3 = string2.substring(0, string2.length() - 1).trim();
                return new MultiplierLineHeight(string2, string3, 100.0f);
            }
            for (int i = 0; i < UNITS.length; ++i) {
                if (!string2.endsWith(UNITS[i])) continue;
                return new AbsoluteLineHeight(string2, i);
            }
            return new MultiplierLineHeight(string2, string2, 1.0f);
        }
        catch (NumberFormatException numberFormatException) {
            m_Log.warn((Object)("Can't parse LineHeight: \"" + string2 + "\""));
            return NORMAL;
        }
    }

    public abstract float getValue(float var1);

    private static class MultiplierLineHeight
    extends LineHeight {
        private String m_String;
        private float m_Multiplier;

        public MultiplierLineHeight(String string, String string2, float f) {
            this.m_String = string;
            this.m_Multiplier = Float.parseFloat(string2) / f;
        }

        @Override
        public float getValue(float f) {
            return f * this.m_Multiplier;
        }

        public String toString() {
            return this.m_String;
        }
    }

    private static class AbsoluteLineHeight
    extends LineHeight {
        private String m_String;
        private float m_Absolute;

        public AbsoluteLineHeight(String string, int n) {
            this.m_String = string;
            String string2 = string.substring(0, string.length() - 2).trim();
            this.m_Absolute = Float.parseFloat(string2) * MULTIPLIER[n];
        }

        @Override
        public float getValue(float f) {
            return this.m_Absolute;
        }

        public String toString() {
            return this.m_String;
        }
    }

    private static class NormalLineHeight
    extends LineHeight {
        private NormalLineHeight() {
        }

        @Override
        public float getValue(float f) {
            return f;
        }

        public String toString() {
            return LineHeight.NORMAL_ID;
        }
    }
}

