/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.util;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.awt.Rectangle;

public class ElementUtil {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ElementUtil.class);

    public static int getIntAttr(Element element, String string) {
        Attribute attribute = element.getAttribute(string);
        try {
            if (attribute != null) {
                return attribute.getIntValue();
            }
            m_Log.error((Object)("Element " + element.getName() + " has no attribute " + string));
            return 0;
        }
        catch (Exception exception) {
            String string2 = attribute != null ? attribute.getValue() : "<unknown>";
            m_Log.error((Object)("Element " + element.getName() + " can't get int value for " + string + "(" + string2 + ")"));
            return 0;
        }
    }

    public static int getIntAttrOrZero(Element element, String string) {
        Attribute attribute = element.getAttribute(string);
        try {
            if (attribute != null) {
                return attribute.getIntValue();
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void setIntAttr(Element element, String string, int n) {
        element.setAttribute(string, Integer.toString(n));
    }

    public static void copyAttr(Element element, Element element2, String string) {
        Attribute attribute = element.getAttribute(string);
        if (attribute != null) {
            element2.setAttribute((Attribute)attribute.clone());
        }
    }

    public static Rectangle getRect(Element element) {
        Rectangle rectangle = new Rectangle();
        try {
            rectangle.x = ElementUtil.getIntAttr(element, "Left");
            rectangle.y = ElementUtil.getIntAttr(element, "Top");
            rectangle.width = ElementUtil.getIntAttr(element, "Width");
            rectangle.height = ElementUtil.getIntAttr(element, "Height");
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in getRect: " + String.valueOf(exception)));
        }
        return rectangle;
    }

    public static Rectangle getRect(RawModelElement rawModelElement) {
        Rectangle rectangle = new Rectangle();
        try {
            rectangle.x = rawModelElement.getLeft();
            rectangle.y = rawModelElement.getTop();
            rectangle.width = rawModelElement.getWidth();
            rectangle.height = rawModelElement.getHeight();
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in getRect: " + String.valueOf(exception)));
        }
        return rectangle;
    }

    public static void setRect(Element element, Rectangle rectangle) {
        ElementUtil.setIntAttr(element, "Left", rectangle.x);
        ElementUtil.setIntAttr(element, "Top", rectangle.y);
        ElementUtil.setIntAttr(element, "Width", rectangle.width);
        ElementUtil.setIntAttr(element, "Height", rectangle.height);
    }

    public static String getId(Element element) {
        return element.getAttributeValue("Id");
    }

    public static int getLeft(Element element) {
        return ElementUtil.getIntAttrOrZero(element, "Left");
    }

    public static int getTop(Element element) {
        return ElementUtil.getIntAttrOrZero(element, "Top");
    }

    public static int getWidth(Element element) {
        return ElementUtil.getIntAttrOrZero(element, "Width");
    }

    public static int getHeight(Element element) {
        return ElementUtil.getIntAttrOrZero(element, "Height");
    }

    public static void setLeft(Element element, int n) {
        ElementUtil.setIntAttr(element, "Left", n);
    }

    public static void setTop(Element element, int n) {
        ElementUtil.setIntAttr(element, "Top", n);
    }

    public static void setWidth(Element element, int n) {
        if (n < 0) {
            m_Log.error((Object)("Negative width: " + n));
        }
        ElementUtil.setIntAttr(element, "Width", n);
    }

    public static void setHeight(Element element, int n) {
        if (n < 0) {
            m_Log.error((Object)("Negative height: " + n));
        }
        ElementUtil.setIntAttr(element, "Height", n);
    }

    public static boolean getBoolean(Element element, String string) {
        return "Yes".equals(element.getAttributeValue(string));
    }

    public static void deepCopy(Element element, Element element2) {
        element2.addContent((Element)element.clone());
    }
}

