/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.AbstractGlint;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Pen;
import com.elixirtech.rtf.ColorTable;
import com.elixirtech.rtf.FontTable;
import com.elixirtech.rtf.RTF;
import com.elixirtech.rtf.RTFCellRect;
import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFEllipse;
import com.elixirtech.rtf.RTFImage;
import com.elixirtech.rtf.RTFLine;
import com.elixirtech.rtf.RTFPage;
import com.elixirtech.rtf.RTFPolyline;
import com.elixirtech.rtf.RTFRect;
import com.elixirtech.rtf.RtfGraphicsWalker;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfReader;
import com.elixirtech.rtf.TextLine;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class GlintRTF
extends AbstractGlint {
    public static final int GAP_PERCENT = 15;
    public static final int MIN_GAP = 100;
    private boolean m_Word2003;
    private int m_Width;
    private int m_Height;
    private int m_Orientation;
    private int m_OffsetX;
    private int m_OffsetY;
    private int m_ClipLeft;
    private int m_ClipTop;
    private int m_ClipRight;
    private int m_ClipBottom;
    private RTFPage m_CurrentPage;
    private List<RTFChunk> m_Globals = new ArrayList<RTFChunk>();
    private List<RTFPage> m_Pages = new ArrayList<RTFPage>();
    private Stack<URL> m_URLs = new Stack();
    private Stack<Rectangle> m_ClipStack = new Stack();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GlintRTF.class);

    public GlintRTF(boolean bl) {
        this.m_Word2003 = bl;
    }

    public void addGlobal(RTFChunk rTFChunk) {
        this.m_Globals.add(rTFChunk);
    }

    @Override
    public void init(int n, int n2, int n3) {
        if (this.m_Orientation == 0) {
            this.m_Width = n;
            this.m_Height = n2;
            this.m_Orientation = n3;
        }
        this.m_CurrentPage = new RTFPage();
        this.m_Pages.add(this.m_CurrentPage);
        this.m_OffsetX = 0;
        this.m_OffsetY = 0;
        this.m_ClipLeft = 0;
        this.m_ClipTop = 0;
        this.m_ClipRight = this.m_Width;
        this.m_ClipBottom = this.m_Height;
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        this.m_OffsetX += n;
        this.m_OffsetY += n2;
    }

    @Override
    public void setOrigin(int n, int n2) {
        this.m_OffsetX = n;
        this.m_OffsetY = n2;
    }

    @Override
    public int getOriginX() {
        return this.m_OffsetX;
    }

    @Override
    public int getOriginY() {
        return this.m_OffsetY;
    }

    @Override
    public void setURL(String string, String string2) {
        try {
            URL uRL = new URL(string);
            this.m_URLs.push(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.m_URLs.push(null);
        }
    }

    @Override
    public void resetURL() {
        this.m_URLs.pop();
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = Math.min(n, n3);
        if (this.notVisible(n8, n7 = Math.min(n2, n4), n6 = Math.abs(n - n3), n5 = Math.abs(n2 - n4))) {
            return;
        }
        Pen pen = this.getPen(penId);
        byte by = pen.getStyle();
        String string = "Solid";
        if (by == 2) {
            string = "Dashes";
        }
        if (by == 3) {
            string = "Dots";
        }
        Color color = pen.getColor();
        RTFLine rTFLine = new RTFLine();
        rTFLine.setEnds(this.m_OffsetX + n, this.m_OffsetY + n2, this.m_OffsetX + n3, this.m_OffsetY + n4);
        rTFLine.setLineWidth(pen.getWidth());
        rTFLine.setLineStyle(string);
        rTFLine.setLineColor(color.getAWTColor());
        this.m_CurrentPage.addChunk(rTFLine);
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("xs length != ys length");
        }
        Pen pen = this.getPen(penId);
        byte by = pen.getStyle();
        String string = "Solid";
        if (by == 2) {
            string = "Dashes";
        }
        if (by == 3) {
            string = "Dots";
        }
        Color color = pen.getColor();
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] + this.m_OffsetX;
            nArray4[i] = nArray2[i] + this.m_OffsetY;
        }
        RTFPolyline rTFPolyline = new RTFPolyline();
        rTFPolyline.setPoints(nArray3, nArray4);
        rTFPolyline.setLineWidth(pen.getWidth());
        rTFPolyline.setLineStyle(string);
        rTFPolyline.setLineColor(color.getAWTColor());
        this.m_CurrentPage.addChunk(rTFPolyline);
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        this.drawRoundRect(penId, colorId, n, n2, n3, n4, 0, 0);
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        if (this.notVisible(n, n2, n3, n4)) {
            return;
        }
        Pen pen = this.getPen(penId);
        byte by = pen.getStyle();
        String string = "Solid";
        if (by == 2) {
            string = "Dashes";
        }
        if (by == 3) {
            string = "Dots";
        }
        Color color = pen.getColor();
        Color color2 = this.getColor(colorId);
        RTFCellRect rTFCellRect = new RTFCellRect();
        if ((n += this.m_OffsetX) < this.m_ClipLeft) {
            n3 -= this.m_ClipLeft - n;
            n = this.m_ClipLeft;
        }
        if (n + n3 > this.m_ClipRight) {
            n3 = this.m_ClipRight - n;
        }
        rTFCellRect.setBounds(n, this.m_OffsetY + n2, n3, n4);
        rTFCellRect.setLineWidth(pen.getWidth());
        rTFCellRect.setLineStyle(string);
        rTFCellRect.setLineColor(color.getAWTColor());
        rTFCellRect.setFillColor(color2.getAWTColor());
        rTFCellRect.setSides(n5);
        this.m_CurrentPage.addChunk(rTFCellRect);
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.notVisible(n, n2, n3, n4)) {
            return;
        }
        Pen pen = this.getPen(penId);
        byte by = pen.getStyle();
        String string = "Solid";
        if (by == 2) {
            string = "Dashes";
        }
        if (by == 3) {
            string = "Dots";
        }
        Color color = pen.getColor();
        Color color2 = this.getColor(colorId);
        RTFRect rTFRect = new RTFRect();
        if ((n += this.m_OffsetX) < this.m_ClipLeft) {
            n3 -= this.m_ClipLeft - n;
            n = this.m_ClipLeft;
        }
        if (n + n3 > this.m_ClipRight) {
            n3 = this.m_ClipRight - n;
        }
        rTFRect.setBounds(n, n2 + this.m_OffsetY, n3, n4);
        rTFRect.setLineWidth(pen.getWidth());
        rTFRect.setLineStyle(string);
        rTFRect.setLineColor(color.getAWTColor());
        rTFRect.setFillColor(color2.getAWTColor());
        rTFRect.setRoundingRadius((n5 + n6) / 2);
        this.m_CurrentPage.addChunk(rTFRect);
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.notVisible(n, n2, n3, n4)) {
            return;
        }
        Pen pen = this.getPen(penId);
        byte by = pen.getStyle();
        String string = "Solid";
        if (by == 2) {
            string = "Dashes";
        }
        if (by == 3) {
            string = "Dots";
        }
        Color color = pen.getColor();
        Color color2 = this.getColor(colorId);
        RTFCellRect rTFCellRect = new RTFCellRect();
        if ((n += this.m_OffsetX) < this.m_ClipLeft) {
            n3 -= this.m_ClipLeft - n;
            n = this.m_ClipLeft;
        }
        if (n + n3 > this.m_ClipRight) {
            n3 = this.m_ClipRight - n;
        }
        rTFCellRect.setBounds(n, this.m_OffsetY + n2, n3, n4);
        rTFCellRect.setLineWidth(pen.getWidth());
        rTFCellRect.setLineStyle(string);
        rTFCellRect.setLineColor(color.getAWTColor());
        rTFCellRect.setFillColor(color2.getAWTColor());
        rTFCellRect.setSides(n7);
        this.m_CurrentPage.addChunk(rTFCellRect);
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        if (this.notVisible(n, n2, n3, n4)) {
            return;
        }
        Pen pen = this.getPen(penId);
        byte by = pen.getStyle();
        String string = "Solid";
        if (by == 2) {
            string = "Dashes";
        }
        if (by == 3) {
            string = "Dots";
        }
        Color color = pen.getColor();
        Color color2 = this.getColor(colorId);
        RTFEllipse rTFEllipse = new RTFEllipse();
        rTFEllipse.setBounds(this.m_OffsetX + n, this.m_OffsetY + n2, this.m_OffsetX + n3, this.m_OffsetY + n4);
        rTFEllipse.setLineWidth(pen.getWidth());
        rTFEllipse.setLineStyle(string);
        rTFEllipse.setLineColor(color.getAWTColor());
        rTFEllipse.setFillColor(color2.getAWTColor());
        this.m_CurrentPage.addChunk(rTFEllipse);
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        int n3;
        com.elixirtech.glint.Image image = this.getImage(imageId);
        RTFImage rTFImage = new RTFImage();
        int n4 = image.getWidth();
        if (this.notVisible(n, n2, n4 * 20, (n3 = image.getHeight()) * 20)) {
            return;
        }
        rTFImage.setBounds(this.m_OffsetX + n, this.m_OffsetY + n2, n4 * 20, n3 * 20);
        rTFImage.setAlignment(9);
        rTFImage.setSizeMode("Clip");
        rTFImage.setWord2003(this.m_Word2003);
        rTFImage.setImage(this.getBufferedImage(image.asAWTImage(), 0, 0, n4, n3));
        this.m_CurrentPage.addChunk(rTFImage);
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        if (this.notVisible(n, n2, n3, n4)) {
            return;
        }
        com.elixirtech.glint.Image image = this.getImage(imageId);
        RTFImage rTFImage = new RTFImage();
        rTFImage.setBounds(this.m_OffsetX + n, this.m_OffsetY + n2, n3, n4);
        rTFImage.setAlignment(9);
        rTFImage.setSizeMode("Stretch");
        rTFImage.setWord2003(this.m_Word2003);
        rTFImage.setImage(this.getBufferedImage(image.asAWTImage(), 0, 0, image.getWidth(), image.getHeight()));
        this.m_CurrentPage.addChunk(rTFImage);
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.notVisible(n, n2, n5, n6)) {
            return;
        }
        com.elixirtech.glint.Image image = this.getImage(imageId);
        RTFImage rTFImage = new RTFImage();
        rTFImage.setBounds(this.m_OffsetX + n, this.m_OffsetY + n2, n5 * 20, n6 * 20);
        rTFImage.setAlignment(9);
        rTFImage.setSizeMode("Clip");
        rTFImage.setWord2003(this.m_Word2003);
        rTFImage.setImage(this.getBufferedImage(image.asAWTImage(), n3, n4, n5, n6));
        this.m_CurrentPage.addChunk(rTFImage);
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.notVisible(n, n2, n3, n4)) {
            return;
        }
        com.elixirtech.glint.Image image = this.getImage(imageId);
        RTFImage rTFImage = new RTFImage();
        rTFImage.setBounds(this.m_OffsetX + n, this.m_OffsetY + n2, n3, n4);
        rTFImage.setAlignment(9);
        rTFImage.setSizeMode("Stretch");
        rTFImage.setWord2003(this.m_Word2003);
        rTFImage.setImage(this.getBufferedImage(image.asAWTImage(), n5, n6, n7, n8));
        this.m_CurrentPage.addChunk(rTFImage);
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        if (string.length() == 0) {
            return;
        }
        Font font = this.getFont(fontId);
        TextLayout textLayout = this.getTextLayout(font, string);
        int n4 = (int)(textLayout.getAdvance() * 20.0f);
        int n5 = n4 * 15 / 100;
        if (n5 < 100) {
            n5 = 100;
        }
        n4 += n5;
        String string2 = "Left";
        if (n3 == 2) {
            n -= n4;
            string2 = "Right";
        } else if (n3 == 3) {
            n -= n4 / 2;
            string2 = "Center";
        }
        if (this.notVisible(n, n2, n4, (int)textLayout.getAscent() * 20)) {
            return;
        }
        TextLine textLine = new TextLine();
        textLine.setAlignment(string2);
        textLine.setBounds(this.m_OffsetX + n, (int)((float)(this.m_OffsetY + n2) - textLayout.getAscent() * 20.0f), n4);
        textLine.setFont(fontId.id, font.getStyle(), font.getSize());
        textLine.setUnderline(font.isUnderlined());
        textLine.setStrikethrough(font.isStrikethrough());
        textLine.setFontColor(colorId.id - 1);
        if (this.m_URLs.size() > 0) {
            textLine.setURL(((URL)this.m_URLs.get(this.m_URLs.size() - 1)).toExternalForm());
        }
        textLine.setLine(string);
        this.m_CurrentPage.addChunk(textLine);
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        this.drawText(fontId, colorId, n, n2, 1, string);
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            RtfReader rtfReader = new RtfReader(byteArrayInputStream);
            RtfGroup rtfGroup = rtfReader.getTreeRoot();
            BufferedImage bufferedImage = new BufferedImage(n3 /= 20, n4 /= 20, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.clipRect(0, 0, n3, n4);
            Rectangle rectangle = new Rectangle(0, 0, n3, n4);
            RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle, graphics2D);
            rtfGroup.walk(rtfGraphicsWalker);
            graphics2D.dispose();
            bufferedImage.flush();
            RTFImage rTFImage = new RTFImage();
            if (this.notVisible(n, n2, n3 * 20, n4 * 20)) {
                return;
            }
            rTFImage.setBounds(this.m_OffsetX + n, this.m_OffsetY + n2, n3 * 20, n4 * 20);
            rTFImage.setAlignment(9);
            rTFImage.setSizeMode("Clip");
            rTFImage.setWord2003(this.m_Word2003);
            rTFImage.setImage(bufferedImage);
            this.m_CurrentPage.addChunk(rTFImage);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't drawRTF: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(this.m_ClipLeft, this.m_ClipTop, this.m_ClipRight, this.m_ClipBottom);
        this.m_ClipStack.push(rectangle);
        this.m_ClipLeft = Math.max(this.m_ClipLeft, this.m_OffsetX + n);
        this.m_ClipTop = Math.max(this.m_ClipTop, this.m_OffsetY + n2);
        this.m_ClipRight = Math.min(this.m_ClipRight, this.m_OffsetX + n + n3);
        this.m_ClipBottom = Math.min(this.m_ClipBottom, this.m_OffsetY + n2 + n4);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.pushClip(n, n2, n3, n4);
    }

    @Override
    public void popClip() {
        Rectangle rectangle = this.m_ClipStack.pop();
        this.m_ClipLeft = rectangle.x;
        this.m_ClipTop = rectangle.y;
        this.m_ClipRight = rectangle.width;
        this.m_ClipBottom = rectangle.height;
    }

    @Override
    public void flush() {
    }

    public void dispose() {
        Iterator<RTFPage> iterator = this.m_Pages.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
    }

    public void writeTo(Writer writer) throws IOException {
        RTF rTF = new RTF(writer);
        rTF.write(this.buildFontTable());
        rTF.write(this.buildColorTable());
        rTF.write(this.m_Globals);
        Iterator<RTFPage> iterator = this.m_Pages.iterator();
        while (iterator.hasNext()) {
            rTF.write(iterator.next());
            if (!iterator.hasNext()) continue;
            rTF.newPage();
        }
        rTF.close();
    }

    protected TextLayout getTextLayout(Font font, String string) {
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font.getAWTFont());
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        return new TextLayout(attributedString.getIterator(), fontRenderContext);
    }

    protected FontTable buildFontTable() {
        FontTable fontTable = new FontTable();
        for (Font font : this.m_FontList) {
            String string = font.getName();
            if ("Serif".equals(string)) {
                string = "Times New Roman";
            }
            fontTable.addFont(string);
        }
        return fontTable;
    }

    protected ColorTable buildColorTable() {
        ColorTable colorTable = new ColorTable();
        Iterator iterator = this.m_ColorList.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Color color = (Color)iterator.next();
            colorTable.addColor(color.getAWTColor());
        }
        return colorTable;
    }

    protected BufferedImage getBufferedImage(Image image, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = null;
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (n == 0 && n2 == 0 && n3 == n5 && n4 == n6) {
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                bufferedImage = new BufferedImage(n3, n4, 2);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(image, 0, 0, null);
                graphics.dispose();
            }
        } else {
            bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, null);
            graphics.dispose();
        }
        return bufferedImage;
    }

    protected boolean notVisible(int n, int n2, int n3, int n4) {
        if (n + this.m_OffsetX >= this.m_ClipRight) {
            return true;
        }
        if (n2 + this.m_OffsetY >= this.m_ClipBottom) {
            return true;
        }
        if (n + this.m_OffsetX + n3 <= this.m_ClipLeft) {
            return true;
        }
        return n2 + this.m_OffsetY + n4 <= this.m_ClipTop;
    }
}

