/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.ACI;
import com.elixirtech.rtf.ACS;
import com.elixirtech.rtf.RtfWalker;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class RtfGraphicsWalker
extends RtfWalker {
    private Rectangle2D m_Rectangle;
    private Graphics2D m_Graphics;
    private boolean m_Test;

    public RtfGraphicsWalker(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        this(rectangle2D, graphics2D, false);
    }

    public RtfGraphicsWalker(Rectangle2D rectangle2D, Graphics2D graphics2D, boolean bl) {
        this.m_Rectangle = rectangle2D;
        this.m_Graphics = graphics2D;
        this.m_Test = bl;
        this.m_X = (float)rectangle2D.getX();
        this.m_Bottom = this.m_Y = (float)rectangle2D.getY();
    }

    @Override
    protected void renderACS() {
        FontRenderContext fontRenderContext = this.m_Graphics.getFontRenderContext();
        if (this.m_ACS.getChunkCount() > 0) {
            boolean bl = true;
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.m_ACS.getIterator(), fontRenderContext);
            int n = this.m_ACS.getEndIndex();
            while (lineBreakMeasurer.getPosition() < n) {
                ACS.Chunk chunk = this.m_ACS.getChunkForIndex(lineBreakMeasurer.getPosition());
                String string = (String)chunk.values.get(ACI.ALIGNMENT);
                Float f = (Float)chunk.values.get(TextAttribute.JUSTIFICATION);
                Integer n2 = (Integer)chunk.values.get(ACI.LINE_SPACING);
                Integer n3 = (Integer)chunk.values.get(ACI.FIRST_LINE_INDENT);
                float f2 = this.m_X;
                float f3 = (float)this.m_Rectangle.getWidth();
                if (bl && n3 != null) {
                    float f4 = (float)n3.intValue() / 20.0f;
                    if (f4 > f3) {
                        f4 = 0.0f;
                    }
                    f3 -= f4;
                    f2 += f4;
                }
                TextLayout textLayout = lineBreakMeasurer.nextLayout(f3);
                if (TextAttribute.JUSTIFICATION_FULL.equals(f) && lineBreakMeasurer.getPosition() < n) {
                    textLayout = textLayout.getJustifiedLayout(f3);
                }
                if ("Center".equals(string)) {
                    f2 += (f3 - textLayout.getAdvance()) / 2.0f;
                } else if ("Right".equals(string)) {
                    f2 += f3 - textLayout.getAdvance();
                }
                if (n2 == null) {
                    this.m_Bottom = this.m_Y + textLayout.getAscent();
                    textLayout.draw(this.m_Graphics, f2, this.m_Bottom);
                    this.m_Bottom += textLayout.getDescent();
                    this.m_Y = this.m_Bottom + textLayout.getLeading();
                } else {
                    float f5 = (float)n2.intValue() / 20.0f;
                    this.m_Bottom = f5 < 0.0f ? this.m_Y - f5 : this.m_Y + f5;
                    if (!this.m_Test) {
                        textLayout.draw(this.m_Graphics, f2, this.m_Bottom);
                    }
                    this.m_Y = this.m_Bottom;
                }
                bl = false;
            }
        } else {
            Map<AttributedCharacterIterator.Attribute, Object> map = this.convertMap();
            this.m_ACS.add(" ", map);
            Integer n = (Integer)map.get(ACI.LINE_SPACING);
            if (n == null) {
                TextLayout textLayout = new TextLayout(this.m_ACS.getIterator(), fontRenderContext);
                this.m_Y += textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            } else {
                float f = (float)n.intValue() / 20.0f;
                if (f < 0.0f) {
                    this.m_Y -= f;
                } else {
                    TextLayout textLayout = new TextLayout(this.m_ACS.getIterator(), fontRenderContext);
                    float f6 = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
                    if (f6 < f) {
                        f6 = f;
                    }
                    this.m_Y += f6;
                }
            }
        }
        this.m_ACS = new ACS();
        this.m_X = (float)this.m_Rectangle.getX();
    }
}

