/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.scm;

import com.elixirtech.scm.Continuation;
import com.elixirtech.scm.Environment;
import com.elixirtech.scm.InputPort;
import com.elixirtech.scm.JavaMethod;
import com.elixirtech.scm.Macro;
import com.elixirtech.scm.Pair;
import com.elixirtech.scm.Procedure;
import com.elixirtech.scm.Scheme;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Primitive
extends Procedure {
    int minArgs;
    int maxArgs;
    int idNumber;
    private static final int EQ = 0;
    private static final int LT = 1;
    private static final int GT = 2;
    private static final int GE = 3;
    private static final int LE = 4;
    private static final int ABS = 5;
    private static final int EOF_OBJECT = 6;
    private static final int EQQ = 7;
    private static final int EQUALQ = 8;
    private static final int FORCE = 9;
    private static final int CAR = 10;
    private static final int FLOOR = 11;
    private static final int CEILING = 12;
    private static final int CONS = 13;
    private static final int DIVIDE = 14;
    private static final int LENGTH = 15;
    private static final int LIST = 16;
    private static final int LISTQ = 17;
    private static final int APPLY = 18;
    private static final int MAX = 19;
    private static final int MIN = 20;
    private static final int MINUS = 21;
    private static final int NEWLINE = 22;
    private static final int NOT = 23;
    private static final int NULLQ = 24;
    private static final int NUMBERQ = 25;
    private static final int PAIRQ = 26;
    private static final int PLUS = 27;
    private static final int PROCEDUREQ = 28;
    private static final int READ = 29;
    private static final int CDR = 30;
    private static final int ROUND = 31;
    private static final int SECOND = 32;
    private static final int SYMBOLQ = 33;
    private static final int TIMES = 34;
    private static final int TRUNCATE = 35;
    private static final int WRITE = 36;
    private static final int APPEND = 37;
    private static final int BOOLEANQ = 38;
    private static final int SQRT = 39;
    private static final int EXPT = 40;
    private static final int REVERSE = 41;
    private static final int ASSOC = 42;
    private static final int ASSQ = 43;
    private static final int ASSV = 44;
    private static final int MEMBER = 45;
    private static final int MEMQ = 46;
    private static final int MEMV = 47;
    private static final int EQVQ = 48;
    private static final int LISTREF = 49;
    private static final int LISTTAIL = 50;
    private static final int MAKESTRING = 52;
    private static final int STRING = 53;
    private static final int STRINGLENGTH = 54;
    private static final int STRINGREF = 55;
    private static final int STRINGSET = 56;
    private static final int SUBSTRING = 57;
    private static final int STRINGAPPEND = 58;
    private static final int STRINGTOLIST = 59;
    private static final int LISTTOSTRING = 60;
    private static final int SYMBOLTOSTRING = 61;
    private static final int STRINGTOSYMBOL = 62;
    private static final int EXP = 63;
    private static final int LOG = 64;
    private static final int SIN = 65;
    private static final int COS = 66;
    private static final int TAN = 67;
    private static final int ACOS = 68;
    private static final int ASIN = 69;
    private static final int ATAN = 70;
    private static final int NUMBERTOSTRING = 71;
    private static final int STRINGTONUMBER = 72;
    private static final int CHARQ = 73;
    private static final int CHARALPHABETICQ = 74;
    private static final int CHARNUMERICQ = 75;
    private static final int CHARWHITESPACEQ = 76;
    private static final int CHARUPPERCASEQ = 77;
    private static final int CHARLOWERCASEQ = 78;
    private static final int CHARTOINTEGER = 79;
    private static final int INTEGERTOCHAR = 80;
    private static final int CHARUPCASE = 81;
    private static final int CHARDOWNCASE = 82;
    private static final int STRINGQ = 83;
    private static final int VECTORQ = 84;
    private static final int MAKEVECTOR = 85;
    private static final int VECTOR = 86;
    private static final int VECTORLENGTH = 87;
    private static final int VECTORREF = 88;
    private static final int VECTORSET = 89;
    private static final int LISTTOVECTOR = 90;
    private static final int MAP = 91;
    private static final int FOREACH = 92;
    private static final int CALLCC = 93;
    private static final int VECTORTOLIST = 94;
    private static final int LOAD = 95;
    private static final int DISPLAY = 96;
    private static final int INPUTPORTQ = 98;
    private static final int CURRENTINPUTPORT = 99;
    private static final int OPENINPUTFILE = 100;
    private static final int CLOSEINPUTPORT = 101;
    private static final int OUTPUTPORTQ = 103;
    private static final int CURRENTOUTPUTPORT = 104;
    private static final int OPENOUTPUTFILE = 105;
    private static final int CLOSEOUTPUTPORT = 106;
    private static final int READCHAR = 107;
    private static final int PEEKCHAR = 108;
    private static final int EVAL = 109;
    private static final int QUOTIENT = 110;
    private static final int REMAINDER = 111;
    private static final int MODULO = 112;
    private static final int THIRD = 113;
    private static final int EOFOBJECTQ = 114;
    private static final int GCD = 115;
    private static final int LCM = 116;
    private static final int CXR = 117;
    private static final int ODDQ = 118;
    private static final int EVENQ = 119;
    private static final int ZEROQ = 120;
    private static final int POSITIVEQ = 121;
    private static final int NEGATIVEQ = 122;
    private static final int CHARCMP = 123;
    private static final int CHARCICMP = 128;
    private static final int STRINGCMP = 133;
    private static final int STRINGCICMP = 138;
    private static final int INEXACTQ = 144;
    private static final int INTEGERQ = 145;
    private static final int CALLWITHINPUTFILE = 146;
    private static final int CALLWITHOUTPUTFILE = 147;
    private static final int PAGE = 200;
    private static final int PAGES = 201;
    private static final int ELXSQBR = 202;
    private static final int E = 203;
    private static final int PI = 204;
    private static final int RANDOM = 205;
    private static final int TO_DEGREES = 206;
    private static final int TO_RADIANS = 207;
    private static final int NOW = 208;
    private static final int DAVG = 210;
    private static final int DCOUNT = 211;
    private static final int DMAX = 212;
    private static final int DMIN = 213;
    private static final int DSUM = 214;
    private static final int DSTDEV = 215;
    private static final int DVAR = 216;
    private static final int CREATE_VAR_CACHE = 217;
    private static final int DESTROY_VAR_CACHE = 218;
    private static final int CLEAR_ALL_VARS = 219;
    private static final int PUT_VAR = 220;
    private static final int GET_VAR = 221;
    private static final int REMOVE_VAR = 222;
    private static final int DLOOKUP = 223;
    private static final int OBJ = 224;
    private static final int ROW_NO = 225;
    private static final int ROW_COUNT = 226;
    private static final int PARAMETER_LOOKUP = 227;
    private static final int NULL_ZERO = 228;
    private static final int TRIM = 230;
    private static final int FORMAT = 231;
    private static final int LEFT_STRING = 232;
    private static final int RIGHT_STRING = 233;
    private static final int UPPERCASE = 234;
    private static final int LOWERCASE = 235;
    private static final int CREATE_DATA_CACHE_STORE = 240;
    private static final int DESTROY_DATA_CACHE_STORE = 241;
    private static final int DLOOKUP_CACHE_ROW = 242;
    private static final int YEAR = 260;
    private static final int QUARTER_OF_YEAR = 261;
    private static final int MONTH = 262;
    private static final int WEEK_OF_YEAR = 263;
    private static final int WEEK_OF_MONTH = 264;
    private static final int DAY_OF_YEAR = 265;
    private static final int DAY_OF_MONTH = 266;
    private static final int DAY_OF_WEEK = 267;
    private static final int HOUR_OF_DAY = 268;
    private static final int HOUR = 269;
    private static final int MINUTE = 270;
    private static final int SECONDS = 271;
    private static final int MILLISECOND = 272;
    private static final int DATE_ADD = 273;
    private static final int DATE_DIFF = 274;
    private static final int TO_DATE = 275;
    private static final int RESOURCE_TEXT = 276;
    private static final int RESOURCE_TEXT_LOCALE = 277;
    static final int NEW = -1;
    static final int CLASS = -2;
    static final int METHOD = -3;
    static final int EXIT = -4;
    static final int SETCAR = -5;
    static final int SETCDR = -6;
    static final int TIMECALL = -11;
    static final int MACROEXPAND = -12;
    static final int ERROR = -13;
    static final int LISTSTAR = -14;

    public Primitive(int n, int n2, int n3) {
        this.idNumber = n;
        this.minArgs = n2;
        this.maxArgs = n3;
    }

    public static Environment installPrimitives(Environment environment) {
        int n = Integer.MAX_VALUE;
        environment.defPrim("*", 34, 0, n).defPrim("*", 34, 0, n).defPrim("+", 27, 0, n).defPrim("-", 21, 1, n).defPrim("/", 14, 1, n).defPrim("<", 1, 2, n).defPrim("<=", 4, 2, n).defPrim("=", 0, 2, n).defPrim(">", 2, 2, n).defPrim(">=", 3, 2, n).defPrim("abs", 5, 1).defPrim("acos", 68, 1).defPrim("append", 37, 0, n).defPrim("apply", 18, 2, n).defPrim("asin", 69, 1).defPrim("assoc", 42, 2).defPrim("assq", 43, 2).defPrim("assv", 44, 2).defPrim("atan", 70, 1).defPrim("boolean?", 38, 1).defPrim("caaaar", 117, 1).defPrim("caaadr", 117, 1).defPrim("caaar", 117, 1).defPrim("caadar", 117, 1).defPrim("caaddr", 117, 1).defPrim("caadr", 117, 1).defPrim("caar", 117, 1).defPrim("cadaar", 117, 1).defPrim("cadadr", 117, 1).defPrim("cadar", 117, 1).defPrim("caddar", 117, 1).defPrim("cadddr", 117, 1).defPrim("caddr", 113, 1).defPrim("cadr", 32, 1).defPrim("call-with-current-continuation", 93, 1).defPrim("call-with-input-file", 146, 2).defPrim("call-with-output-file", 147, 2).defPrim("car", 10, 1).defPrim("cdaaar", 117, 1).defPrim("cdaadr", 117, 1).defPrim("cdaar", 117, 1).defPrim("cdadar", 117, 1).defPrim("cdaddr", 117, 1).defPrim("cdadr", 117, 1).defPrim("cdar", 117, 1).defPrim("cddaar", 117, 1).defPrim("cddadr", 117, 1).defPrim("cddar", 117, 1).defPrim("cdddar", 117, 1).defPrim("cddddr", 117, 1).defPrim("cdddr", 117, 1).defPrim("cddr", 117, 1).defPrim("cdr", 30, 1).defPrim("char->integer", 79, 1).defPrim("char-alphabetic?", 74, 1).defPrim("char-ci<=?", 132, 2).defPrim("char-ci<?", 129, 2).defPrim("char-ci=?", 128, 2).defPrim("char-ci>=?", 131, 2).defPrim("char-ci>?", 130, 2).defPrim("char-downcase", 82, 1).defPrim("char-lower-case?", 78, 1).defPrim("char-numeric?", 75, 1).defPrim("char-upcase", 81, 1).defPrim("char-upper-case?", 77, 1).defPrim("char-whitespace?", 76, 1).defPrim("char<=?", 127, 2).defPrim("char<?", 124, 2).defPrim("char=?", 123, 2).defPrim("char>=?", 126, 2).defPrim("char>?", 125, 2).defPrim("char?", 73, 1).defPrim("close-input-port", 101, 1).defPrim("close-output-port", 106, 1).defPrim("complex?", 25, 1).defPrim("cons", 13, 2).defPrim("cos", 66, 1).defPrim("current-input-port", 99, 0).defPrim("current-output-port", 104, 0).defPrim("display", 96, 1, 2).defPrim("eof-object?", 114, 1).defPrim("eq?", 7, 2).defPrim("equal?", 8, 2).defPrim("eqv?", 48, 2).defPrim("eval", 109, 1, 2).defPrim("even?", 119, 1).defPrim("exact?", 145, 1).defPrim("exp", 63, 1).defPrim("expt", 40, 2).defPrim("force", 9, 1).defPrim("for-each", 92, 1, n).defPrim("gcd", 115, 0, n).defPrim("inexact?", 144, 1).defPrim("input-port?", 98, 1).defPrim("integer->char", 80, 1).defPrim("integer?", 145, 1).defPrim("lcm", 116, 0, n).defPrim("length", 15, 1).defPrim("list", 16, 0, n).defPrim("list->string", 60, 1).defPrim("list->vector", 90, 1).defPrim("list-ref", 49, 2).defPrim("list-tail", 50, 2).defPrim("list?", 17, 1).defPrim("load", 95, 1).defPrim("log", 64, 1).defPrim("macro-expand", -12, 1).defPrim("make-string", 52, 1, 2).defPrim("make-vector", 85, 1, 2).defPrim("map", 91, 1, n).defPrim("max", 19, 1, n).defPrim("member", 45, 2).defPrim("memq", 46, 2).defPrim("memv", 47, 2).defPrim("min", 20, 1, n).defPrim("modulo", 112, 2).defPrim("negative?", 122, 1).defPrim("newline", 22, 0, 1).defPrim("not", 23, 1).defPrim("null?", 24, 1).defPrim("number->string", 71, 1, 2).defPrim("number?", 25, 1).defPrim("odd?", 118, 1).defPrim("open-input-file", 100, 1).defPrim("open-output-file", 105, 1).defPrim("output-port?", 103, 1).defPrim("pair?", 26, 1).defPrim("peek-char", 108, 0, 1).defPrim("positive?", 121, 1).defPrim("procedure?", 28, 1).defPrim("quotient", 110, 2).defPrim("rational?", 145, 1).defPrim("read", 29, 0, 1).defPrim("read-char", 107, 0, 1).defPrim("real?", 25, 1).defPrim("remainder", 111, 2).defPrim("reverse", 41, 1).defPrim("round", 31, 1).defPrim("set-car!", -5, 2).defPrim("set-cdr!", -6, 2).defPrim("sin", 65, 1).defPrim("sqrt", 39, 1).defPrim("string", 53, 0, n).defPrim("string->list", 59, 1).defPrim("string->number", 72, 1, 2).defPrim("string->symbol", 62, 1).defPrim("string-append", 58, 0, n).defPrim("string-ci<=?", 142, 2).defPrim("string-ci<?", 139, 2).defPrim("string-ci=?", 138, 2).defPrim("string-ci>=?", 141, 2).defPrim("string-ci>?", 140, 2).defPrim("string-length", 54, 1).defPrim("string-ref", 55, 2).defPrim("string-set!", 56, 3).defPrim("string<=?", 137, 2).defPrim("string<?", 134, 2).defPrim("string=?", 133, 2).defPrim("string>=?", 136, 2).defPrim("string>?", 135, 2).defPrim("string?", 83, 1).defPrim("substring", 57, 3).defPrim("symbol->string", 61, 1).defPrim("symbol?", 33, 1).defPrim("tan", 67, 1).defPrim("vector", 86, 0, n).defPrim("vector->list", 94, 1).defPrim("vector-length", 87, 1).defPrim("vector-ref", 88, 2).defPrim("vector-set!", 89, 3).defPrim("vector?", 84, 1).defPrim("write", 36, 1, 2).defPrim("write-char", 96, 1, 2).defPrim("zero?", 120, 1).defPrim("page", 200, 0).defPrim("pages", 201, 0).defPrim("elxsqbr", 202, 1).defPrim("e", 203, 0).defPrim("pi", 204, 0).defPrim("random", 205, 0).defPrim("to-degrees", 206, 1).defPrim("to-radians", 207, 1).defPrim("now", 208, 0).defPrim("davg", 210, 1).defPrim("dcount", 211, 0).defPrim("dmax", 212, 1).defPrim("dmin", 213, 1).defPrim("dsum", 214, 1).defPrim("dstdev", 215, 1).defPrim("dvar", 216, 1).defPrim("create-var-cache", 217, 1).defPrim("destroy-var-cache", 218, 1).defPrim("clear-all-vars", 219, 1).defPrim("put-var", 220, 2).defPrim("get-var", 221, 1).defPrim("remove-var", 222, 1).defPrim("dlookup", 223, 2).defPrim("obj", 224, 1).defPrim("row-no", 225, 1).defPrim("row-count", 226, 1).defPrim("parameter-lookup", 227, 1).defPrim("null-zero", 228, 1).defPrim("trim", 230, 1).defPrim("format", 231, 2).defPrim("left-string", 232, 1).defPrim("right-string", 233, 1).defPrim("uppercase", 234, 1).defPrim("lowercase", 235, 1).defPrim("create-data-cache-store", 240, 0).defPrim("destroy-data-cache-store", 241, 0).defPrim("dlookup-cache-row", 242, 3).defPrim("year", 260, 1).defPrim("quarter-of-year", 261, 1).defPrim("month", 262, 1).defPrim("week-of-year", 263, 1).defPrim("week-of-month", 264, 1).defPrim("day-of-year", 265, 1).defPrim("day-of-month", 266, 1).defPrim("day-of-week", 267, 1).defPrim("hour-of-day", 268, 1).defPrim("hour", 269, 1).defPrim("minute", 270, 1).defPrim("second", 271, 1).defPrim("millisecond", 272, 1).defPrim("date-add", 273, 3).defPrim("date-diff", 274, 3).defPrim("to-date", 275, 2).defPrim("resource-text", 276, 2).defPrim("resource-text-locale", 277, 3).defPrim("new", -1, 1).defPrim("class", -2, 1).defPrim("method", -3, 2, n).defPrim("exit", -4, 0, 1).defPrim("error", -13, 0, n).defPrim("time-call", -11, 1, 2).defPrim("_list*", -14, 0, n);
        return environment;
    }

    @Override
    public void applyJS(Scheme scheme, Object object, StringBuffer stringBuffer) {
        Object object2 = Primitive.first(object);
        Object object3 = Primitive.second(object);
        switch (this.idNumber) {
            case 23: {
                stringBuffer.append("!");
                scheme.evalJS(object2, stringBuffer);
                break;
            }
            case 38: {
                stringBuffer.append("typeof(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")=='boolean'");
                break;
            }
            case 48: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("==");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 7: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("==");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 8: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("==");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 24: {
                stringBuffer.append("isNull(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 33: {
                stringBuffer.append("typeof(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")=='string'");
                break;
            }
            case 25: {
                stringBuffer.append("typeof(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")=='string'");
                break;
            }
            case 118: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("%2!=0");
                break;
            }
            case 119: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("%2==0");
                break;
            }
            case 120: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("==0");
                break;
            }
            case 121: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(">0");
                break;
            }
            case 122: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("<0");
                break;
            }
            case 1: {
                Primitive.numCompareJS(scheme, object, '<', stringBuffer);
                break;
            }
            case 2: {
                Primitive.numCompareJS(scheme, object, '>', stringBuffer);
                break;
            }
            case 0: {
                Primitive.numCompareJS(scheme, object, '=', stringBuffer);
                break;
            }
            case 4: {
                Primitive.numCompareJS(scheme, object, 'L', stringBuffer);
                break;
            }
            case 3: {
                Primitive.numCompareJS(scheme, object, 'G', stringBuffer);
                break;
            }
            case 19: {
                stringBuffer.append("Math.max(");
                while (object != null) {
                    scheme.evalJS(Primitive.first(object), stringBuffer);
                    if ((object = Primitive.rest(object)) == null) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(")");
                break;
            }
            case 20: {
                stringBuffer.append("Math.min(");
                while (object != null) {
                    scheme.evalJS(Primitive.first(object), stringBuffer);
                    if ((object = Primitive.rest(object)) == null) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(")");
                break;
            }
            case 27: {
                Primitive.numComputeJS(scheme, object, '+', stringBuffer);
                break;
            }
            case 21: {
                Primitive.numComputeJS(scheme, object, '-', stringBuffer);
                break;
            }
            case 34: {
                Primitive.numComputeJS(scheme, object, '*', stringBuffer);
                break;
            }
            case 14: {
                Primitive.numComputeJS(scheme, object, '/', stringBuffer);
                break;
            }
            case 110: {
                stringBuffer.append("parseInt(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("/");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 111: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("%");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 5: {
                stringBuffer.append("Math.abs(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 11: {
                stringBuffer.append("Math.floor(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 12: {
                stringBuffer.append("Math.ceil(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 31: {
                stringBuffer.append("Math.round(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 63: {
                stringBuffer.append("Math.exp(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 64: {
                stringBuffer.append("Math.log(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 65: {
                stringBuffer.append("Math.sin(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 66: {
                stringBuffer.append("Math.cos(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 67: {
                stringBuffer.append("Math.tan(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 69: {
                stringBuffer.append("Math.asin(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 68: {
                stringBuffer.append("Math.acos(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 70: {
                stringBuffer.append("Math.atan(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 39: {
                stringBuffer.append("Math.sqrt(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 40: {
                stringBuffer.append("Math.pow(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 54: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".length()");
                break;
            }
            case 57: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".substring(");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(Primitive.third(object), stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 58: {
                Primitive.stringAppendJS(scheme, object, stringBuffer);
                break;
            }
            case 133: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".equals(");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 134: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("<");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 135: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(">");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 136: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(">=");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 137: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append("<=");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 138: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".equalsIgnoreCase(");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 139: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                stringBuffer.append("<");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                break;
            }
            case 140: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                stringBuffer.append(">");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                break;
            }
            case 141: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                stringBuffer.append(">=");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                break;
            }
            case 142: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                stringBuffer.append("<=");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                break;
            }
            case 200: {
                stringBuffer.append("\"${#}\"");
                break;
            }
            case 201: {
                stringBuffer.append("\"${##}\"");
                break;
            }
            case 202: {
                stringBuffer.append(new String((char[])object2));
                break;
            }
            case 203: {
                stringBuffer.append("Math.E");
                break;
            }
            case 204: {
                stringBuffer.append("Math.PI");
                break;
            }
            case 205: {
                stringBuffer.append("Math.random()");
                break;
            }
            case 208: {
                stringBuffer.append("new java.util.Date()");
                break;
            }
            case 206: {
                stringBuffer.append("(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(" * 180 / Math.PI");
                stringBuffer.append(")");
                break;
            }
            case 207: {
                stringBuffer.append("(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(" * Math.PI / 180");
                stringBuffer.append(")");
                break;
            }
            case 210: {
                stringBuffer.append("Data.getAverage(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getValueOverAll()");
                break;
            }
            case 211: {
                stringBuffer.append("Data.getRecordCount()");
                break;
            }
            case 212: {
                stringBuffer.append("Data.getMax(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getValueOverAll()");
                break;
            }
            case 213: {
                stringBuffer.append("Data.getMin(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getValueOverAll()");
                break;
            }
            case 214: {
                stringBuffer.append("Data.getSum(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getValueOverAll()");
                break;
            }
            case 215: {
                stringBuffer.append("Data.getStandardDeviation(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getValueOverAll()");
                break;
            }
            case 216: {
                stringBuffer.append("Data.getVariance(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getValueOverAll()");
                break;
            }
            case 217: {
                break;
            }
            case 218: {
                break;
            }
            case 219: {
                break;
            }
            case 220: {
                stringBuffer.append(new String((char[])object2));
                stringBuffer.append(" = ");
                scheme.evalJS(object3, stringBuffer);
                break;
            }
            case 221: {
                stringBuffer.append(new String((char[])object2));
                break;
            }
            case 222: {
                stringBuffer.append(new String((char[])object2));
                stringBuffer.append(" = null");
                break;
            }
            case 223: {
                stringBuffer.append("DataCacheManager.getCache(\"");
                stringBuffer.append(new String((char[])object2));
                stringBuffer.append("\").getObject(0,\"");
                stringBuffer.append(new String((char[])object3));
                stringBuffer.append("\")");
                break;
            }
            case 224: {
                stringBuffer.append(new String((char[])object2));
                break;
            }
            case 225: {
                stringBuffer.append("Data.getRecordIndex()");
                break;
            }
            case 226: {
                stringBuffer.append("Data.getRecordCount()");
                break;
            }
            case 227: {
                stringBuffer.append("Properties.getProperty(\"");
                stringBuffer.append(new String((char[])object2));
                stringBuffer.append("\")");
                break;
            }
            case 228: {
                stringBuffer.append("elxfn.nullZero(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 230: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".trim()");
                break;
            }
            case 231: {
                stringBuffer.append("Format.format(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 232: {
                stringBuffer.append("elxfn.leftString(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 233: {
                stringBuffer.append("elxfn.rightString(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 234: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".toUpperCase()");
                break;
            }
            case 235: {
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(".toLowerCase()");
                break;
            }
            case 240: {
                break;
            }
            case 241: {
                break;
            }
            case 242: {
                Object object4 = Primitive.third(object);
                stringBuffer.append("DataCacheManager.getCache(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(").getObject(");
                scheme.evalJS(object4, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 260: {
                Primitive.dateFn(scheme, object2, "YEAR", stringBuffer);
                break;
            }
            case 261: {
                stringBuffer.append("Math.floor(");
                Primitive.dateFn(scheme, object2, "MONTH", stringBuffer);
                stringBuffer.append("/4)");
                break;
            }
            case 262: {
                Primitive.dateFn(scheme, object2, "MONTH", stringBuffer);
                break;
            }
            case 263: {
                Primitive.dateFn(scheme, object2, "WEEK_OF_YEAR", stringBuffer);
                break;
            }
            case 264: {
                Primitive.dateFn(scheme, object2, "WEEK_OF_MONTH", stringBuffer);
                break;
            }
            case 265: {
                Primitive.dateFn(scheme, object2, "DAY_OF_YEAR", stringBuffer);
                break;
            }
            case 266: {
                Primitive.dateFn(scheme, object2, "DAY_OF_MONTH", stringBuffer);
                break;
            }
            case 267: {
                Primitive.dateFn(scheme, object2, "DAY_OF_WEEK", stringBuffer);
                break;
            }
            case 268: {
                Primitive.dateFn(scheme, object2, "HOUR_OF_DAY", stringBuffer);
                break;
            }
            case 269: {
                Primitive.dateFn(scheme, object2, "HOUR", stringBuffer);
                break;
            }
            case 270: {
                Primitive.dateFn(scheme, object2, "MINUTE", stringBuffer);
                break;
            }
            case 271: {
                Primitive.dateFn(scheme, object2, "SECOND", stringBuffer);
                break;
            }
            case 272: {
                Primitive.dateFn(scheme, object2, "MILLISECOND", stringBuffer);
                break;
            }
            case 273: {
                Object object5 = Primitive.third(object);
                stringBuffer.append("elxfn.dateAdd(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object5, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 274: {
                Object object6 = Primitive.third(object);
                stringBuffer.append("elxfn.dateDiff(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object6, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 275: {
                stringBuffer.append("elxfn.toDate(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 276: {
                stringBuffer.append("elxfn.resourceLookup(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            case 277: {
                Object object7 = Primitive.third(object);
                stringBuffer.append("elxfn.resourceLookup(");
                scheme.evalJS(object2, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object3, stringBuffer);
                stringBuffer.append(",");
                scheme.evalJS(object7, stringBuffer);
                stringBuffer.append(")");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported operation: " + String.valueOf(this) + " applied to " + String.valueOf(object));
            }
        }
    }

    public static void dateFn(Scheme scheme, Object object, String string, StringBuffer stringBuffer) {
        stringBuffer.append("java.util.Calendar.getInstance().setTime(");
        scheme.evalJS(object, stringBuffer);
        stringBuffer.append(").get(java.util.Calendar." + string + ")");
    }

    public static void stringAppendJS(Scheme scheme, Object object, StringBuffer stringBuffer) {
        while (object instanceof Pair) {
            scheme.evalJS(Primitive.first(object), stringBuffer);
            if (Primitive.rest(object) instanceof Pair) {
                stringBuffer.append("+");
            }
            object = Primitive.rest(object);
        }
    }

    public static void numCompareJS(Scheme scheme, Object object, char c, StringBuffer stringBuffer) {
        scheme.evalJS(Primitive.first(object), stringBuffer);
        object = Primitive.rest(object);
        switch (c) {
            case '>': {
                stringBuffer.append(">");
                break;
            }
            case '<': {
                stringBuffer.append("<");
                break;
            }
            case '=': {
                stringBuffer.append("==");
                break;
            }
            case 'L': {
                stringBuffer.append("<=");
                break;
            }
            case 'G': {
                stringBuffer.append(">=");
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator: " + c);
            }
        }
        scheme.evalJS(Primitive.first(object), stringBuffer);
    }

    public static void numComputeJS(Scheme scheme, Object object, char c, StringBuffer stringBuffer) {
        if (Primitive.rest(object) == null) {
            switch (c) {
                case '-': {
                    stringBuffer.append("-");
                    break;
                }
                case '/': {
                    stringBuffer.append("1/");
                    break;
                }
            }
            Object object2 = Primitive.first(object);
            scheme.evalJS(object2, stringBuffer);
        } else {
            block10: while (object instanceof Pair) {
                Object object3 = Primitive.first(object);
                object = Primitive.rest(object);
                scheme.evalJS(object3, stringBuffer);
                if (object == null) continue;
                switch (c) {
                    case '+': {
                        stringBuffer.append("+");
                        continue block10;
                    }
                    case '-': {
                        stringBuffer.append("-");
                        continue block10;
                    }
                    case '*': {
                        stringBuffer.append("*");
                        continue block10;
                    }
                    case '/': {
                        stringBuffer.append("/");
                        continue block10;
                    }
                }
                Primitive.error("internal error: unrecognized op: " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(Scheme scheme, Object object) {
        int n = Primitive.length(object);
        if (n < this.minArgs) {
            return Primitive.error("too few args, " + n + ", for " + this.name + ": " + String.valueOf(object));
        }
        if (n > this.maxArgs) {
            return Primitive.error("too many args, " + n + ", for " + this.name + ": " + String.valueOf(object));
        }
        Object object2 = Primitive.first(object);
        Object object3 = Primitive.second(object);
        switch (this.idNumber) {
            case 23: {
                return Primitive.truth(object2 == FALSE);
            }
            case 38: {
                return Primitive.truth(object2 == TRUE || object2 == FALSE);
            }
            case 48: {
                return Primitive.truth(Primitive.eqv(object2, object3));
            }
            case 7: {
                return Primitive.truth(object2 == object3);
            }
            case 8: {
                return Primitive.truth(Primitive.equal(object2, object3));
            }
            case 26: {
                return Primitive.truth(object2 instanceof Pair);
            }
            case 17: {
                return Primitive.truth(Primitive.isList(object2));
            }
            case 117: {
                for (int i = this.name.length() - 2; i >= 1; --i) {
                    object2 = this.name.charAt(i) == 'a' ? Primitive.first(object2) : Primitive.rest(object2);
                }
                return object2;
            }
            case 13: {
                return Primitive.cons(object2, object3);
            }
            case 10: {
                return Primitive.first(object2);
            }
            case 30: {
                return Primitive.rest(object2);
            }
            case -5: {
                return Primitive.setFirst(object2, object3);
            }
            case -6: {
                return Primitive.setRest(object2, object3);
            }
            case 32: {
                return Primitive.second(object2);
            }
            case 113: {
                return Primitive.third(object2);
            }
            case 24: {
                return Primitive.truth(object2 == null);
            }
            case 16: {
                return object;
            }
            case 15: {
                return Primitive.num(Primitive.length(object2));
            }
            case 37: {
                return object == null ? null : Primitive.append(object);
            }
            case 41: {
                return Primitive.reverse(object2);
            }
            case 50: {
                for (int i = (int)Primitive.num(object3); i > 0; --i) {
                    object2 = Primitive.rest(object2);
                }
                return object2;
            }
            case 49: {
                for (int i = (int)Primitive.num(object3); i > 0; --i) {
                    object2 = Primitive.rest(object2);
                }
                return Primitive.first(object2);
            }
            case 46: {
                return Primitive.memberAssoc(object2, object3, 'm', 'q');
            }
            case 47: {
                return Primitive.memberAssoc(object2, object3, 'm', 'v');
            }
            case 45: {
                return Primitive.memberAssoc(object2, object3, 'm', ' ');
            }
            case 43: {
                return Primitive.memberAssoc(object2, object3, 'a', 'q');
            }
            case 44: {
                return Primitive.memberAssoc(object2, object3, 'a', 'v');
            }
            case 42: {
                return Primitive.memberAssoc(object2, object3, 'a', ' ');
            }
            case 33: {
                return Primitive.truth(object2 instanceof String);
            }
            case 61: {
                return Primitive.sym(object2).toCharArray();
            }
            case 62: {
                return new String(Primitive.str(object2)).intern();
            }
            case 25: {
                return Primitive.truth(object2 instanceof Number);
            }
            case 118: {
                return Primitive.truth(Math.abs(Primitive.num(object2)) % 2.0 != 0.0);
            }
            case 119: {
                return Primitive.truth(Math.abs(Primitive.num(object2)) % 2.0 == 0.0);
            }
            case 120: {
                return Primitive.truth(Primitive.num(object2) == 0.0);
            }
            case 121: {
                return Primitive.truth(Primitive.num(object2) > 0.0);
            }
            case 122: {
                return Primitive.truth(Primitive.num(object2) < 0.0);
            }
            case 145: {
                return Primitive.truth(Primitive.isExact(object2));
            }
            case 144: {
                return Primitive.truth(!Primitive.isExact(object2));
            }
            case 1: {
                return Primitive.numCompare(object, '<');
            }
            case 2: {
                return Primitive.numCompare(object, '>');
            }
            case 0: {
                return Primitive.numCompare(object, '=');
            }
            case 4: {
                return Primitive.numCompare(object, 'L');
            }
            case 3: {
                return Primitive.numCompare(object, 'G');
            }
            case 19: {
                return Primitive.numCompute(object, 'X', Primitive.num(object2));
            }
            case 20: {
                return Primitive.numCompute(object, 'N', Primitive.num(object2));
            }
            case 27: {
                return Primitive.numCompute(object, '+', 0.0);
            }
            case 21: {
                return Primitive.numCompute(Primitive.rest(object), '-', Primitive.num(object2));
            }
            case 34: {
                return Primitive.numCompute(object, '*', 1.0);
            }
            case 14: {
                return Primitive.numCompute(Primitive.rest(object), '/', Primitive.num(object2));
            }
            case 110: {
                double d = Primitive.num(object2) / Primitive.num(object3);
                return Primitive.num(d > 0.0 ? Math.floor(d) : Math.ceil(d));
            }
            case 111: {
                return Primitive.num((long)Primitive.num(object2) % (long)Primitive.num(object3));
            }
            case 112: {
                long l = (long)Primitive.num(object2);
                long l2 = (long)Primitive.num(object3);
                long l3 = l % l2;
                return Primitive.num(l * l2 > 0L || l3 == 0L ? (double)l3 : (double)(l3 + l2));
            }
            case 5: {
                return Primitive.num(Math.abs(Primitive.num(object2)));
            }
            case 11: {
                return Primitive.num(Math.floor(Primitive.num(object2)));
            }
            case 12: {
                return Primitive.num(Math.ceil(Primitive.num(object2)));
            }
            case 35: {
                double d = Primitive.num(object2);
                return Primitive.num(d < 0.0 ? Math.ceil(d) : Math.floor(d));
            }
            case 31: {
                return Primitive.num(Math.round(Primitive.num(object2)));
            }
            case 63: {
                return Primitive.num(Math.exp(Primitive.num(object2)));
            }
            case 64: {
                return Primitive.num(Math.log(Primitive.num(object2)));
            }
            case 65: {
                return Primitive.num(Math.sin(Primitive.num(object2)));
            }
            case 66: {
                return Primitive.num(Math.cos(Primitive.num(object2)));
            }
            case 67: {
                return Primitive.num(Math.tan(Primitive.num(object2)));
            }
            case 69: {
                return Primitive.num(Math.asin(Primitive.num(object2)));
            }
            case 68: {
                return Primitive.num(Math.acos(Primitive.num(object2)));
            }
            case 70: {
                return Primitive.num(Math.atan(Primitive.num(object2)));
            }
            case 39: {
                return Primitive.num(Math.sqrt(Primitive.num(object2)));
            }
            case 40: {
                return Primitive.num(Math.pow(Primitive.num(object2), Primitive.num(object3)));
            }
            case 71: {
                return Primitive.numberToString(object2, object3);
            }
            case 72: {
                return Primitive.stringToNumber(object2, object3);
            }
            case 115: {
                return object == null ? ZERO : Primitive.gcd(object);
            }
            case 116: {
                return object == null ? ONE : Primitive.lcm(object);
            }
            case 73: {
                return Primitive.truth(object2 instanceof Character);
            }
            case 74: {
                return Primitive.truth(Character.isLetter(Primitive.chr(object2)));
            }
            case 75: {
                return Primitive.truth(Character.isDigit(Primitive.chr(object2)));
            }
            case 76: {
                return Primitive.truth(Character.isWhitespace(Primitive.chr(object2)));
            }
            case 77: {
                return Primitive.truth(Character.isUpperCase(Primitive.chr(object2)));
            }
            case 78: {
                return Primitive.truth(Character.isLowerCase(Primitive.chr(object2)));
            }
            case 79: {
                return new Double(Primitive.chr(object2));
            }
            case 80: {
                return Primitive.chr((char)Primitive.num(object2));
            }
            case 81: {
                return Primitive.chr(Character.toUpperCase(Primitive.chr(object2)));
            }
            case 82: {
                return Primitive.chr(Character.toLowerCase(Primitive.chr(object2)));
            }
            case 123: {
                return Primitive.truth(Primitive.charCompare(object2, object3, false) == 0);
            }
            case 124: {
                return Primitive.truth(Primitive.charCompare(object2, object3, false) < 0);
            }
            case 125: {
                return Primitive.truth(Primitive.charCompare(object2, object3, false) > 0);
            }
            case 126: {
                return Primitive.truth(Primitive.charCompare(object2, object3, false) >= 0);
            }
            case 127: {
                return Primitive.truth(Primitive.charCompare(object2, object3, false) <= 0);
            }
            case 128: {
                return Primitive.truth(Primitive.charCompare(object2, object3, true) == 0);
            }
            case 129: {
                return Primitive.truth(Primitive.charCompare(object2, object3, true) < 0);
            }
            case 130: {
                return Primitive.truth(Primitive.charCompare(object2, object3, true) > 0);
            }
            case 131: {
                return Primitive.truth(Primitive.charCompare(object2, object3, true) >= 0);
            }
            case 132: {
                return Primitive.truth(Primitive.charCompare(object2, object3, true) <= 0);
            }
            case -13: {
                return Primitive.error(Primitive.stringify(object));
            }
            case 83: {
                return Primitive.truth(object2 instanceof char[]);
            }
            case 52: {
                char[] cArray = new char[(int)Primitive.num(object2)];
                if (object3 != null) {
                    char c = Primitive.chr(object3);
                    for (int i = cArray.length - 1; i >= 0; --i) {
                        cArray[i] = c;
                    }
                }
                return cArray;
            }
            case 53: {
                return Primitive.listToString(object);
            }
            case 54: {
                return Primitive.num(Primitive.str(object2).length);
            }
            case 55: {
                return Primitive.chr(Primitive.str(object2)[(int)Primitive.num(object3)]);
            }
            case 56: {
                Object object4 = Primitive.third(object);
                Primitive.str((Object)object2)[(int)Primitive.num((Object)object3)] = Primitive.chr(object4);
                return object4;
            }
            case 57: {
                int n2 = (int)Primitive.num(object3);
                int n3 = (int)Primitive.num(Primitive.third(object));
                return new String(Primitive.str(object2), n2, n3 - n2).toCharArray();
            }
            case 58: {
                return Primitive.stringAppend(object);
            }
            case 59: {
                Pair pair = null;
                char[] cArray = Primitive.str(object2);
                for (int i = cArray.length - 1; i >= 0; --i) {
                    pair = Primitive.cons(Primitive.chr(cArray[i]), pair);
                }
                return pair;
            }
            case 60: {
                return Primitive.listToString(object2);
            }
            case 133: {
                return Primitive.truth(Primitive.stringEquals(object2, object3));
            }
            case 134: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, false) < 0);
            }
            case 135: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, false) > 0);
            }
            case 136: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, false) >= 0);
            }
            case 137: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, false) <= 0);
            }
            case 138: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, true) == 0);
            }
            case 139: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, true) < 0);
            }
            case 140: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, true) > 0);
            }
            case 141: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, true) >= 0);
            }
            case 142: {
                return Primitive.truth(Primitive.stringCompare(object2, object3, true) <= 0);
            }
            case 84: {
                return Primitive.truth(object2 instanceof Object[]);
            }
            case 85: {
                Object[] objectArray = new Object[(int)Primitive.num(object2)];
                if (object3 != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = object3;
                    }
                }
                return objectArray;
            }
            case 86: {
                return Primitive.listToVector(object);
            }
            case 87: {
                return Primitive.num(Primitive.vec(object2).length);
            }
            case 88: {
                return Primitive.vec(object2)[(int)Primitive.num(object3)];
            }
            case 89: {
                Object object5 = Primitive.third(object);
                Primitive.vec((Object)object2)[(int)Primitive.num((Object)object3)] = object5;
                return object5;
            }
            case 94: {
                return Primitive.vectorToList(object2);
            }
            case 90: {
                return Primitive.listToVector(object2);
            }
            case 109: {
                return scheme.eval(object2);
            }
            case 9: {
                return !(object2 instanceof Procedure) ? object2 : Primitive.proc(object2).apply(scheme, null);
            }
            case -12: {
                return Macro.macroExpand(scheme, object2);
            }
            case 28: {
                return Primitive.truth(object2 instanceof Procedure);
            }
            case 18: {
                return Primitive.proc(object2).apply(scheme, Primitive.listStar(Primitive.rest(object)));
            }
            case 91: {
                return Primitive.map(Primitive.proc(object2), Primitive.rest(object), scheme, Primitive.list(null));
            }
            case 92: {
                return Primitive.map(Primitive.proc(object2), Primitive.rest(object), scheme, null);
            }
            case 93: {
                RuntimeException runtimeException = new RuntimeException();
                Continuation continuation = new Continuation(runtimeException);
                try {
                    return Primitive.proc(object2).apply(scheme, Primitive.list(continuation));
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException2 == runtimeException) {
                        return continuation.value;
                    }
                    throw runtimeException2;
                }
            }
            case 114: {
                return Primitive.truth(object2 == InputPort.EOF);
            }
            case 98: {
                return Primitive.truth(object2 instanceof InputPort);
            }
            case 99: {
                return scheme.input;
            }
            case 100: {
                return Primitive.openInputFile(object2);
            }
            case 101: {
                return Primitive.inPort(object2, scheme).close();
            }
            case 103: {
                return Primitive.truth(object2 instanceof PrintWriter);
            }
            case 104: {
                return scheme.output;
            }
            case 105: {
                return Primitive.openOutputFile(object2);
            }
            case 147: {
                Object object6;
                try (PrintWriter printWriter = null;){
                    printWriter = Primitive.openOutputFile(object2);
                    object6 = Primitive.proc(object3).apply(scheme, Primitive.list(printWriter));
                }
                return object6;
            }
            case 146: {
                Object object7;
                try (InputPort inputPort = null;){
                    inputPort = Primitive.openInputFile(object2);
                    object7 = Primitive.proc(object3).apply(scheme, Primitive.list(inputPort));
                }
                return object7;
            }
            case 106: {
                Primitive.outPort(object2, scheme).close();
                return TRUE;
            }
            case 107: {
                return Primitive.inPort(object2, scheme).readChar();
            }
            case 108: {
                return Primitive.inPort(object2, scheme).peekChar();
            }
            case 29: {
                return Primitive.inPort(object2, scheme).read();
            }
            case 6: {
                return Primitive.truth(InputPort.isEOF(object2));
            }
            case 36: {
                return Primitive.write(object2, Primitive.outPort(object3, scheme), true);
            }
            case 96: {
                return Primitive.write(object2, Primitive.outPort(object3, scheme), false);
            }
            case 22: {
                Primitive.outPort(object2, scheme).println();
                Primitive.outPort(object2, scheme).flush();
                return TRUE;
            }
            case -2: {
                try {
                    return Class.forName(Primitive.stringify(object2, false));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return FALSE;
                }
            }
            case -1: {
                try {
                    return JavaMethod.toClass(object2).newInstance();
                }
                catch (ClassCastException classCastException) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return FALSE;
            }
            case -3: {
                return new JavaMethod(Primitive.stringify(object2, false), object3, Primitive.rest(Primitive.rest(object)));
            }
            case -14: {
                return Primitive.listStar(object);
            }
            case -11: {
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                long l = System.currentTimeMillis();
                long l4 = runtime.freeMemory();
                Object object8 = FALSE;
                int n4 = object3 == null ? 1 : (int)Primitive.num(object3);
                for (int i = 0; i < n4; ++i) {
                    object8 = Primitive.proc(object2).apply(scheme, null);
                }
                long l5 = System.currentTimeMillis() - l;
                long l6 = l4 - runtime.freeMemory();
                return Primitive.cons(object8, Primitive.list(Primitive.list(Primitive.num(l5), "msec"), Primitive.list(Primitive.num(l6), "bytes")));
            }
        }
        return Primitive.error("internal error: unknown primitive: " + String.valueOf(this) + " applied to " + String.valueOf(object));
    }

    public static char[] stringAppend(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        while (object instanceof Pair) {
            stringBuffer.append(Primitive.stringify(Primitive.first(object), false));
            object = Primitive.rest(object);
        }
        return stringBuffer.toString().toCharArray();
    }

    public static Object memberAssoc(Object object, Object object2, char c, char c2) {
        while (object2 instanceof Pair) {
            boolean bl;
            Object object3 = c == 'm' ? Primitive.first(object2) : Primitive.first(Primitive.first(object2));
            switch (c2) {
                case 'q': {
                    bl = object3 == object;
                    break;
                }
                case 'v': {
                    bl = Primitive.eqv(object3, object);
                    break;
                }
                case ' ': {
                    bl = Primitive.equal(object3, object);
                    break;
                }
                default: {
                    Primitive.warn("Bad option to memberAssoc:" + c2);
                    return FALSE;
                }
            }
            if (bl) {
                return c == 'm' ? object2 : Primitive.first(object2);
            }
            object2 = Primitive.rest(object2);
        }
        return FALSE;
    }

    public static Object numCompare(Object object, char c) {
        block7: while (Primitive.rest(object) instanceof Pair) {
            double d = Primitive.num(Primitive.first(object));
            object = Primitive.rest(object);
            double d2 = Primitive.num(Primitive.first(object));
            switch (c) {
                case '>': {
                    if (d > d2) continue block7;
                    return FALSE;
                }
                case '<': {
                    if (d < d2) continue block7;
                    return FALSE;
                }
                case '=': {
                    if (d == d2) continue block7;
                    return FALSE;
                }
                case 'L': {
                    if (d <= d2) continue block7;
                    return FALSE;
                }
                case 'G': {
                    if (d >= d2) continue block7;
                    return FALSE;
                }
            }
            Primitive.error("internal error: unrecognized op: " + c);
        }
        return TRUE;
    }

    public static Object numCompute(Object object, char c, double d) {
        if (object == null) {
            switch (c) {
                case '-': {
                    return Primitive.num(0.0 - d);
                }
                case '/': {
                    return Primitive.num(1.0 / d);
                }
            }
            return Primitive.num(d);
        }
        block12: while (object instanceof Pair) {
            double d2 = Primitive.num(Primitive.first(object));
            object = Primitive.rest(object);
            switch (c) {
                case 'X': {
                    if (!(d2 > d)) continue block12;
                    d = d2;
                    continue block12;
                }
                case 'N': {
                    if (!(d2 < d)) continue block12;
                    d = d2;
                    continue block12;
                }
                case '+': {
                    d += d2;
                    continue block12;
                }
                case '-': {
                    d -= d2;
                    continue block12;
                }
                case '*': {
                    d *= d2;
                    continue block12;
                }
                case '/': {
                    d /= d2;
                    continue block12;
                }
            }
            Primitive.error("internal error: unrecognized op: " + c);
        }
        return Primitive.num(d);
    }

    static int sign(int n) {
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    public static int charCompare(Object object, Object object2, boolean bl) {
        char c = Primitive.chr(object);
        char c2 = Primitive.chr(object2);
        if (bl) {
            c = Character.toLowerCase(c);
            c2 = Character.toLowerCase(c2);
        }
        return c - c2;
    }

    public static int stringCompare(Object object, Object object2, boolean bl) {
        if (object instanceof char[] && object2 instanceof char[]) {
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            for (int i = 0; i < cArray.length; ++i) {
                int n;
                int n2 = n = !bl ? cArray[i] - cArray2[i] : Character.toUpperCase(cArray[i]) - Character.toUpperCase(cArray2[i]);
                if (n == 0) continue;
                return n;
            }
            return cArray.length - cArray2.length;
        }
        Primitive.error("expected two strings, got: " + Primitive.stringify(Primitive.list(object, object2)));
        return 0;
    }

    public static boolean stringEquals(Object object, Object object2) {
        if (object instanceof char[] && object2 instanceof char[]) {
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            if (cArray.length == cArray2.length) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == cArray2[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static Object numberToString(Object object, Object object2) {
        int n;
        int n2 = n = object2 instanceof Number ? (int)Primitive.num(object2) : 10;
        if (n != 10 || Primitive.num(object) == (double)Math.round(Primitive.num(object))) {
            return Long.toString((long)Primitive.num(object), n).toCharArray();
        }
        return object.toString().toCharArray();
    }

    static Object stringToNumber(Object object, Object object2) {
        int n = object2 instanceof Number ? (int)Primitive.num(object2) : 10;
        try {
            return n == 10 ? Double.valueOf(Primitive.stringify(object, false)) : Primitive.num(Long.parseLong(Primitive.stringify(object, false), n));
        }
        catch (NumberFormatException numberFormatException) {
            return FALSE;
        }
    }

    static Object gcd(Object object) {
        long l = 0L;
        while (object instanceof Pair) {
            l = Primitive.gcd2(Math.abs((long)Primitive.num(Primitive.first(object))), l);
            object = Primitive.rest(object);
        }
        return Primitive.num(l);
    }

    static long gcd2(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        return Primitive.gcd2(l2, l % l2);
    }

    static Object lcm(Object object) {
        long l = 1L;
        long l2 = 1L;
        while (object instanceof Pair) {
            long l3 = Math.abs((long)Primitive.num(Primitive.first(object)));
            l2 = Primitive.gcd2(l3, l);
            l = l2 == 0L ? l2 : l3 / l2 * l;
            object = Primitive.rest(object);
        }
        return Primitive.num(l);
    }

    static boolean isExact(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = Primitive.num(object);
        return d == (double)Math.round(d) && Math.abs(d) < 1.0296288486157342E17;
    }

    static PrintWriter openOutputFile(Object object) {
        try {
            return new PrintWriter(new FileWriter(Primitive.stringify(object, false)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return (PrintWriter)Primitive.error("No such file: " + Primitive.stringify(object));
        }
        catch (IOException iOException) {
            return (PrintWriter)Primitive.error("IOException: " + String.valueOf(iOException));
        }
    }

    static InputPort openInputFile(Object object) {
        try {
            return new InputPort(new InputStreamReader((InputStream)new FileInputStream(Primitive.stringify(object, false)), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return (InputPort)Primitive.error("Unsupported encoding: " + String.valueOf(unsupportedEncodingException));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return (InputPort)Primitive.error("No such file: " + Primitive.stringify(object));
        }
    }

    static boolean isList(Object object) {
        Object object2 = object;
        Object object3 = object;
        while (object3 != null) {
            if (object2 == Primitive.rest(object3) || !(object3 instanceof Pair) || !(object2 instanceof Pair)) {
                return false;
            }
            object2 = Primitive.rest(object2);
            if ((object3 = Primitive.rest(object3)) == null) {
                return true;
            }
            if (!(object3 instanceof Pair)) {
                return false;
            }
            object3 = Primitive.rest(object3);
        }
        return true;
    }

    static Object append(Object object) {
        if (Primitive.rest(object) == null) {
            return Primitive.first(object);
        }
        return Primitive.append2(Primitive.first(object), Primitive.append(Primitive.rest(object)));
    }

    static Object append2(Object object, Object object2) {
        if (object instanceof Pair) {
            return Primitive.cons(Primitive.first(object), Primitive.append2(Primitive.rest(object), object2));
        }
        return object2;
    }

    static Pair map(Procedure procedure, Object object, Scheme scheme, Pair pair) {
        Pair pair2 = pair;
        if (Primitive.rest(object) == null) {
            object = Primitive.first(object);
            while (object instanceof Pair) {
                Object object2 = procedure.apply(scheme, Primitive.list(Primitive.first(object)));
                if (pair2 != null) {
                    pair2.rest = Primitive.list(object2);
                    pair2 = pair2.rest;
                }
                object = Primitive.rest(object);
            }
        } else {
            Procedure procedure2 = Primitive.proc(scheme.eval("car"));
            Procedure procedure3 = Primitive.proc(scheme.eval("cdr"));
            while (Primitive.first(object) instanceof Pair) {
                Object object3 = procedure.apply(scheme, Primitive.map(procedure2, Primitive.list(object), scheme, Primitive.list(null)));
                if (pair2 != null) {
                    pair2.rest = Primitive.list(object3);
                    pair2 = pair2.rest;
                }
                object = Primitive.map(procedure3, Primitive.list(object), scheme, Primitive.list(null));
            }
        }
        return (Pair)Primitive.rest(pair);
    }
}

