/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.scm;

import com.elixirtech.scm.InputPort;
import com.elixirtech.scm.Pair;
import com.elixirtech.scm.Scheme;
import java.io.PrintWriter;

public abstract class SchemeUtils {
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    public static Double ZERO = new Double(0.0);
    public static Double ONE = new Double(1.0);

    public static Boolean truth(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static boolean truth(Object object) {
        return object != FALSE;
    }

    public static Double num(double d) {
        return d == 0.0 ? ZERO : (d == 1.0 ? ONE : new Double(d));
    }

    public static double num(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return SchemeUtils.num(SchemeUtils.error("expected a number, got: " + String.valueOf(object)));
    }

    public static char chr(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return SchemeUtils.chr(SchemeUtils.error("expected a char, got: " + String.valueOf(object)));
    }

    public static Character chr(char c) {
        return new Character(c);
    }

    public static char[] str(Object object) {
        if (object instanceof char[]) {
            return (char[])object;
        }
        return SchemeUtils.str(SchemeUtils.error("expected a string, got: " + String.valueOf(object)));
    }

    public static String sym(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return SchemeUtils.sym(SchemeUtils.error("expected a symbol, got: " + String.valueOf(object)));
    }

    public static Object[] vec(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return SchemeUtils.vec(SchemeUtils.error("expected a vector, got: " + String.valueOf(object)));
    }

    public static InputPort inPort(Object object, Scheme scheme) {
        if (object == null) {
            return scheme.input;
        }
        if (object instanceof InputPort) {
            return (InputPort)object;
        }
        return SchemeUtils.inPort(SchemeUtils.error("expected an input port, got: " + String.valueOf(object)), scheme);
    }

    public static PrintWriter outPort(Object object, Scheme scheme) {
        if (object == null) {
            return scheme.output;
        }
        if (object instanceof PrintWriter) {
            return (PrintWriter)object;
        }
        return SchemeUtils.outPort(SchemeUtils.error("expected an output port, got: " + String.valueOf(object)), scheme);
    }

    public static Object error(String string) {
        throw new RuntimeException("Scheme Error: " + string);
    }

    public static Object warn(String string) {
        return "<warn>";
    }

    public static Object first(Object object) {
        return object instanceof Pair ? ((Pair)object).first : null;
    }

    public static Object rest(Object object) {
        return object instanceof Pair ? ((Pair)object).rest : null;
    }

    public static Object setFirst(Object object, Object object2) {
        return object instanceof Pair ? (((Pair)object).first = object2) : SchemeUtils.error("Attempt to set-car of a non-Pair:" + SchemeUtils.stringify(object));
    }

    public static Object setRest(Object object, Object object2) {
        return object instanceof Pair ? (((Pair)object).rest = object2) : SchemeUtils.error("Attempt to set-cdr of a non-Pair:" + SchemeUtils.stringify(object));
    }

    public static Object second(Object object) {
        return SchemeUtils.first(SchemeUtils.rest(object));
    }

    public static Object third(Object object) {
        return SchemeUtils.first(SchemeUtils.rest(SchemeUtils.rest(object)));
    }

    public static Pair list(Object object, Object object2) {
        return new Pair(object, new Pair(object2, null));
    }

    public static Pair list(Object object) {
        return new Pair(object, null);
    }

    public static Object listStar(Object object) {
        if (SchemeUtils.rest(object) == null) {
            return SchemeUtils.first(object);
        }
        return SchemeUtils.cons(SchemeUtils.first(object), SchemeUtils.listStar(SchemeUtils.rest(object)));
    }

    public static Pair cons(Object object, Object object2) {
        return new Pair(object, object2);
    }

    public static Object reverse(Object object) {
        Pair pair = null;
        while (object instanceof Pair) {
            pair = SchemeUtils.cons(SchemeUtils.first(object), pair);
            object = SchemeUtils.rest(object);
        }
        return pair;
    }

    public static boolean equal(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object instanceof char[]) {
            if (!(object2 instanceof char[])) {
                return false;
            }
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            if (cArray.length != cArray2.length) {
                return false;
            }
            for (int i = cArray.length - 1; i >= 0; --i) {
                if (cArray[i] == cArray2[i]) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                return false;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = objectArray.length - 1; i >= 0; --i) {
                if (SchemeUtils.equal(objectArray[i], objectArray2[i])) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static boolean eqv(Object object, Object object2) {
        return object == object2 || object instanceof Double && object.equals(object2) || object instanceof Character && object.equals(object2);
    }

    public static int length(Object object) {
        int n = 0;
        while (object instanceof Pair) {
            ++n;
            object = ((Pair)object).rest;
        }
        return n;
    }

    public static char[] listToString(Object object) {
        char[] cArray = new char[SchemeUtils.length(object)];
        int n = 0;
        while (object instanceof Pair) {
            cArray[n] = SchemeUtils.chr(SchemeUtils.first(object));
            object = SchemeUtils.rest(object);
            ++n;
        }
        return cArray;
    }

    public static Object[] listToVector(Object object) {
        Object[] objectArray = new Object[SchemeUtils.length(object)];
        int n = 0;
        while (object instanceof Pair) {
            objectArray[n] = SchemeUtils.first(object);
            object = SchemeUtils.rest(object);
            ++n;
        }
        return objectArray;
    }

    public static Object write(Object object, PrintWriter printWriter, boolean bl) {
        printWriter.print(SchemeUtils.stringify(object, bl));
        printWriter.flush();
        return object;
    }

    public static Pair vectorToList(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Pair pair = null;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                pair = SchemeUtils.cons(objectArray[i], pair);
            }
            return pair;
        }
        SchemeUtils.error("expected a vector, got: " + String.valueOf(object));
        return null;
    }

    static void stringify(Object object, boolean bl, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("()");
        } else if (object instanceof Double) {
            double d = (Double)object;
            if ((double)Math.round(d) == d) {
                stringBuffer.append((long)d);
            } else {
                stringBuffer.append(d);
            }
        } else if (object instanceof Character) {
            if (bl) {
                stringBuffer.append("#\\");
            }
            stringBuffer.append(object);
        } else if (object instanceof Pair) {
            ((Pair)object).stringifyPair(bl, stringBuffer);
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            if (bl) {
                stringBuffer.append('\"');
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (bl && cArray[i] == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(cArray[i]);
            }
            if (bl) {
                stringBuffer.append('\"');
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            stringBuffer.append("#(");
            for (int i = 0; i < objectArray.length; ++i) {
                SchemeUtils.stringify(objectArray[i], bl, stringBuffer);
                if (i == objectArray.length - 1) continue;
                stringBuffer.append(' ');
            }
            stringBuffer.append(')');
        } else if (object == TRUE) {
            stringBuffer.append("#t");
        } else if (object == FALSE) {
            stringBuffer.append("#f");
        } else {
            stringBuffer.append(object);
        }
    }

    static String stringify(Object object) {
        return SchemeUtils.stringify(object, true);
    }

    static String stringify(Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        SchemeUtils.stringify(object, bl, stringBuffer);
        return stringBuffer.toString();
    }

    static Object p(Object object) {
        System.out.println(SchemeUtils.stringify(object));
        return object;
    }

    static Object p(String string, Object object) {
        System.out.println(string + ": " + SchemeUtils.stringify(object));
        return object;
    }
}

