/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.storage;

import com.elixirtech.arch.ElxLoggerJ;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class InstanceManager {
    static Map<String, List<Object>> m_Instances = new TreeMap<String, List<Object>>();

    private InstanceManager() {
    }

    public static void addInstance(Object object) {
        Class<?> clazz = object.getClass();
        List<Object> list = InstanceManager.getList(clazz);
        list.add(object);
    }

    public static List<Object> getAllInstances(Class<?> clazz) {
        String string = clazz.getName();
        if (m_Instances.containsKey(string)) {
            return Collections.unmodifiableList(m_Instances.get(string));
        }
        return Collections.emptyList();
    }

    public static void removeInstance(Object object) {
        String string = object.getClass().getName();
        try {
            if (m_Instances.containsKey(string)) {
                m_Instances.get(string).remove(object);
            }
        }
        catch (Exception exception) {
            ElxLoggerJ.getLogger(InstanceManager.class).warn((Object)("removeInstance error: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    public static void clear() {
        m_Instances.clear();
    }

    private static List<Object> getList(Class<?> clazz) {
        String string = clazz.getName();
        if (m_Instances.containsKey(string)) {
            return m_Instances.get(string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        m_Instances.put(string, arrayList);
        return arrayList;
    }
}

