/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import java.awt.Dimension;
import java.awt.Rectangle;

public class CellStructure {
    private final int m_Rows;
    private final int m_Columns;
    private final Cell[][] m_Cells;
    private final CellModel m_Model;
    private int[] m_RowHeights;
    private int[] m_ColumnWidths;

    public CellStructure(CellModel cellModel, int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("width=" + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("height=" + n2);
        }
        this.m_Model = cellModel;
        this.m_Rows = n2;
        this.m_Columns = n;
        this.m_Cells = new Cell[this.m_Columns][this.m_Rows];
    }

    public int getColumnCount() {
        return this.m_Columns;
    }

    public int getRowCount() {
        return this.m_Rows;
    }

    public int getColumnWidth(int n) {
        return this.m_ColumnWidths[n];
    }

    public int getRowHeight(int n) {
        return this.m_RowHeights[n];
    }

    public Cell addCell(int n, int n2, Object object) {
        if (this.m_Cells[n2][n] != null) {
            throw new RuntimeException("Cell col=" + n2 + ", row=" + n + " already used");
        }
        this.m_Cells[n2][n] = new Cell(object);
        if (n2 >= this.m_Columns || n >= this.m_Rows) {
            throw new RuntimeException("Cell " + n2 + "," + n + " out of range");
        }
        return this.m_Cells[n2][n];
    }

    public Cell getCell(int n, int n2) {
        return this.m_Cells[n2][n];
    }

    public void determineSizes() {
        int n;
        this.m_ColumnWidths = new int[this.m_Columns];
        for (n = 0; n < this.m_Columns; ++n) {
            this.m_ColumnWidths[n] = this.getSingleWidths(n);
        }
        this.m_RowHeights = new int[this.m_Rows];
        for (n = 0; n < this.m_Rows; ++n) {
            this.m_RowHeights[n] = this.getSingleHeights(n);
        }
        for (n = 0; n < this.m_Rows; ++n) {
            for (int i = 0; i < this.m_Columns; ++i) {
                int n2;
                int n3;
                int n4;
                Cell cell = this.m_Cells[i][n];
                if (cell == null) continue;
                if (cell.colSpan > 1 && (n4 = this.getLength(this.m_ColumnWidths, i, cell.colSpan)) < (n3 = this.m_Model.getWidth(cell.data))) {
                    n2 = n3 - n4;
                    this.apportion(this.m_ColumnWidths, i, cell.colSpan, n2);
                }
                if (cell.rowSpan <= 1 || (n4 = this.getLength(this.m_RowHeights, n, cell.rowSpan)) >= (n3 = this.m_Model.getHeight(cell.data))) continue;
                n2 = n3 - n4;
                this.apportion(this.m_RowHeights, n, cell.rowSpan, n2);
            }
        }
    }

    public void applySizes() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_Rows; ++i) {
            for (int j = 0; j < this.m_Columns; ++j) {
                Cell cell = this.m_Cells[j][i];
                if (cell != null) {
                    int n3 = this.getLength(this.m_ColumnWidths, j, cell.colSpan);
                    int n4 = this.getLength(this.m_RowHeights, i, cell.rowSpan);
                    this.m_Model.setBounds(cell.data, new Rectangle(n, n2, n3, n4));
                }
                n += this.m_ColumnWidths[j];
            }
            n = 0;
            n2 += this.m_RowHeights[i];
        }
    }

    public void setRowSpans(int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.m_Columns; ++j) {
                Cell cell = this.m_Cells[j][i];
                if (cell == null) continue;
                cell.rowSpan = n - i;
            }
        }
    }

    public void setColumnSpans(int n) {
        for (int i = 0; i < this.m_Rows; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = this.m_Cells[j][i];
                if (cell == null) continue;
                cell.colSpan = n - j;
            }
        }
    }

    public Dimension getSize() {
        int n;
        Dimension dimension = new Dimension();
        for (n = 0; n < this.m_Columns; ++n) {
            dimension.width += this.m_ColumnWidths[n];
        }
        for (n = 0; n < this.m_Rows; ++n) {
            dimension.height += this.m_RowHeights[n];
        }
        return dimension;
    }

    private int getSingleWidths(int n) {
        int n2 = this.m_Model.getMinimumWidth(n);
        for (int i = 0; i < this.m_Rows; ++i) {
            Cell cell = this.m_Cells[n][i];
            if (cell == null || cell.colSpan != 1) continue;
            n2 = Math.max(n2, this.m_Model.getWidth(cell.data));
        }
        return n2;
    }

    private int getSingleHeights(int n) {
        int n2 = this.m_Model.getMinimumHeight(n);
        for (int i = 0; i < this.m_Columns; ++i) {
            Cell cell = this.m_Cells[i][n];
            if (cell == null || cell.rowSpan != 1) continue;
            n2 = Math.max(n2, this.m_Model.getHeight(cell.data));
        }
        return n2;
    }

    private int getLength(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray[n + i];
        }
        return n3;
    }

    private void apportion(int[] nArray, int n, int n2, int n3) {
        if (n3 > 0) {
            if (n2 == 1) {
                int n4 = n;
                nArray[n4] = nArray[n4] + n3;
            } else {
                int n5 = n3 / n2;
                int n6 = n;
                nArray[n6] = nArray[n6] + n5;
                this.apportion(nArray, n + 1, n2 - 1, n3 - n5);
            }
        }
    }

    public static interface CellModel {
        public int getMinimumWidth(int var1);

        public int getMinimumHeight(int var1);

        public int getWidth(Object var1);

        public int getHeight(Object var1);

        public void setBounds(Object var1, Rectangle var2);
    }

    public static class Cell {
        public int rowSpan = 1;
        public int colSpan = 1;
        public Object data;

        public Cell(Object object) {
            this.data = object;
        }
    }
}

