/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import com.elixirtech.tree.CellStructure;
import com.elixirtech.tree.TreeLayoutManager;
import com.elixirtech.tree.TreeModel;
import com.elixirtech.tree.TreeModelUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class FlatTreeLayoutManager
extends TreeLayoutManager {
    private final TreeModel m_Model;
    private final int m_Direction;
    private final boolean m_TotalsAfter;

    public FlatTreeLayoutManager(TreeModel treeModel, int n, boolean bl) {
        this.m_Model = treeModel;
        this.m_Direction = n;
        this.m_TotalsAfter = bl;
    }

    @Override
    protected void buildCellStructure(Container container) {
        Dimension dimension = TreeModelUtil.calcHorizontalCellStructureSize(this.m_Model);
        Dimension dimension2 = new Dimension(dimension.width, 1);
        int n = this.m_Model.getMeasureCount();
        if (n > 0) {
            dimension2.width *= n;
            ++dimension2.height;
        }
        if (this.m_Direction == 2) {
            FlatTreeLayoutManager.swapAxes(dimension);
            FlatTreeLayoutManager.swapAxes(dimension2);
        }
        this.setupFixedWidths(dimension2);
        this.m_CellStructure = new CellStructure(new TreeCellModel(), dimension2.width, dimension2.height);
        this.buildFlatStructure(container, this.m_Model.getRoot());
    }

    private void buildFlatStructure(Container container, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.buildFlat(object, arrayList);
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            if (this.m_Direction == 1) {
                List<? extends Object> list = this.m_Model.getMeasures(e);
                int n3 = list.size();
                CellStructure.Cell cell = this.m_CellStructure.addCell(0, n, e);
                cell.colSpan = n3;
                if (container != null) {
                    container.add(this.m_Model.getComponent(e));
                }
                for (int j = 0; j < n3; ++j) {
                    Object object2 = list.get(j);
                    this.m_CellStructure.addCell(1, n, object2);
                    if (container != null) {
                        container.add(this.m_Model.getComponent(object2));
                    }
                    ++n;
                }
                continue;
            }
            this.m_CellStructure.addCell(n, 0, e);
            if (container != null) {
                container.add(this.m_Model.getComponent(e));
            }
            ++n;
        }
    }

    private void buildFlat(Object object, List<Object> list) {
        if (this.m_TotalsAfter) {
            if (this.m_Model.hasChildren(object) && this.m_Model.isExpanded(object)) {
                for (Object object2 : this.m_Model.getChildren(object)) {
                    this.buildFlat(object2, list);
                }
            }
            if (this.m_Model.isShowTotals(object)) {
                list.add(object);
            }
        } else {
            if (this.m_Model.isShowTotals(object)) {
                list.add(object);
            }
            if (this.m_Model.hasChildren(object) && this.m_Model.isExpanded(object)) {
                for (Object object3 : this.m_Model.getChildren(object)) {
                    this.buildFlat(object3, list);
                }
            }
        }
    }

    private class TreeCellModel
    implements CellStructure.CellModel {
        private TreeCellModel() {
        }

        @Override
        public int getMinimumHeight(int n) {
            return Math.max(FlatTreeLayoutManager.this.m_MinHeight, FlatTreeLayoutManager.this.m_FixedHeights[n]);
        }

        @Override
        public int getHeight(Object object) {
            JComponent jComponent = FlatTreeLayoutManager.this.m_Model.getComponent(object);
            return FlatTreeLayoutManager.this.getSize((JComponent)jComponent).height;
        }

        @Override
        public int getMinimumWidth(int n) {
            return Math.max(FlatTreeLayoutManager.this.m_MinWidth, FlatTreeLayoutManager.this.m_FixedWidths[n]);
        }

        @Override
        public int getWidth(Object object) {
            JComponent jComponent = FlatTreeLayoutManager.this.m_Model.getComponent(object);
            return FlatTreeLayoutManager.this.getSize((JComponent)jComponent).width;
        }

        @Override
        public void setBounds(Object object, Rectangle rectangle) {
            JComponent jComponent = FlatTreeLayoutManager.this.m_Model.getComponent(object);
            jComponent.setBounds(rectangle);
        }
    }
}

