/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class FastDateFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static String cDefaultPattern;
    private static Map<Object, FastDateFormat> cInstanceCache;
    private static Map<Object, FastDateFormat> cDateInstanceCache;
    private static Map<Object, FastDateFormat> cTimeInstanceCache;
    private static Map<Object, FastDateFormat> cDateTimeInstanceCache;
    private static Map<Object, String> cTimeZoneDisplayCache;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final boolean mTimeZoneForced;
    private final Locale mLocale;
    private final boolean mLocaleForced;
    private Rule[] mRules;
    private int mMaxLengthEstimate;

    public static FastDateFormat getInstance() {
        return FastDateFormat.getInstance(FastDateFormat.getDefaultPattern(), null, null);
    }

    public static FastDateFormat getInstance(String string) {
        return FastDateFormat.getInstance(string, null, null);
    }

    public static FastDateFormat getInstance(String string, TimeZone timeZone) {
        return FastDateFormat.getInstance(string, timeZone, null);
    }

    public static FastDateFormat getInstance(String string, Locale locale) {
        return FastDateFormat.getInstance(string, null, locale);
    }

    public static synchronized FastDateFormat getInstance(String string, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat = new FastDateFormat(string, timeZone, locale);
        FastDateFormat fastDateFormat2 = cInstanceCache.get(fastDateFormat);
        if (fastDateFormat2 == null) {
            fastDateFormat2 = fastDateFormat;
            fastDateFormat2.init();
            cInstanceCache.put(fastDateFormat2, fastDateFormat2);
        }
        return fastDateFormat2;
    }

    public static FastDateFormat getDateInstance(int n) {
        return FastDateFormat.getDateInstance(n, null, null);
    }

    public static FastDateFormat getDateInstance(int n, Locale locale) {
        return FastDateFormat.getDateInstance(n, null, locale);
    }

    public static FastDateFormat getDateInstance(int n, TimeZone timeZone) {
        return FastDateFormat.getDateInstance(n, timeZone, null);
    }

    public static synchronized FastDateFormat getDateInstance(int n, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat;
        Object object = n;
        if (timeZone != null) {
            object = new Pair(object, timeZone);
        }
        if (locale != null) {
            object = new Pair(object, locale);
        }
        if ((fastDateFormat = cDateInstanceCache.get(object)) == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(n, locale);
                String string = simpleDateFormat.toPattern();
                fastDateFormat = FastDateFormat.getInstance(string, timeZone, locale);
                cDateInstanceCache.put(object, fastDateFormat);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date pattern for locale: " + String.valueOf(locale));
            }
        }
        return fastDateFormat;
    }

    public static FastDateFormat getTimeInstance(int n) {
        return FastDateFormat.getTimeInstance(n, null, null);
    }

    public static FastDateFormat getTimeInstance(int n, Locale locale) {
        return FastDateFormat.getTimeInstance(n, null, locale);
    }

    public static FastDateFormat getTimeInstance(int n, TimeZone timeZone) {
        return FastDateFormat.getTimeInstance(n, timeZone, null);
    }

    public static synchronized FastDateFormat getTimeInstance(int n, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat;
        Object object = n;
        if (timeZone != null) {
            object = new Pair(object, timeZone);
        }
        if (locale != null) {
            object = new Pair(object, locale);
        }
        if ((fastDateFormat = cTimeInstanceCache.get(object)) == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(n, locale);
                String string = simpleDateFormat.toPattern();
                fastDateFormat = FastDateFormat.getInstance(string, timeZone, locale);
                cTimeInstanceCache.put(object, fastDateFormat);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date pattern for locale: " + String.valueOf(locale));
            }
        }
        return fastDateFormat;
    }

    public static FastDateFormat getDateTimeInstance(int n, int n2) {
        return FastDateFormat.getDateTimeInstance(n, n2, null, null);
    }

    public static FastDateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return FastDateFormat.getDateTimeInstance(n, n2, null, locale);
    }

    public static FastDateFormat getDateTimeInstance(int n, int n2, TimeZone timeZone) {
        return FastDateFormat.getDateTimeInstance(n, n2, timeZone, null);
    }

    public static synchronized FastDateFormat getDateTimeInstance(int n, int n2, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat;
        Pair pair = new Pair(new Integer(n), new Integer(n2));
        if (timeZone != null) {
            pair = new Pair(pair, timeZone);
        }
        if (locale != null) {
            pair = new Pair(pair, locale);
        }
        if ((fastDateFormat = cDateTimeInstanceCache.get(pair)) == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(n, n2, locale);
                String string = simpleDateFormat.toPattern();
                fastDateFormat = FastDateFormat.getInstance(string, timeZone, locale);
                cDateTimeInstanceCache.put(pair, fastDateFormat);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + String.valueOf(locale));
            }
        }
        return fastDateFormat;
    }

    static synchronized String getTimeZoneDisplay(TimeZone timeZone, boolean bl, int n, Locale locale) {
        TimeZoneDisplayKey timeZoneDisplayKey = new TimeZoneDisplayKey(timeZone, bl, n, locale);
        String string = cTimeZoneDisplayCache.get(timeZoneDisplayKey);
        if (string == null) {
            string = timeZone.getDisplayName(bl, n, locale);
            cTimeZoneDisplayCache.put(timeZoneDisplayKey, string);
        }
        return string;
    }

    private static synchronized String getDefaultPattern() {
        if (cDefaultPattern == null) {
            cDefaultPattern = new SimpleDateFormat().toPattern();
        }
        return cDefaultPattern;
    }

    protected FastDateFormat(String string, TimeZone timeZone, Locale locale) {
        if (string == null) {
            throw new IllegalArgumentException("The pattern must not be null");
        }
        this.mPattern = string;
        boolean bl = this.mTimeZoneForced = timeZone != null;
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.mTimeZone = timeZone;
        boolean bl2 = this.mLocaleForced = locale != null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.mLocale = locale;
    }

    protected void init() {
        List<Rule> list = this.parsePattern();
        this.mRules = list.toArray(new Rule[list.size()]);
        int n = 0;
        int n2 = this.mRules.length;
        while (--n2 >= 0) {
            n += this.mRules[n2].estimateLength();
        }
        this.mMaxLengthEstimate = n;
    }

    protected List<Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            nArray[0] = i;
            String string = this.parseToken(this.mPattern, nArray);
            i = nArray[0];
            int n2 = string.length();
            if (n2 == 0) break;
            char c = string.charAt(0);
            arrayList.add(switch (c) {
                case 'G' -> new TextField(0, stringArray);
                case 'y' -> {
                    if (n2 >= 4) {
                        yield this.selectNumberRule(1, n2);
                    }
                    yield TwoDigitYearField.INSTANCE;
                }
                case 'M' -> {
                    if (n2 >= 4) {
                        yield new TextField(2, stringArray2);
                    }
                    if (n2 == 3) {
                        yield new TextField(2, stringArray3);
                    }
                    if (n2 == 2) {
                        yield TwoDigitMonthField.INSTANCE;
                    }
                    yield UnpaddedMonthField.INSTANCE;
                }
                case 'd' -> this.selectNumberRule(5, n2);
                case 'h' -> new TwelveHourField(this.selectNumberRule(10, n2));
                case 'H' -> this.selectNumberRule(11, n2);
                case 'm' -> this.selectNumberRule(12, n2);
                case 's' -> this.selectNumberRule(13, n2);
                case 'S' -> this.selectNumberRule(14, n2);
                case 'E' -> new TextField(7, n2 < 4 ? stringArray5 : stringArray4);
                case 'D' -> this.selectNumberRule(6, n2);
                case 'F' -> this.selectNumberRule(8, n2);
                case 'w' -> this.selectNumberRule(3, n2);
                case 'W' -> this.selectNumberRule(4, n2);
                case 'a' -> new TextField(9, stringArray6);
                case 'k' -> new TwentyFourHourField(this.selectNumberRule(11, n2));
                case 'K' -> this.selectNumberRule(10, n2);
                case 'z' -> {
                    if (n2 >= 4) {
                        yield new TimeZoneNameRule(this.mTimeZone, this.mTimeZoneForced, this.mLocale, 1);
                    }
                    yield new TimeZoneNameRule(this.mTimeZone, this.mTimeZoneForced, this.mLocale, 0);
                }
                case 'Z' -> {
                    if (n2 == 1) {
                        yield TimeZoneNumberRule.INSTANCE_NO_COLON;
                    }
                    yield TimeZoneNumberRule.INSTANCE_COLON;
                }
                case '\'' -> {
                    String var16_16 = string.substring(1);
                    if (var16_16.length() == 1) {
                        yield new CharacterLiteral(var16_16.charAt(0));
                    }
                    yield new StringLiteral(var16_16);
                }
                default -> throw new IllegalArgumentException("Illegal pattern component: " + string);
            });
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        char c = string.charAt(n);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char c2;
            stringBuffer.append(c);
            while (n + 1 < n2 && (c2 = string.charAt(n + 1)) == c) {
                stringBuffer.append(c);
                ++n;
            }
        } else {
            stringBuffer.append('\'');
            boolean bl = false;
            for (n = nArray[0]; n < n2; ++n) {
                c = string.charAt(n);
                if (c == '\'') {
                    if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuffer.append(c);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    stringBuffer.append(c);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n;
        return stringBuffer.toString();
    }

    protected NumberRule selectNumberRule(int n, int n2) {
        switch (n2) {
            case 1: {
                return new UnpaddedNumberField(n);
            }
            case 2: {
                return new TwoDigitNumberField(n);
            }
        }
        return new PaddedNumberField(n, n2);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    public String format(long l) {
        return this.format(new Date(l));
    }

    public String format(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mTimeZone);
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public StringBuffer format(long l, StringBuffer stringBuffer) {
        return this.format(new Date(l), stringBuffer);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mTimeZone);
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, stringBuffer);
    }

    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        if (this.mTimeZoneForced) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, stringBuffer);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        Rule[] ruleArray = this.mRules;
        int n = this.mRules.length;
        for (int i = 0; i < n; ++i) {
            ruleArray[i].appendTo(stringBuffer, calendar);
        }
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        parsePosition.setIndex(0);
        parsePosition.setErrorIndex(0);
        return null;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public boolean getTimeZoneOverridesCalendar() {
        return this.mTimeZoneForced;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateFormat)) {
            return false;
        }
        FastDateFormat fastDateFormat = (FastDateFormat)object;
        return !(this.mPattern != fastDateFormat.mPattern && !this.mPattern.equals(fastDateFormat.mPattern) || this.mTimeZone != fastDateFormat.mTimeZone && !this.mTimeZone.equals(fastDateFormat.mTimeZone) || this.mLocale != fastDateFormat.mLocale && !this.mLocale.equals(fastDateFormat.mLocale) || this.mTimeZoneForced != fastDateFormat.mTimeZoneForced || this.mLocaleForced != fastDateFormat.mLocaleForced);
    }

    public int hashCode() {
        int n = 0;
        n += this.mPattern.hashCode();
        n += this.mTimeZone.hashCode();
        n += this.mTimeZoneForced ? 1 : 0;
        n += this.mLocale.hashCode();
        return n += this.mLocaleForced ? 1 : 0;
    }

    public String toString() {
        return "FastDateFormat[" + this.mPattern + "]";
    }

    static {
        cInstanceCache = new HashMap<Object, FastDateFormat>(7);
        cDateInstanceCache = new HashMap<Object, FastDateFormat>(7);
        cTimeInstanceCache = new HashMap<Object, FastDateFormat>(7);
        cDateTimeInstanceCache = new HashMap<Object, FastDateFormat>(7);
        cTimeZoneDisplayCache = new HashMap<Object, String>(7);
    }

    private static class Pair {
        private final Object mObj1;
        private final Object mObj2;

        public Pair(Object object, Object object2) {
            this.mObj1 = object;
            this.mObj2 = object2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)object;
            return (this.mObj1 == null ? pair.mObj1 == null : this.mObj1.equals(pair.mObj1)) && (this.mObj2 == null ? pair.mObj2 == null : this.mObj2.equals(pair.mObj2));
        }

        public int hashCode() {
            return (this.mObj1 == null ? 0 : this.mObj1.hashCode()) + (this.mObj2 == null ? 0 : this.mObj2.hashCode());
        }

        public String toString() {
            return "[" + String.valueOf(this.mObj1) + ":" + String.valueOf(this.mObj2) + "]";
        }
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone mTimeZone;
        private final int mStyle;
        private final Locale mLocale;

        TimeZoneDisplayKey(TimeZone timeZone, boolean bl, int n, Locale locale) {
            this.mTimeZone = timeZone;
            if (bl) {
                n |= Integer.MIN_VALUE;
            }
            this.mStyle = n;
            this.mLocale = locale;
        }

        public int hashCode() {
            return this.mStyle * 31 + this.mLocale.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TimeZoneDisplayKey) {
                TimeZoneDisplayKey timeZoneDisplayKey = (TimeZoneDisplayKey)object;
                return this.mTimeZone.equals(timeZoneDisplayKey.mTimeZone) && this.mStyle == timeZoneDisplayKey.mStyle && this.mLocale.equals(timeZoneDisplayKey.mLocale);
            }
            return false;
        }
    }

    protected static interface Rule {
        public int estimateLength();

        public void appendTo(StringBuffer var1, Calendar var2);
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        TextField(int n, String[] stringArray) {
            this.mField = n;
            this.mValues = stringArray;
        }

        @Override
        public int estimateLength() {
            int n = 0;
            int n2 = this.mValues.length;
            while (--n2 >= 0) {
                int n3 = this.mValues[n2].length();
                if (n3 <= n) continue;
                n = n3;
            }
            return n;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValues[calendar.get(this.mField)]);
        }
    }

    protected static interface NumberRule
    extends Rule {
        public void appendTo(StringBuffer var1, int var2);
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(1) % 100);
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n) {
            stringBuffer.append((char)(n / 10 + 48));
            stringBuffer.append((char)(n % 10 + 48));
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n) {
            stringBuffer.append((char)(n / 10 + 48));
            stringBuffer.append((char)(n % 10 + 48));
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n) {
            if (n < 10) {
                stringBuffer.append((char)(n + 48));
            } else {
                stringBuffer.append((char)(n / 10 + 48));
                stringBuffer.append((char)(n % 10 + 48));
            }
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwelveHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n = calendar.get(10);
            if (n == 0) {
                n = calendar.getLeastMaximum(10) + 1;
            }
            this.mRule.appendTo(stringBuffer, n);
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, int n) {
            this.mRule.appendTo(stringBuffer, n);
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwentyFourHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n = calendar.get(11);
            if (n == 0) {
                n = calendar.getMaximum(11) + 1;
            }
            this.mRule.appendTo(stringBuffer, n);
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, int n) {
            this.mRule.appendTo(stringBuffer, n);
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final TimeZone mTimeZone;
        private final boolean mTimeZoneForced;
        private final Locale mLocale;
        private final int mStyle;
        private final String mStandard;
        private final String mDaylight;

        TimeZoneNameRule(TimeZone timeZone, boolean bl, Locale locale, int n) {
            this.mTimeZone = timeZone;
            this.mTimeZoneForced = bl;
            this.mLocale = locale;
            this.mStyle = n;
            if (bl) {
                this.mStandard = FastDateFormat.getTimeZoneDisplay(timeZone, false, n, locale);
                this.mDaylight = FastDateFormat.getTimeZoneDisplay(timeZone, true, n, locale);
            } else {
                this.mStandard = null;
                this.mDaylight = null;
            }
        }

        @Override
        public int estimateLength() {
            if (this.mTimeZoneForced) {
                return Math.max(this.mStandard.length(), this.mDaylight.length());
            }
            if (this.mStyle == 0) {
                return 4;
            }
            return 40;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            if (this.mTimeZoneForced) {
                if (this.mTimeZone.useDaylightTime() && calendar.get(16) != 0) {
                    stringBuffer.append(this.mDaylight);
                } else {
                    stringBuffer.append(this.mStandard);
                }
            } else {
                TimeZone timeZone = calendar.getTimeZone();
                if (timeZone.useDaylightTime() && calendar.get(16) != 0) {
                    stringBuffer.append(FastDateFormat.getTimeZoneDisplay(timeZone, true, this.mStyle, this.mLocale));
                } else {
                    stringBuffer.append(FastDateFormat.getTimeZoneDisplay(timeZone, false, this.mStyle, this.mLocale));
                }
            }
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        final boolean mColon;

        TimeZoneNumberRule(boolean bl) {
            this.mColon = bl;
        }

        @Override
        public int estimateLength() {
            return 5;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n = calendar.get(15) + calendar.get(16);
            if (n < 0) {
                stringBuffer.append('-');
                n = -n;
            } else {
                stringBuffer.append('+');
            }
            int n2 = n / 3600000;
            stringBuffer.append((char)(n2 / 10 + 48));
            stringBuffer.append((char)(n2 % 10 + 48));
            if (this.mColon) {
                stringBuffer.append(':');
            }
            int n3 = n / 60000 - 60 * n2;
            stringBuffer.append((char)(n3 / 10 + 48));
            stringBuffer.append((char)(n3 % 10 + 48));
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        CharacterLiteral(char c) {
            this.mValue = c;
        }

        @Override
        public int estimateLength() {
            return 1;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValue);
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        StringLiteral(String string) {
            this.mValue = string;
        }

        @Override
        public int estimateLength() {
            return this.mValue.length();
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValue);
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        static final UnpaddedNumberField INSTANCE_YEAR = new UnpaddedNumberField(1);
        private final int mField;

        UnpaddedNumberField(int n) {
            this.mField = n;
        }

        @Override
        public int estimateLength() {
            return 4;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n) {
            if (n < 10) {
                stringBuffer.append((char)(n + 48));
            } else if (n < 100) {
                stringBuffer.append((char)(n / 10 + 48));
                stringBuffer.append((char)(n % 10 + 48));
            } else {
                stringBuffer.append(Integer.toString(n));
            }
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        TwoDigitNumberField(int n) {
            this.mField = n;
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n) {
            if (n < 100) {
                stringBuffer.append((char)(n / 10 + 48));
                stringBuffer.append((char)(n % 10 + 48));
            } else {
                stringBuffer.append(Integer.toString(n));
            }
        }
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        PaddedNumberField(int n, int n2) {
            if (n2 < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = n;
            this.mSize = n2;
        }

        @Override
        public int estimateLength() {
            return 4;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n) {
            if (n < 100) {
                int n2 = this.mSize;
                while (--n2 >= 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append((char)(n / 10 + 48));
                stringBuffer.append((char)(n % 10 + 48));
            } else {
                int n3;
                int n4;
                if (n < 1000) {
                    n4 = 3;
                } else {
                    int n5 = n3 = n > -1 ? 1 : 0;
                    if (n3 == 0) {
                        String string = "Negative values should not be possible: " + n;
                        throw new IllegalArgumentException(string);
                    }
                    n4 = Integer.toString(n).length();
                }
                n3 = this.mSize;
                while (--n3 >= n4) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(n));
            }
        }
    }
}

