/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.glyph;

import com.elixirtech.util.glyph.GlyphVisitor;
import java.awt.Dimension;

public class Glyph {
    protected Glyph m_Prev;
    protected Glyph m_Next;
    protected Dimension m_Dimension = new Dimension(0, 0);

    public Dimension getDimension() {
        return this.m_Dimension;
    }

    public void accept(GlyphVisitor glyphVisitor) {
        if (this.m_Next != null) {
            this.m_Next.accept(glyphVisitor);
        }
    }

    public Glyph getNext() {
        return this.m_Next;
    }

    public Glyph getPrev() {
        return this.m_Prev;
    }

    public void addBefore(Glyph glyph) {
        this.m_Prev = glyph.m_Prev;
        if (this.m_Prev != null) {
            this.m_Prev.m_Next = this;
        }
        this.m_Next = glyph;
        this.m_Next.m_Prev = this;
    }

    public void addAfter(Glyph glyph) {
        assert (glyph != null);
        this.m_Next = glyph.m_Next;
        if (this.m_Next != null) {
            assert (this.m_Next.m_Prev != null);
            this.m_Next.m_Prev = this;
        }
        this.m_Prev = glyph;
        this.m_Prev.m_Next = this;
    }

    public void remove() {
        if (this.m_Prev != null) {
            this.m_Prev.m_Next = this.m_Next;
        }
        if (this.m_Next != null) {
            this.m_Next.m_Prev = this.m_Prev;
        }
    }

    protected void setDimension(Dimension dimension) {
        this.m_Dimension = dimension;
    }

    protected void setDimension(int n, int n2) {
        this.m_Dimension.width = n;
        this.m_Dimension.height = n2;
    }
}

