/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.glyph;

import com.elixirtech.util.glyph.CRGlyph;
import com.elixirtech.util.glyph.CharGlyph;
import com.elixirtech.util.glyph.EndGlyph;
import com.elixirtech.util.glyph.Glyph;
import com.elixirtech.util.glyph.HardCRGlyph;
import com.elixirtech.util.glyph.SpaceGlyph;

public final class GlyphBuilder {
    Glyph m_FirstGlyph;
    Glyph m_LastGlyph;

    public GlyphBuilder(String string) {
        this.m_LastGlyph = this.m_FirstGlyph = new CRGlyph();
        for (int i = 0; i < string.length(); ++i) {
            this.add(string.charAt(i));
        }
        this.addGlyph(new EndGlyph());
    }

    public GlyphBuilder(char[] cArray) {
        this.m_LastGlyph = this.m_FirstGlyph = new Glyph();
        for (int i = 0; i < cArray.length; ++i) {
            this.add(cArray[i]);
        }
        this.addGlyph(new EndGlyph());
    }

    public Glyph getFirstGlyph() {
        return this.m_FirstGlyph;
    }

    void add(char c) {
        if (c == '\n') {
            this.addGlyph(new HardCRGlyph());
        } else if (c == ' ') {
            this.addGlyph(new SpaceGlyph());
        } else if (c == '\t') {
            this.addGlyph(new SpaceGlyph());
        } else {
            this.addGlyph(new CharGlyph(c));
        }
    }

    void addGlyph(Glyph glyph) {
        glyph.addAfter(this.m_LastGlyph);
        this.m_LastGlyph = glyph;
    }
}

