/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.glyph;

import com.elixirtech.util.glyph.CRGlyph;
import com.elixirtech.util.glyph.CharGlyph;
import com.elixirtech.util.glyph.ColorGlyph;
import com.elixirtech.util.glyph.ColumnBreakGlyph;
import com.elixirtech.util.glyph.EndGlyph;
import com.elixirtech.util.glyph.FontGlyph;
import com.elixirtech.util.glyph.GlyphVisitor;
import com.elixirtech.util.glyph.HardCRGlyph;
import com.elixirtech.util.glyph.PageBreakGlyph;
import com.elixirtech.util.glyph.SelectOffGlyph;
import com.elixirtech.util.glyph.SelectOnGlyph;
import com.elixirtech.util.glyph.SoftEndGlyph;
import com.elixirtech.util.glyph.SpaceGlyph;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class GlyphSizer
implements GlyphVisitor {
    Graphics m_Graphics;
    FontMetrics m_FontMetrics;
    int m_Height;
    int m_SpaceWidth;

    public GlyphSizer(Graphics graphics) {
        this.m_Graphics = graphics;
        this.m_FontMetrics = graphics.getFontMetrics();
        this.m_Height = this.m_FontMetrics.getHeight();
        this.m_SpaceWidth = this.m_FontMetrics.stringWidth(" ");
    }

    @Override
    public boolean visitCharGlyph(CharGlyph charGlyph) {
        int n = this.m_FontMetrics.stringWidth(new StringBuffer(1).append(charGlyph.getChar()).toString());
        n = Math.max(5, n);
        charGlyph.setDimension(n, this.m_Height);
        return true;
    }

    @Override
    public boolean visitSpaceGlyph(SpaceGlyph spaceGlyph) {
        spaceGlyph.setDimension(this.m_SpaceWidth, this.m_Height);
        return true;
    }

    @Override
    public boolean visitColorGlyph(ColorGlyph colorGlyph) {
        return true;
    }

    @Override
    public boolean visitCRGlyph(CRGlyph cRGlyph) {
        return true;
    }

    @Override
    public boolean visitHardCRGlyph(HardCRGlyph hardCRGlyph) {
        return true;
    }

    @Override
    public boolean visitPageBreakGlyph(PageBreakGlyph pageBreakGlyph) {
        return true;
    }

    @Override
    public boolean visitColumnBreakGlyph(ColumnBreakGlyph columnBreakGlyph) {
        return true;
    }

    @Override
    public boolean visitSoftEndGlyph(SoftEndGlyph softEndGlyph) {
        return true;
    }

    @Override
    public boolean visitFontGlyph(FontGlyph fontGlyph) {
        this.m_Graphics.setFont(fontGlyph.getFont());
        this.m_FontMetrics = this.m_Graphics.getFontMetrics();
        this.m_Height = this.m_FontMetrics.getHeight();
        this.m_SpaceWidth = this.m_FontMetrics.stringWidth(" ");
        return true;
    }

    @Override
    public boolean visitSelectOnGlyph(SelectOnGlyph selectOnGlyph) {
        return true;
    }

    @Override
    public boolean visitSelectOffGlyph(SelectOffGlyph selectOffGlyph) {
        return true;
    }

    @Override
    public boolean visitEndGlyph(EndGlyph endGlyph) {
        return true;
    }
}

