/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.java4less.rss.BarCode;
import com.java4less.rss.CC;
import com.java4less.rss.CC_B;
import com.java4less.rss.RSSUtil;

class CC_A
extends CC {
    private static final int BIT_LEN = 197;
    private static final int MAX_BYTES = 148;
    private static final int CONF_COLUMNS = 0;
    private static final int CONF_ROWS = 1;
    private static final int CONF_CODEWORDS = 2;
    private static final int CONF_EC = 3;
    public static int FORMAT_2X5 = 0;
    public static int FORMAT_2X6 = 1;
    public static int FORMAT_2X7 = 2;
    public static int FORMAT_2X8 = 3;
    public static int FORMAT_2X9 = 4;
    public static int FORMAT_2X10 = 5;
    public static int FORMAT_2X12 = 6;
    public static int FORMAT_3X4 = 7;
    public static int FORMAT_3X5 = 8;
    public static int FORMAT_3X6 = 9;
    public static int FORMAT_3X7 = 10;
    public static int FORMAT_3X8 = 11;
    public static int FORMAT_4X3 = 12;
    public static int FORMAT_4X4 = 13;
    public static int FORMAT_4X5 = 14;
    public static int FORMAT_4X6 = 15;
    public static int FORMAT_4X7 = 16;
    public static int[] dataCw4 = new int[]{8, 11, 14, 17, 20};
    public static int[] eccCw4 = new int[]{4, 5, 6, 7, 8};
    public static int[] configurations4 = new int[]{FORMAT_4X3, FORMAT_4X4, FORMAT_4X5, FORMAT_4X6, FORMAT_4X7};
    public static int[] dataCw3 = new int[]{8, 10, 12, 14, 17};
    public static int[] eccCw3 = new int[]{4, 5, 6, 7, 7};
    public static int[] configurations3 = new int[]{FORMAT_3X4, FORMAT_3X5, FORMAT_3X6, FORMAT_3X7, FORMAT_3X8};
    public static int[] dataCw2 = new int[]{6, 8, 9, 11, 12, 14, 17};
    public static int[] eccCw2 = new int[]{4, 4, 5, 5, 6, 6, 7};
    public static int[] configurations2 = new int[]{FORMAT_2X5, FORMAT_2X6, FORMAT_2X7, FORMAT_2X8, FORMAT_2X9, FORMAT_2X10, FORMAT_2X12};
    public int[] CCSizes = null;
    public int[] dataCw;
    public int[] eccCw;
    public int[] cwConfigurations;
    protected int selectedConfiguration = -1;
    int[][] patterns = new int[][]{{1, 2, 2, 1, 3, 1, 1, 1, 1, 2, 2, 3, 1}, {2, 3, 1, 1, 3, 1, 1, 1, 2, 1, 2, 3, 1}, {3, 3, 1, 2, 2, 1, 1, 1, 2, 2, 1, 3, 1}, {4, 2, 2, 2, 2, 1, 1, 1, 3, 1, 1, 3, 1}, {5, 2, 1, 3, 2, 1, 1, 1, 3, 1, 2, 2, 1}, {6, 2, 1, 4, 1, 1, 1, 1, 3, 2, 1, 2, 1}, {7, 2, 2, 3, 1, 1, 1, 1, 4, 1, 1, 2, 1}, {8, 3, 1, 3, 1, 1, 1, 1, 4, 1, 2, 1, 1}, {9, 3, 2, 2, 1, 1, 1, 1, 4, 2, 1, 1, 1}, {10, 4, 1, 2, 1, 1, 1, 1, 3, 3, 1, 1, 1}, {11, 4, 2, 1, 1, 1, 1, 1, 3, 2, 2, 1, 1}, {12, 3, 3, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1}, {13, 2, 4, 1, 1, 1, 1, 1, 2, 2, 3, 1, 1}, {14, 2, 3, 2, 1, 1, 1, 1, 2, 3, 2, 1, 1}, {15, 2, 3, 1, 2, 1, 1, 1, 2, 4, 1, 1, 1}, {16, 3, 2, 1, 2, 1, 1, 1, 1, 5, 1, 1, 1}, {17, 4, 1, 1, 2, 1, 1, 1, 1, 4, 2, 1, 1}, {18, 4, 1, 1, 1, 2, 1, 1, 1, 4, 1, 2, 1}, {19, 4, 1, 1, 1, 1, 2, 1, 2, 3, 1, 2, 1}, {20, 3, 2, 1, 1, 1, 2, 1, 2, 3, 1, 1, 2}, {21, 3, 1, 2, 1, 1, 2, 1, 2, 2, 2, 1, 2}, {22, 3, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1}, {23, 3, 1, 1, 2, 2, 1, 1, 2, 1, 3, 2, 1}, {24, 3, 1, 1, 1, 3, 1, 1, 2, 1, 4, 1, 1}, {25, 3, 1, 1, 1, 2, 2, 1, 1, 2, 4, 1, 1}, {26, 3, 1, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1}, {27, 2, 2, 1, 1, 1, 3, 1, 1, 3, 2, 2, 1}, {28, 2, 2, 1, 1, 2, 2, 1, 1, 3, 2, 1, 2}, {29, 2, 2, 1, 1, 3, 1, 1, 1, 3, 1, 2, 2}, {30, 2, 2, 1, 2, 2, 1, 1, 2, 2, 1, 2, 2}, {31, 2, 2, 2, 1, 2, 1, 1, 3, 1, 1, 2, 2}, {32, 3, 1, 2, 1, 2, 1, 1, 3, 1, 1, 1, 3}, {33, 3, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 3}, {34, 2, 3, 1, 1, 2, 1, 1, 1, 3, 1, 1, 3}, {35, 2, 3, 1, 1, 1, 2, 1, 1, 2, 2, 1, 3}, {36, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 2}, {37, 2, 1, 3, 1, 1, 2, 1, 1, 2, 3, 1, 2}, {38, 2, 1, 2, 2, 1, 2, 1, 1, 2, 3, 2, 1}, {39, 2, 1, 2, 2, 2, 1, 1, 1, 1, 4, 2, 1}, {40, 2, 1, 2, 1, 3, 1, 1, 1, 1, 3, 3, 1}, {41, 2, 1, 2, 1, 2, 2, 1, 1, 1, 3, 2, 2}, {42, 2, 1, 2, 1, 1, 3, 1, 1, 1, 2, 3, 2}, {43, 2, 1, 1, 2, 1, 3, 1, 1, 1, 2, 2, 3}, {44, 2, 1, 1, 1, 2, 3, 1, 1, 1, 1, 3, 3}, {45, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 2, 4}, {46, 2, 1, 1, 1, 4, 1, 1, 1, 1, 2, 1, 4}, {47, 2, 1, 1, 2, 3, 1, 1, 1, 2, 1, 1, 4}, {48, 2, 1, 1, 2, 2, 2, 1, 2, 1, 1, 1, 4}, {49, 2, 1, 1, 3, 1, 2, 1, 2, 1, 1, 2, 3}, {50, 2, 1, 1, 3, 2, 1, 1, 2, 1, 1, 3, 2}, {51, 2, 1, 1, 4, 1, 1, 1, 1, 2, 1, 3, 2}, {52, 2, 1, 2, 3, 1, 1, 1, 1, 2, 1, 4, 1}};
    int[][] startingPatternNumbers = new int[][]{{2, 5, 39, 0, 19}, {2, 6, 1, 0, 33}, {2, 7, 32, 0, 12}, {2, 8, 8, 0, 40}, {2, 9, 14, 0, 46}, {2, 10, 43, 0, 23}, {2, 12, 20, 0, 52}, {3, 4, 11, 43, 23}, {3, 5, 1, 33, 13}, {3, 6, 5, 37, 17}, {3, 7, 15, 47, 27}, {3, 8, 21, 1, 33}, {4, 3, 40, 20, 52}, {4, 4, 43, 23, 3}, {4, 5, 46, 26, 6}, {4, 6, 34, 14, 46}, {4, 7, 29, 9, 41}};
    int[][] configurations = new int[][]{{2, 5, 10, 4}, {2, 6, 12, 4}, {2, 7, 14, 5}, {2, 8, 16, 5}, {2, 9, 18, 6}, {2, 10, 20, 6}, {2, 12, 24, 7}, {3, 4, 12, 4}, {3, 5, 15, 5}, {3, 6, 18, 6}, {3, 7, 21, 7}, {3, 8, 24, 7}, {4, 3, 12, 4}, {4, 4, 16, 5}, {4, 5, 20, 6}, {4, 6, 24, 7}, {4, 7, 28, 8}};
    private int[][] pwr928 = new int[69][7];

    CC_A() {
    }

    public int[][] paintPDF417() {
        int n = 0;
        if (this.PDFColumns == 2) {
            this.eccCw = eccCw2;
            this.dataCw = dataCw2;
            this.CCSizes = RSSUtil.CC2Sizes;
            this.cwConfigurations = configurations2;
            n = 55;
        }
        if (this.PDFColumns == 3) {
            this.eccCw = eccCw3;
            this.dataCw = dataCw3;
            this.CCSizes = RSSUtil.CC3Sizes;
            this.cwConfigurations = configurations3;
            n = 72;
        }
        if (this.PDFColumns == 4) {
            this.eccCw = eccCw4;
            this.dataCw = dataCw4;
            this.CCSizes = RSSUtil.CC4Sizes;
            this.cwConfigurations = configurations4;
            n = 99;
        }
        this.currentY = 0;
        this.currentX = 0;
        int[] nArray = null;
        RSSUtil rSSUtil = new RSSUtil();
        byte[] byArray = new byte[148];
        nArray = new int[176];
        rSSUtil.CCSizes = this.CCSizes;
        int n2 = rSSUtil.pack(this.code, byArray, 0);
        boolean bl = false;
        if (this.PDFColumns == 2 && n2 > RSSUtil.MAX_CCA2_SIZE) {
            bl = true;
        }
        if (this.PDFColumns == 3 && n2 > RSSUtil.MAX_CCA3_SIZE) {
            bl = true;
        }
        if (this.PDFColumns == 4 && n2 > RSSUtil.MAX_CCA4_SIZE) {
            bl = true;
        }
        if (bl) {
            CC_B cC_B = new CC_B();
            cC_B.PDFColumns = this.PDFColumns;
            cC_B.setCode(this.code);
            return cC_B.paintPDF417();
        }
        this.selectedConfiguration = this.cwConfigurations[n2];
        this.init928();
        this.encode928(byArray, nArray, this.CCSizes[n2]);
        this.ReedSolomon(nArray, this.dataCw[n2], this.eccCw[n2]);
        int n3 = 0;
        this.PDFRows = this.configurations[this.selectedConfiguration][1];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.startingPatternNumbers.length; ++i) {
            if (this.startingPatternNumbers[i][0] != this.PDFColumns || this.startingPatternNumbers[i][1] != this.PDFRows) continue;
            n4 = this.startingPatternNumbers[i][2];
            n5 = this.startingPatternNumbers[i][3];
            n6 = this.startingPatternNumbers[i][4];
        }
        int[][] nArray2 = BarCode.createBarMap(n, this.PDFRows, BarCode.EMPTY);
        for (int i = 0; i < this.PDFRows; ++i) {
            int n7;
            int n8;
            this.currentX = 0;
            int n9 = this.PDFColumns - 1;
            int n10 = i % 3;
            int n11 = i / 3;
            int n12 = (this.PDFRows - 1) / 3;
            Object object = "";
            if (this.PDFColumns != 3) {
                for (n8 = 0; n8 < 6; ++n8) {
                    object = (String)object + this.patterns[n4 - 1][1 + n8];
                }
                this.currentX += this.paintCharWithHeight(nArray2, "bwbwbw", (String)object, this.currentX, this.currentY);
            }
            for (int j = 1; j <= this.PDFColumns; ++j) {
                if (this.PDFColumns == 3 && j == 2 || this.PDFColumns == 4 && j == 3) {
                    Object object2 = "";
                    for (n7 = 0; n7 < 6; ++n7) {
                        object2 = (String)object2 + this.patterns[n5 - 1][7 + n7];
                    }
                    this.currentX += this.paintCharWithHeight(nArray2, "bwbwbw", (String)object2, this.currentX, this.currentY);
                }
                n8 = (n4 - 1) % 3 * 3;
                this.currentX += this.paintCharWithHeight(nArray2, "bwbwbwbw", this.toXSecuence(this.PDF417_BITS[n8 / 3][nArray[n3++]]), this.currentX, this.currentY);
            }
            Object object3 = "";
            for (n7 = 0; n7 < 6; ++n7) {
                object3 = (String)object3 + this.patterns[n6 - 1][1 + n7];
            }
            this.currentX += this.paintCharWithHeight(nArray2, "bwbwbw", (String)object3, this.currentX, this.currentY);
            this.currentX += this.paintCharWithHeight(nArray2, "b", "1", this.currentX, this.currentY);
            ++this.currentY;
            if (++n4 == 53) {
                n4 = 1;
            }
            if (++n5 == 53) {
                n5 = 1;
            }
            if (++n6 != 53) continue;
            n6 = 1;
        }
        return nArray2;
    }

    public long min(long l, long l2) {
        if (l > l2) {
            return l2;
        }
        return l;
    }

    public void putBits(int[] nArray, int n, int n2, int n3) {
        if (n > 1600 || n2 > 16) {
            System.out.println("\nerror " + n + ", " + n2 + "\n");
            return;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            if ((n3 & 1) != 0) {
                int n4 = (n + i) / 16;
                nArray[n4] = nArray[n4] | 32768 >> (n + i) % 16;
            } else {
                int n5 = (n + i) / 16;
                nArray[n5] = nArray[n5] & ~(32768 >> (n + i) % 16);
            }
            n3 >>= 1;
        }
    }

    protected void ReedSolomon(int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[512];
        int n4 = 929;
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        for (n3 = 0; n3 < 929; ++n3) {
            nArray3[n3] = 0;
        }
        int n5 = 1;
        n3 = 0;
        while (n3 < 928) {
            nArray4[n3] = n5;
            nArray3[n5] = n3++;
            n5 = n5 * 3 % 929;
        }
        nArray2[0] = 1;
        for (n5 = 1; n5 < n2 + 1; ++n5) {
            nArray2[n5] = 0;
        }
        for (n5 = 0; n5 < n2; ++n5) {
            for (n3 = n5; n3 >= 0; --n3) {
                nArray2[n3 + 1] = (nArray2[n3] + this.mult(nArray2[n3 + 1], nArray4[n5 + 1], nArray3, nArray4, n4)) % n4;
            }
            nArray2[0] = this.mult(nArray2[0], nArray4[n5 + 1], nArray3, nArray4, n4);
        }
        for (n5 = n2 - 1; n5 >= 0; n5 -= 2) {
            nArray2[n5] = (n4 - nArray2[n5]) % n4;
        }
        for (n5 = n; n5 < n + n2; ++n5) {
            nArray[n5] = 0;
        }
        for (int i = 0; i < n; ++i) {
            int n6 = (nArray[n] + nArray[i]) % n4;
            for (n5 = 0; n5 < n2 - 1; ++n5) {
                nArray[n + n5] = (nArray[n + n5 + 1] + n4 - this.mult(n6, nArray2[n2 - 1 - n5], nArray3, nArray4, n4)) % n4;
            }
            nArray[n + n2 - 1] = (n4 - this.mult(n6, nArray2[0], nArray3, nArray4, n4)) % n4;
        }
        for (n5 = n; n5 < n + n2; ++n5) {
            nArray[n5] = (n4 - nArray[n5]) % n4;
        }
    }

    protected int findChar(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.compareTo(stringArray[i][0]) != 0) continue;
            return i;
        }
        return -1;
    }

    int getBit(byte[] byArray, int n) {
        return (byArray[n / 8] & 128 >> n % 8) == 0 ? 0 : 1;
    }

    int encode928(byte[] byArray, int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            int n5;
            int n6 = (int)this.min(n - n2, 69L);
            int n7 = n6 / 10 + 1;
            n3 += n7;
            for (n5 = 0; n5 < n7; ++n5) {
                nArray[n4 + n5] = 0;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                if (this.getBit(byArray, n2 + n6 - n5 - 1) != 1) continue;
                for (int i = 0; i < n7; ++i) {
                    int n8 = n4 + i;
                    nArray[n8] = nArray[n8] + this.pwr928[n5][i + 7 - n7];
                }
            }
            for (n5 = n7 - 1; n5 > 0; --n5) {
                int n9 = n4 + n5 - 1;
                nArray[n9] = (int)((long)nArray[n9] + (long)nArray[n4 + n5] / 928L);
                int n10 = n4 + n5;
                nArray[n10] = (int)((long)nArray[n10] % 928L);
            }
            n2 += 69;
            n4 += 7;
        }
        return n3;
    }

    int decode928(byte[] byArray, int[] nArray, int n) {
        long[] lArray = new long[5];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; i += 7) {
            int n4;
            int n5;
            int n6 = (int)this.min(n - i, 7L);
            int n7 = n6 * 10 - 1;
            n3 += n7;
            lArray[4] = nArray[i];
            for (n5 = 3; n5 >= 0; --n5) {
                lArray[n5] = 0L;
            }
            for (n5 = 1; n5 < n6; ++n5) {
                n4 = 4;
                while (n4 > 0) {
                    int n8 = n4--;
                    lArray[n8] = lArray[n8] * 928L;
                }
                lArray[4] = lArray[4] + (long)nArray[i + n5];
                n4 = 4;
                while (n4 > 0) {
                    int n9 = n4 - 1;
                    lArray[n9] = lArray[n9] + (lArray[n4] >> 16);
                    int n10 = n4--;
                    lArray[n10] = lArray[n10] & 0xFFFFL;
                }
            }
            RSSUtil rSSUtil = new RSSUtil();
            n4 = 4;
            for (n5 = n7; n5 >= 0; n5 -= 16) {
                int n11 = (int)this.min(n5, 16L);
                rSSUtil.putBits(byArray, n2 + n5 - n11, n11, (int)lArray[n4], -1);
                --n4;
            }
            n2 += 69;
        }
        return n3;
    }

    private int mult(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        int n4 = nArray2[(nArray[n] + nArray[n2]) % (n3 - 1)];
        return n4;
    }

    private void init928() {
        int[] nArray = new int[7];
        try {
            int n;
            nArray[6] = 1;
            for (n = 5; n >= 0; --n) {
                nArray[n] = 0;
            }
            for (n = 0; n < 7; ++n) {
                this.pwr928[0][n] = nArray[n];
            }
            for (int i = 1; i < 69; ++i) {
                int n2 = 0;
                for (n = 6; n >= 1; --n) {
                    n2 = 2 * nArray[n] + n2 / 928;
                    this.pwr928[i][n] = nArray[n] = n2 % 928;
                }
                this.pwr928[i][0] = nArray[0] = 2 * nArray[0] + n2 / 928;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }
}

