/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.elixirtech.arch.ElxLoggerJ;
import com.java4less.rss.BarCode;
import com.java4less.rss.RSS;
import com.java4less.rss.RSSLimited;
import com.java4less.rss.RSSUtil;
import java.awt.Dimension;
import java.awt.Graphics;

public class RSSExpanded
extends RSSLimited {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RSSExpanded.class);
    private static final int CHECKSUM_MOD = 211;
    private static final int MAX_DBL_SEGS = 12;
    private static final int ELMNTS = 21;
    static int[] parWeights = new int[]{0, 1, 20, 189, 193, 62, 185, 113, 150, 46, 76, 43, 16, 109, 70, 134, 148, 6, 120, 79, 103, 161, 55, 45};
    private static int[][] finders = new int[][]{{1, 8, 4}, {3, 6, 4}, {3, 4, 6}, {3, 2, 8}, {2, 6, 5}, {2, 2, 9}};
    private static int[][] finderSets = new int[][]{{1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, -2, 2, 0, 0, 0, 0, 0, 0, 0, 0}, {1, -3, 2, -4, 0, 0, 0, 0, 0, 0, 0}, {1, -5, 2, -4, 3, 0, 0, 0, 0, 0, 0}, {1, -5, 2, -4, 4, -6, 0, 0, 0, 0, 0}, {1, -5, 2, -4, 5, -6, 6, 0, 0, 0, 0}, {1, -1, 2, -2, 3, -3, 4, -4, 0, 0, 0}, {1, -1, 2, -2, 3, -3, 4, -5, 5, 0, 0}, {1, -1, 2, -2, 3, -3, 4, -5, 6, -6, 0}, {1, -1, 2, -2, 3, -4, 4, -5, 5, -6, 6}};
    protected int stackedRowWidth = 2;

    public RSSExpanded() {
        this.barType = 8;
        this.format = FORMAT_EXPANDED;
    }

    public RSSExpanded(int n) {
        this.barType = 8;
        this.format = n;
    }

    @Override
    public void setCode(String string) {
        this.humanReadableCode = string;
        this.code = string.replace("(", "").replace(")", "");
    }

    public void setStackedRowWidth(int n) {
        this.stackedRowWidth = n;
    }

    public int getStackedRowWidth() {
        return this.stackedRowWidth;
    }

    protected int RSS14Enc(String string, int[][] nArray, boolean bl) {
        int n = 0;
        byte[] byArray = new byte[36];
        RSSUtil rSSUtil = new RSSUtil();
        int n2 = 1;
        rSSUtil.rowWidth = 22;
        if (this.format == RSS.FORMAT_EXPANDED_STACKED) {
            rSSUtil.rowWidth = this.stackedRowWidth * 2;
        }
        int n3 = 0;
        int n4 = rSSUtil.check2DData(string);
        if (n4 != 0 || (n4 = this.isSymbolSeparator(string)) != 0) {
            return 0;
        }
        int n5 = 0;
        if (bl) {
            n5 = 1;
        }
        rSSUtil.putBits(byArray, 0, 1, n5, n2);
        int n6 = rSSUtil.pack(string, byArray, n2);
        if (n6 < 0) {
            return 0;
        }
        if ((byArray[0] & 0x40) == 64) {
            byArray[0] = (byte)(byArray[0] | ((n6 + 1 & 1) << 5) + (n6 > 13 ? 16 : 0));
        }
        if ((byArray[0] & 0x60) == 0) {
            byArray[0] = (byte)(byArray[0] | ((n6 + 1 & 1) << 4) + (n6 > 13 ? 8 : 0));
        }
        if ((byArray[0] & 0x71) == 48) {
            byArray[0] = (byte)(byArray[0] | ((n6 + 1 & 1) << 1) + (n6 > 13 ? 1 : 0));
        }
        int n7 = (n6 - 2) / 2;
        for (n4 = 0; n4 < (n6 + 2) / 2; ++n4) {
            int n8;
            int n9;
            int n10 = finderSets[n7][n4];
            int n11 = n9 = n10 >= 0 ? n10 * 2 : -n10 * 2 + 1;
            if (n4 > 0) {
                n = parWeights[2 * (n9 - 2)];
                n8 = this.getVal12(byArray, n4 * 2 - 1);
                n3 = this.createPattern(nArray[n4], 0, n8, n3, n, true);
            }
            if (n10 < 0) {
                nArray[n4][12] = finders[-n10 - 1][0];
                nArray[n4][11] = finders[-n10 - 1][1];
                nArray[n4][10] = finders[-n10 - 1][2];
                nArray[n4][9] = 1;
                nArray[n4][8] = 1;
            } else {
                nArray[n4][8] = finders[n10 - 1][0];
                nArray[n4][9] = finders[n10 - 1][1];
                nArray[n4][10] = finders[n10 - 1][2];
                nArray[n4][11] = 1;
                nArray[n4][12] = 1;
            }
            if (n6 <= n4 * 2) continue;
            n = parWeights[2 * (n9 - 2) + 1];
            n8 = this.getVal12(byArray, n4 * 2);
            n3 = this.createPattern(nArray[n4], 13, n8, n3, n, false);
        }
        this.createPattern(nArray[0], 0, (n6 - 3) * 211 + n3, 0, n, true);
        return n6 + 1;
    }

    protected int byteToInt(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    protected Dimension paintStackedBarcode(Graphics graphics, int[] nArray, int n) throws Exception {
        int n2;
        if (this.stackedRowWidth < 1) {
            this.stackedRowWidth = 1;
        }
        if (this.stackedRowWidth > 10) {
            this.stackedRowWidth = 10;
        }
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.stackedRowWidth * 49 + 2 + 2;
        int[][] nArray2 = RSSExpanded.createBarMap(n8, 100, EMPTY);
        int[][] nArray3 = RSSExpanded.createBarMap(n8, 100, EMPTY);
        int[] nArray4 = new int[100];
        boolean[] blArray = new boolean[100];
        while (n6 < n) {
            nArray4[n5 + 1] = this.X;
            nArray4[n5 + 2] = this.X;
            nArray4[n5 + 3] = this.X;
            blArray[n5 + 1] = false;
            blArray[n5 + 2] = false;
            blArray[n5 + 3] = false;
            if (n6 > 0) {
                n5 += 4;
            }
            n2 = 0;
            blArray[n5] = false;
            if ((this.stackedRowWidth & 1) == 0 && !this.isOdd(++n7)) {
                blArray[n5] = true;
            }
            n4 = 0;
            bl = true;
            if (blArray[n5] && n6 + this.stackedRowWidth > n && this.isOdd(n - (n6 + this.stackedRowWidth))) {
                blArray[n5] = false;
                n4 += BarCode.addBarMap(nArray2, this.getReversedX(n4, n2 != 0, nArray2[0].length), n5, 1, !bl, n2 != 0, BLACK);
            }
            if ((this.stackedRowWidth & 1) == 1) {
                bl = this.isOdd(n7);
            }
            boolean bl2 = !bl;
            bl = !bl;
            n4 += BarCode.addBarMap(nArray2, this.getReversedX(n4 += BarCode.addBarMap(nArray2, this.getReversedX(n4, n2 != 0, nArray2[0].length), n5, 1, bl2, n2 != 0, BLACK), n2 != 0, nArray2[0].length), n5, 1, !bl, n2 != 0, BLACK);
            bl = !bl;
            for (int i = 0; i < this.stackedRowWidth && n6 < n; ++n6, ++i) {
                int n9 = n3;
                for (int j = 0; j < 21; ++j) {
                    if (j >= 8 && j < 11 && nArray[n9 + 8] + nArray[n9 + 9] + nArray[n9 + 10] == 13) {
                        BarCode.addBarMap(nArray3, this.getReversedX(n4, n2 != 0, nArray2[0].length), n5, nArray[n3], !bl, n2 != 0, BLACK);
                    }
                    if (j >= 10 && j < 13 && nArray[n9 + 10] + nArray[n9 + 11] + nArray[n9 + 12] == 13) {
                        BarCode.addBarMap(nArray3, this.getReversedX(n4, n2 != 0, nArray2[0].length), n5, nArray[n3], !bl, n2 != 0, BLACK);
                    }
                    n4 += BarCode.addBarMap(nArray2, this.getReversedX(n4, n2 != 0, nArray2[0].length), n5, nArray[n3], !bl, n2 != 0, BLACK);
                    bl = !bl;
                    ++n3;
                }
            }
            boolean bl3 = !bl;
            bl = !bl;
            n4 += BarCode.addBarMap(nArray2, this.getReversedX(n4 += BarCode.addBarMap(nArray2, this.getReversedX(n4, n2 != 0, nArray2[0].length), n5, 1, bl3, n2 != 0, BLACK), n2 != 0, nArray2[0].length), n5, 1, !bl, n2 != 0, BLACK);
            boolean bl4 = bl = !bl;
            if (n5 >= 4) {
                this.paintSeparator(nArray2, nArray3, n5 - 4);
            }
            nArray4[n5] = this.barHeight;
        }
        for (n2 = 0; n2 <= n5; n2 += 4) {
            if (!blArray[n2]) continue;
            this.reverseArray(nArray2[n2]);
            this.reverseArray(nArray2[n2 - 1]);
            this.reverseArray(nArray2[n2 + 1]);
            this.reverseArray(nArray3[n2]);
        }
        int[] nArray5 = new int[nArray2[0].length];
        this.paintRSSExpanded2DSeparator(nArray2[0], nArray3[0], nArray5);
        Dimension dimension = this.renderRSS(graphics, nArray2, nArray5, true, true, 4, n5 + 1);
        return dimension;
    }

    protected void reverseArray(int[] nArray) {
        int n;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1 && n2 == -1) {
                n2 = i;
            }
            if (nArray[i] != -1) {
                n3 = i;
            }
            if (nArray[i] != -1 || n3 == -1) continue;
            n3 = i - 1;
            break;
        }
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray[n];
        }
        if (n2 > -1 && n3 > -1) {
            for (n = n2; n <= n3; ++n) {
                nArray[n] = nArray2[n3 - (n - n2)];
            }
        }
    }

    protected Dimension paintNonStackedBarcode(Graphics graphics, int[] nArray, int n) throws Exception {
        int[][] nArray2 = RSSExpanded.createBarMap(n * 49 + 4, 1, EMPTY);
        int[][] nArray3 = RSSExpanded.createBarMap(nArray2[0].length, 1, EMPTY);
        int n2 = 0;
        this.currentX = 0;
        this.currentY = 0;
        n2 += BarCode.addBarMap(nArray2, n2, 0, 1, false);
        n2 += BarCode.addBarMap(nArray2, n2, 0, 1, true);
        boolean bl = true;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = n3;
            for (int j = 0; j < 21; ++j) {
                if (j >= 8 && j < 11 && nArray[n4 + 8] + nArray[n4 + 9] + nArray[n4 + 10] == 13) {
                    BarCode.addBarMap(nArray3, n2, 0, nArray[n3], !bl);
                }
                if (j >= 10 && j < 13 && nArray[n4 + 10] + nArray[n4 + 11] + nArray[n4 + 12] == 13) {
                    BarCode.addBarMap(nArray3, n2, 0, nArray[n3], !bl);
                }
                n2 += BarCode.addBarMap(nArray2, n2, 0, nArray[n3], !bl);
                ++n3;
                bl = !bl;
            }
        }
        if (nArray2[0][n2 - 1] != BLACK) {
            n2 += BarCode.addBarMap(nArray2, n2, 0, 1, true);
            n2 += BarCode.addBarMap(nArray2, n2, 0, 1, false);
        } else {
            n2 += BarCode.addBarMap(nArray2, n2, 0, 1, false);
            n2 += BarCode.addBarMap(nArray2, n2, 0, 1, true);
        }
        int[] nArray4 = new int[nArray2[0].length];
        this.paintRSSExpanded2DSeparator(nArray2[0], nArray3[0], nArray4);
        Dimension dimension = this.renderRSS(graphics, nArray2, nArray4, true, true, 4, 1);
        return dimension;
    }

    @Override
    protected Dimension paintBarcode(Graphics graphics) throws Exception {
        int n;
        int n2;
        super.paintBarcode(graphics);
        if (this.barType != 8) {
            m_Log.error((Object)"Expected RSS Expanded");
            return new Dimension(0, 0);
        }
        if (this.format != RSS.FORMAT_EXPANDED && this.format != RSS.FORMAT_EXPANDED_STACKED) {
            this.format = RSS.FORMAT_EXPANDED;
        }
        int n3 = 0;
        this.linkFlag = this.secondaryCode.length() > 0;
        this.currentX = 0;
        this.currentY = 0;
        if (this.barHeight < this.X * 34) {
            this.barHeight = this.X * 34;
        }
        int[][] nArray = new int[12][21];
        int[] nArray2 = new int[256];
        int n4 = this.RSS14Enc(this.code, nArray, this.linkFlag);
        int n5 = 0;
        n3 = 0;
        for (n2 = 0; n2 < n4 - 1; n2 += 2) {
            ++n3;
            for (n = 0; n < 21; ++n) {
                nArray2[n5++] = nArray[n2 / 2][n];
            }
        }
        if (n2 == n4 - 1) {
            ++n3;
            for (n = 0; n < 13; ++n) {
                nArray2[n5++] = nArray[n2 / 2][n];
            }
        }
        if (this.format != RSS.FORMAT_EXPANDED_STACKED) {
            return this.paintNonStackedBarcode(graphics, nArray2, n3);
        }
        return this.paintStackedBarcode(graphics, nArray2, n3);
    }

    protected boolean isOdd(int n) {
        return (n & 1) != 0;
    }

    private int createPattern(int[] nArray, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int[][] nArrayArray = new int[][]{{12, 7, 5, 2, 4, 0, 347}, {10, 5, 7, 4, 20, 348, 1387}, {8, 4, 9, 5, 52, 1388, 2947}, {6, 3, 11, 6, 104, 2948, 3987}, {4, 1, 13, 8, 204, 3988, 4191}};
        long l = 0L;
        long l2 = 0L;
        int n7 = n4;
        int n8 = n4 * 3 % 211;
        for (n6 = 0; n2 > nArrayArray[n6][6] && n6 < 4; ++n6) {
        }
        l = (long)Math.floor((n2 - nArrayArray[n6][5]) / nArrayArray[n6][4]);
        l2 = (long)Math.floor((n2 - nArrayArray[n6][5]) % nArrayArray[n6][4]);
        int n9 = nArrayArray[n6][0];
        int n10 = nArrayArray[n6][1];
        int[] nArray2 = this.getRSSwidths((int)l, n9, 4, n10, 0);
        for (n5 = 0; n5 < 4; ++n5) {
            if (bl) {
                nArray[n5 * 2 + n] = nArray2[n5];
            } else {
                nArray[7 - n5 * 2 + n] = nArray2[n5];
            }
            n3 += n7 * nArray2[n5];
            n3 %= 211;
            n7 = n7 * 9 % 211;
        }
        n9 = nArrayArray[n6][2];
        n10 = nArrayArray[n6][3];
        nArray2 = this.getRSSwidths((int)l2, n9, 4, n10, 1);
        for (n5 = 0; n5 < 4; ++n5) {
            if (bl) {
                nArray[1 + n5 * 2 + n] = nArray2[n5];
            } else {
                nArray[6 - n5 * 2 + n] = nArray2[n5];
            }
            n3 += n8 * nArray2[n5];
            n3 %= 211;
            n8 = n8 * 9 % 211;
        }
        return n3;
    }

    private int getVal12(byte[] byArray, int n) {
        int n2;
        int n3 = n * 3 / 2;
        if ((n & 1) != 0) {
            n2 = this.byteToInt(byArray[n3]) & 0xF;
            n2 = (n2 << 8) + this.byteToInt(byArray[n3 + 1]);
        } else {
            n2 = this.byteToInt(byArray[n3]);
            n2 = (n2 << 4) + (this.byteToInt(byArray[n3 + 1]) >> 4);
        }
        return n2;
    }

    private int isSymbolSeparator(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '^') continue;
            return i;
        }
        return 0;
    }

    private int getReversedX(int n, boolean bl, int n2) {
        if (bl) {
            return n2 - (n + 1);
        }
        return n;
    }

    private void paintSeparator(int[][] nArray, int[][] nArray2, int n) {
        int n2;
        boolean bl = false;
        int n3 = n + 1;
        int n4 = nArray[0].length;
        for (n2 = 4; n2 < n4 - 4 && nArray[n][n2 + 4] != EMPTY; ++n2) {
            if (nArray2[n][n2] != EMPTY) {
                if (nArray2[n][n2] == BLACK) {
                    RSSExpanded.addBarMap(nArray, n2, n3, 1, false);
                    continue;
                }
                RSSExpanded.addBarMap(nArray, n2, n3, 1, nArray[n3][n2 - 1] == 0);
                continue;
            }
            if (nArray[n][n2] == WHITE) {
                RSSExpanded.addBarMap(nArray, n2, n3, 1, true);
                continue;
            }
            RSSExpanded.addBarMap(nArray, n2, n3, 1, false);
        }
        n3 = n + 2;
        bl = false;
        for (n2 = 4; n2 < n4 - 4; ++n2) {
            RSSExpanded.addBarMap(nArray, n2, n3, 1, bl);
            bl = !bl;
        }
        n3 = n + 3;
        for (n2 = 4; n2 < n4 - 4 && nArray[n + 4][n2 + 4] != EMPTY; ++n2) {
            if (nArray2[n + 4][n2] != EMPTY) {
                if (nArray2[n + 4][n2] == BLACK) {
                    RSSExpanded.addBarMap(nArray, n2, n3, 1, false);
                    continue;
                }
                RSSExpanded.addBarMap(nArray, n2, n3, 1, nArray[n3][n2 - 1] == 0);
                continue;
            }
            if (nArray[n + 4][n2] == WHITE) {
                RSSExpanded.addBarMap(nArray, n2, n3, 1, true);
                continue;
            }
            RSSExpanded.addBarMap(nArray, n2, n3, 1, false);
        }
    }

    private void paintRSSExpanded2DSeparator(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        for (int i = 4; i < n - 4 && nArray[i + 4] != EMPTY; ++i) {
            if (nArray2[i] != EMPTY) {
                if (nArray2[i] == BLACK) {
                    nArray3[i] = WHITE;
                    continue;
                }
                nArray3[i] = nArray3[i - 1] == BLACK ? WHITE : BLACK;
                continue;
            }
            nArray3[i] = nArray[i] == WHITE ? BLACK : WHITE;
        }
    }
}

