/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DBFField {
    public static final byte FIELD_TYPE_C = 67;
    public static final byte FIELD_TYPE_L = 76;
    public static final byte FIELD_TYPE_N = 78;
    public static final byte FIELD_TYPE_F = 70;
    public static final byte FIELD_TYPE_D = 68;
    public static final byte FIELD_TYPE_M = 77;
    byte[] fieldName = new byte[11];
    byte dataType;
    int reserv1;
    int fieldLength;
    byte decimalCount;
    short reserv2;
    byte workAreaId;
    short reserv3;
    byte setFieldsFlag;
    byte[] reserv4 = new byte[7];
    byte indexFieldFlag;
    int nameNullIndex = 0;

    protected static DBFField createField(DataInput dataInput) throws IOException {
        DBFField dBFField = new DBFField();
        byte by = dataInput.readByte();
        if (by == 13) {
            return null;
        }
        dataInput.readFully(dBFField.fieldName, 1, 10);
        dBFField.fieldName[0] = by;
        for (int i = 0; i < dBFField.fieldName.length; ++i) {
            if (dBFField.fieldName[i] != 0) continue;
            dBFField.nameNullIndex = i;
            break;
        }
        dBFField.dataType = dataInput.readByte();
        dBFField.reserv1 = Utils.readLittleEndianInt(dataInput);
        dBFField.fieldLength = dataInput.readUnsignedByte();
        dBFField.decimalCount = dataInput.readByte();
        dBFField.reserv2 = Utils.readLittleEndianShort(dataInput);
        dBFField.workAreaId = dataInput.readByte();
        dBFField.reserv2 = Utils.readLittleEndianShort(dataInput);
        dBFField.setFieldsFlag = dataInput.readByte();
        dataInput.readFully(dBFField.reserv4);
        dBFField.indexFieldFlag = dataInput.readByte();
        return dBFField;
    }

    protected void write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.fieldName);
        dataOutput.write(new byte[11 - this.fieldName.length]);
        dataOutput.writeByte(this.dataType);
        dataOutput.writeInt(0);
        dataOutput.writeByte(this.fieldLength);
        dataOutput.writeByte(this.decimalCount);
        dataOutput.writeShort(0);
        dataOutput.writeByte(0);
        dataOutput.writeShort(0);
        dataOutput.writeByte(0);
        dataOutput.write(new byte[7]);
        dataOutput.writeByte(0);
    }

    public String getName() {
        return new String(this.fieldName, 0, this.nameNullIndex);
    }

    public byte getDataType() {
        return this.dataType;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    @Deprecated
    public void setFieldName(String string) {
        this.setName(string);
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (string.length() == 0 || string.length() > 10) {
            throw new IllegalArgumentException("Field name should be of length 0-10");
        }
        this.fieldName = string.getBytes();
        this.nameNullIndex = this.fieldName.length;
    }

    public void setDataType(byte by) {
        switch (by) {
            case 68: {
                this.fieldLength = 8;
            }
            case 67: 
            case 70: 
            case 76: 
            case 77: 
            case 78: {
                this.dataType = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data type");
            }
        }
    }

    public void setFieldLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Field length should be a positive number");
        }
        if (this.dataType == 68) {
            throw new UnsupportedOperationException("Cannot do this on a Date field");
        }
        this.fieldLength = n;
    }

    public void setDecimalCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal length should be a positive number");
        }
        if (n > this.fieldLength) {
            throw new IllegalArgumentException("Decimal length should be less than field length");
        }
        this.decimalCount = (byte)n;
    }
}

