/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFBase;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFHeader;
import com.linuxense.javadbf.Utils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;

public class DBFReader
extends DBFBase {
    DataInputStream dataInputStream;
    DBFHeader header;
    boolean isClosed = true;

    public DBFReader(InputStream inputStream) throws DBFException {
        try {
            this.dataInputStream = new DataInputStream(inputStream);
            this.isClosed = false;
            this.header = new DBFHeader();
            this.header.read(this.dataInputStream);
            int n = this.header.headerLength - (32 + 32 * this.header.fieldArray.length) - 1;
            if (n > 0) {
                this.dataInputStream.skip(n);
            }
        }
        catch (IOException iOException) {
            throw new DBFException(iOException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.header.year + "/" + this.header.month + "/" + this.header.day + "\nTotal records: " + this.header.numberOfRecords + "\nHEader length: " + this.header.headerLength);
        for (int i = 0; i < this.header.fieldArray.length; ++i) {
            stringBuffer.append(this.header.fieldArray[i].getName());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getRecordCount() {
        return this.header.numberOfRecords;
    }

    public DBFField getField(int n) throws DBFException {
        if (this.isClosed) {
            throw new DBFException("Source is not open");
        }
        return this.header.fieldArray[n];
    }

    public int getFieldCount() throws DBFException {
        if (this.isClosed) {
            throw new DBFException("Source is not open");
        }
        if (this.header.fieldArray != null) {
            return this.header.fieldArray.length;
        }
        return -1;
    }

    public Object[] nextRecord() throws DBFException {
        if (this.isClosed) {
            throw new DBFException("Source is not open");
        }
        Object[] objectArray = new Object[this.header.fieldArray.length];
        try {
            int n;
            boolean bl = false;
            do {
                if (bl) {
                    this.dataInputStream.skip(this.header.recordLength - 1);
                }
                if ((n = this.dataInputStream.readByte()) != 26) continue;
                return null;
            } while (bl = n == 42);
            block18: for (n = 0; n < this.header.fieldArray.length; ++n) {
                switch (this.header.fieldArray[n].getDataType()) {
                    case 67: {
                        byte[] byArray = new byte[this.header.fieldArray[n].getFieldLength()];
                        this.dataInputStream.read(byArray);
                        objectArray[n] = new String(byArray, this.characterSetName);
                        continue block18;
                    }
                    case 68: {
                        byte[] byArray = new byte[4];
                        this.dataInputStream.read(byArray);
                        byte[] byArray2 = new byte[2];
                        this.dataInputStream.read(byArray2);
                        byte[] byArray3 = new byte[2];
                        this.dataInputStream.read(byArray3);
                        try {
                            GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(new String(byArray)), Integer.parseInt(new String(byArray2)) - 1, Integer.parseInt(new String(byArray3)));
                            objectArray[n] = gregorianCalendar.getTime();
                        }
                        catch (NumberFormatException numberFormatException) {
                            objectArray[n] = null;
                        }
                        continue block18;
                    }
                    case 70: {
                        try {
                            byte[] byArray = new byte[this.header.fieldArray[n].getFieldLength()];
                            this.dataInputStream.read(byArray);
                            byArray = Utils.trimLeftSpaces(byArray);
                            if (byArray.length > 0 && !Utils.contains(byArray, (byte)63)) {
                                objectArray[n] = new Float(new String(byArray));
                                continue block18;
                            }
                            objectArray[n] = null;
                            continue block18;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new DBFException("Failed to parse Float: " + numberFormatException.getMessage());
                        }
                    }
                    case 78: {
                        try {
                            byte[] byArray = new byte[this.header.fieldArray[n].getFieldLength()];
                            this.dataInputStream.read(byArray);
                            byArray = Utils.trimLeftSpaces(byArray);
                            if (byArray.length > 0 && !Utils.contains(byArray, (byte)63)) {
                                objectArray[n] = new Double(new String(byArray));
                                continue block18;
                            }
                            objectArray[n] = null;
                            continue block18;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new DBFException("Failed to parse Number: " + numberFormatException.getMessage());
                        }
                    }
                    case 76: {
                        byte by = this.dataInputStream.readByte();
                        if (by == 89 || by == 116 || by == 84 || by == 116) {
                            objectArray[n] = Boolean.TRUE;
                            continue block18;
                        }
                        objectArray[n] = Boolean.FALSE;
                        continue block18;
                    }
                    case 77: {
                        objectArray[n] = "null";
                        continue block18;
                    }
                    default: {
                        objectArray[n] = "null";
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (IOException iOException) {
            throw new DBFException(iOException.getMessage());
        }
        return objectArray;
    }
}

