/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.fonts.cmaps;

import com.lowagie.text.pdf.fonts.cmaps.CMap;
import com.lowagie.text.pdf.fonts.cmaps.CodespaceRange;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CMapParser {
    private static final String BEGIN_CODESPACE_RANGE = "begincodespacerange";
    private static final String BEGIN_BASE_FONT_CHAR = "beginbfchar";
    private static final String BEGIN_BASE_FONT_RANGE = "beginbfrange";
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private byte[] tokenParserByteBuffer = new byte[512];

    public CMap parse(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        CMap cMap = new CMap();
        Object object = null;
        Object object2 = null;
        while ((object2 = this.parseNextToken(pushbackInputStream)) != null) {
            if (object2 instanceof Operator) {
                Operator operator = (Operator)object2;
                if (operator.op.equals(BEGIN_CODESPACE_RANGE)) {
                    var7_7 = (Number)object;
                    for (var8_8 = 0; var8_8 < var7_7.intValue(); ++var8_8) {
                        var9_9 = (byte[])this.parseNextToken(pushbackInputStream);
                        var10_10 = (byte[])this.parseNextToken(pushbackInputStream);
                        var11_11 = new CodespaceRange();
                        ((CodespaceRange)var11_11).setStart(var9_9);
                        ((CodespaceRange)var11_11).setEnd((byte[])var10_10);
                        cMap.addCodespaceRange((CodespaceRange)var11_11);
                    }
                } else if (operator.op.equals(BEGIN_BASE_FONT_CHAR)) {
                    var7_7 = (Number)object;
                    for (var8_8 = 0; var8_8 < var7_7.intValue(); ++var8_8) {
                        var9_9 = (byte[])this.parseNextToken(pushbackInputStream);
                        var10_10 = this.parseNextToken(pushbackInputStream);
                        if (var10_10 instanceof byte[]) {
                            var11_11 = var10_10;
                            var12_12 = this.createStringFromBytes((byte[])var11_11);
                            cMap.addMapping(var9_9, (String)var12_12);
                            continue;
                        }
                        if (var10_10 instanceof LiteralName) {
                            cMap.addMapping(var9_9, ((LiteralName)var10_10).name);
                            continue;
                        }
                        throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + String.valueOf(var10_10));
                    }
                } else if (operator.op.equals(BEGIN_BASE_FONT_RANGE)) {
                    var7_7 = (Number)object;
                    for (var8_8 = 0; var8_8 < var7_7.intValue(); ++var8_8) {
                        var9_9 = (byte[])this.parseNextToken(pushbackInputStream);
                        var10_10 = (byte[])this.parseNextToken(pushbackInputStream);
                        var11_11 = this.parseNextToken(pushbackInputStream);
                        var12_12 = null;
                        byte[] byArray = null;
                        if (var11_11 instanceof List) {
                            var12_12 = (List)var11_11;
                            byArray = (byte[])var12_12.get(0);
                        } else {
                            byArray = (byte[])var11_11;
                        }
                        String string = null;
                        int n = 0;
                        boolean bl = false;
                        while (!bl) {
                            if (this.compare(var9_9, (byte[])var10_10) >= 0) {
                                bl = true;
                            }
                            string = this.createStringFromBytes(byArray);
                            cMap.addMapping(var9_9, string);
                            this.increment(var9_9);
                            if (var12_12 == null) {
                                this.increment(byArray);
                                continue;
                            }
                            if (++n >= var12_12.size()) continue;
                            byArray = (byte[])var12_12.get(n);
                        }
                    }
                }
            }
            object = object2;
        }
        return cMap;
    }

    private Object parseNextToken(PushbackInputStream pushbackInputStream) throws IOException {
        Object object = null;
        int n = pushbackInputStream.read();
        while (n == 9 || n == 32 || n == 13 || n == 10) {
            n = pushbackInputStream.read();
        }
        switch (n) {
            case 37: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n);
                this.readUntilEndOfLine(pushbackInputStream, stringBuffer);
                object = stringBuffer.toString();
                break;
            }
            case 40: {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = pushbackInputStream.read();
                while (n2 != -1 && n2 != 41) {
                    stringBuffer.append((char)n2);
                    n2 = pushbackInputStream.read();
                }
                object = stringBuffer.toString();
                break;
            }
            case 62: {
                int n3 = pushbackInputStream.read();
                if (n3 == 62) {
                    object = MARK_END_OF_DICTIONARY;
                    break;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                object = MARK_END_OF_ARRAY;
                break;
            }
            case 91: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Object object2 = this.parseNextToken(pushbackInputStream);
                while (object2 != MARK_END_OF_ARRAY) {
                    arrayList.add(object2);
                    object2 = this.parseNextToken(pushbackInputStream);
                }
                object = arrayList;
                break;
            }
            case 60: {
                int n4 = pushbackInputStream.read();
                if (n4 == 60) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    Object object3 = this.parseNextToken(pushbackInputStream);
                    while (object3 instanceof LiteralName && object3 != MARK_END_OF_DICTIONARY) {
                        Object object4 = this.parseNextToken(pushbackInputStream);
                        hashMap.put(((LiteralName)object3).name, object4);
                        object3 = this.parseNextToken(pushbackInputStream);
                    }
                    object = hashMap;
                    break;
                }
                int n5 = 16;
                int n6 = -1;
                while (n4 != -1 && n4 != 62) {
                    int n7 = 0;
                    if (n4 >= 48 && n4 <= 57) {
                        n7 = n4 - 48;
                    } else if (n4 >= 65 && n4 <= 70) {
                        n7 = 10 + n4 - 65;
                    } else if (n4 >= 97 && n4 <= 102) {
                        n7 = 10 + n4 - 97;
                    } else {
                        throw new IOException("Error: expected hex character and not " + (char)n4 + ":" + n4);
                    }
                    n7 *= n5;
                    if (n5 == 16) {
                        this.tokenParserByteBuffer[++n6] = 0;
                        n5 = 1;
                    } else {
                        n5 = 16;
                    }
                    int n8 = n6;
                    this.tokenParserByteBuffer[n8] = (byte)(this.tokenParserByteBuffer[n8] + n7);
                    n4 = pushbackInputStream.read();
                }
                byte[] byArray = new byte[n6 + 1];
                System.arraycopy(this.tokenParserByteBuffer, 0, byArray, 0, n6 + 1);
                object = byArray;
                break;
            }
            case 47: {
                StringBuffer stringBuffer = new StringBuffer();
                int n9 = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n9)) {
                    stringBuffer.append((char)n9);
                    n9 = pushbackInputStream.read();
                }
                object = new LiteralName(stringBuffer.toString());
                break;
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n);
                n = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n) && (Character.isDigit((char)n) || n == 46)) {
                    stringBuffer.append((char)n);
                    n = pushbackInputStream.read();
                }
                pushbackInputStream.unread(n);
                String string = stringBuffer.toString();
                if (string.indexOf(46) >= 0) {
                    object = new Double(string);
                    break;
                }
                object = new Integer(stringBuffer.toString());
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n);
                n = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n)) {
                    stringBuffer.append((char)n);
                    n = pushbackInputStream.read();
                }
                object = new Operator(stringBuffer.toString());
                break;
            }
        }
        return object;
    }

    private void readUntilEndOfLine(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        int n = inputStream.read();
        while (n != -1 && n != 13 && n != 10) {
            stringBuffer.append((char)n);
            n = inputStream.read();
        }
    }

    private boolean isWhitespaceOrEOF(int n) {
        return n == -1 || n == 32 || n == 13 || n == 10;
    }

    private void increment(byte[] byArray) {
        this.increment(byArray, byArray.length - 1);
    }

    private void increment(byte[] byArray, int n) {
        if (n > 0 && (byArray[n] + 256) % 256 == 255) {
            byArray[n] = 0;
            this.increment(byArray, n - 1);
        } else {
            byArray[n] = (byte)(byArray[n] + 1);
        }
    }

    private String createStringFromBytes(byte[] byArray) throws IOException {
        String string = null;
        string = byArray.length == 1 ? new String(byArray) : new String(byArray, "UTF-16BE");
        return string;
    }

    private int compare(byte[] byArray, byte[] byArray2) {
        int n = 1;
        boolean bl = false;
        for (int i = 0; i < byArray.length && !bl; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            if ((byArray[i] + 256) % 256 < (byArray2[i] + 256) % 256) {
                bl = true;
                n = -1;
                continue;
            }
            bl = true;
            n = 1;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("usage: java org.pdfbox.cmapparser.CMapParser <CMAP File>");
            System.exit(-1);
        }
        CMapParser cMapParser = new CMapParser();
        CMap cMap = cMapParser.parse(new FileInputStream(stringArray[0]));
        System.out.println("Result:" + String.valueOf(cMap));
    }

    private class Operator {
        private String op;

        private Operator(String string) {
            this.op = string;
        }
    }

    private class LiteralName {
        private String name;

        private LiteralName(String string) {
            this.name = string;
        }
    }
}

