/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

import org.osgeo.proj4j.datum.Datum;
import org.osgeo.proj4j.proj.LongLatProjection;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.units.Units;

public class CoordinateReferenceSystem {
    public static final CoordinateReferenceSystem CS_GEO = new CoordinateReferenceSystem("CS_GEO", null, null, null);
    private String name;
    private String[] params;
    private Datum datum;
    private Projection proj;

    public CoordinateReferenceSystem(String string, String[] stringArray, Datum datum, Projection projection) {
        this.name = string;
        this.params = stringArray;
        this.datum = datum;
        this.proj = projection;
        if (string == null) {
            String string2 = "null-proj";
            if (projection != null) {
                string2 = projection.getName();
            }
            this.name = string2 + "-CS";
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.params;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public String getParameterString() {
        if (this.params == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.params.length; ++i) {
            stringBuffer.append(this.params[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public CoordinateReferenceSystem createGeographic() {
        Datum datum = this.getDatum();
        LongLatProjection longLatProjection = new LongLatProjection();
        longLatProjection.setEllipsoid(this.getProjection().getEllipsoid());
        longLatProjection.setUnits(Units.DEGREES);
        ((Projection)longLatProjection).initialize();
        return new CoordinateReferenceSystem("GEO-" + datum.getCode(), null, datum, longLatProjection);
    }

    public String toString() {
        return this.name;
    }
}

