/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.units;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.osgeo.proj4j.util.ProjectionMath;

public class AngleFormat
extends NumberFormat {
    public static final char CH_MIN_SYMBOL = '\'';
    public static final String STR_SEC_SYMBOL = "\"";
    public static final char CH_DEG_SYMBOL = '\u00b0';
    public static final char CH_DEG_ABBREV = 'd';
    public static final char CH_MIN_ABBREV = 'm';
    public static final String STR_SEC_ABBREV = "s";
    public static final char CH_N = 'N';
    public static final char CH_E = 'E';
    public static final char CH_S = 'S';
    public static final char CH_W = 'W';
    public static final String ddmmssPattern = "DdM";
    public static final String ddmmssPattern2 = "DdM'S\"";
    public static final String ddmmssLongPattern = "DdM'S\"W";
    public static final String ddmmssLatPattern = "DdM'S\"N";
    public static final String ddmmssPattern4 = "DdMmSs";
    public static final String decimalPattern = "D.F";
    private DecimalFormat format;
    private String pattern;
    private boolean isDegrees;

    public AngleFormat() {
        this(ddmmssPattern);
    }

    public AngleFormat(String string) {
        this(string, false);
    }

    public AngleFormat(String string, boolean bl) {
        this.pattern = string;
        this.isDegrees = bl;
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(0);
        this.format.setGroupingUsed(false);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        double d2;
        int n;
        int n2 = this.pattern.length();
        boolean bl = false;
        if (d < 0.0) {
            for (int i = n2 - 1; i >= 0; --i) {
                char c = this.pattern.charAt(i);
                if (c != 'W' && c != 'N') continue;
                d = -d;
                bl = true;
                break;
            }
        }
        if ((n = (int)Math.round((d2 = this.isDegrees ? d : Math.toDegrees(d)) * 3600.0)) < 0) {
            n = -n;
        }
        int n3 = n % 3600;
        block10: for (int i = 0; i < n2; ++i) {
            char c = this.pattern.charAt(i);
            switch (c) {
                case 'R': {
                    stringBuffer.append(d);
                    continue block10;
                }
                case 'D': {
                    stringBuffer.append((int)d2);
                    continue block10;
                }
                case 'M': {
                    int n4 = n3 / 60;
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    continue block10;
                }
                case 'S': {
                    int n4 = n3 % 60;
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    continue block10;
                }
                case 'F': {
                    stringBuffer.append(n3);
                    continue block10;
                }
                case 'W': {
                    if (bl) {
                        stringBuffer.append('W');
                        continue block10;
                    }
                    stringBuffer.append('E');
                    continue block10;
                }
                case 'N': {
                    if (bl) {
                        stringBuffer.append('S');
                        continue block10;
                    }
                    stringBuffer.append('N');
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer;
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        double d;
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        int n2 = string.length();
        if (n2 > 0) {
            n = Character.toUpperCase(string.charAt(n2 - 1));
            switch (n) {
                case 83: 
                case 87: {
                    bl = true;
                }
                case 69: 
                case 78: {
                    string = string.substring(0, n2 - 1);
                }
            }
        }
        if ((n = string.indexOf(100)) == -1) {
            n = string.indexOf(176);
        }
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            d2 = Double.valueOf(string2);
            n = string3.indexOf(109);
            if (n == -1) {
                n = string3.indexOf(39);
            }
            if (n != -1) {
                String string4;
                if (n != 0) {
                    string4 = string3.substring(0, n);
                    d3 = Double.valueOf(string4);
                }
                if (string3.endsWith(STR_SEC_ABBREV) || string3.endsWith(STR_SEC_SYMBOL)) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (n != string3.length() - 1) {
                    string4 = string3.substring(n + 1);
                    d4 = Double.valueOf(string4);
                }
                if (d3 < 0.0 || d3 > 59.0) {
                    throw new NumberFormatException("Minutes must be between 0 and 59");
                }
                if (d4 < 0.0 || d4 >= 60.0) {
                    throw new NumberFormatException("Seconds must be between 0 and 59");
                }
            } else if (n != 0) {
                d3 = Double.valueOf(string3);
            }
            d = this.isDegrees ? ProjectionMath.dmsToDeg(d2, d3, d4) : ProjectionMath.dmsToRad(d2, d3, d4);
        } else {
            d = Double.parseDouble(string);
            if (!this.isDegrees) {
                d = Math.toRadians(d);
            }
        }
        if (parsePosition != null) {
            parsePosition.setIndex(string.length());
        }
        if (bl) {
            d = -d;
        }
        return d;
    }
}

