/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$Context$;
import monix.eval.Task$Error$;
import monix.eval.Task$Eval$;
import monix.eval.Task$FlatMap$;
import monix.eval.Task$Map$;
import monix.eval.Task$Now$;
import monix.eval.Task$Suspend$;
import monix.eval.Task$Trace$;
import monix.eval.internal.StackFrame;
import monix.eval.internal.StackTracedContext;
import monix.eval.internal.TaskConnection$;
import monix.eval.internal.TaskRunLoop$;
import monix.eval.internal.TracingPlatform;
import monix.eval.tracing.TaskEvent;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.execution.misc.Local;
import monix.execution.misc.Local$;
import scala.Function0;
import scala.Function1;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class TaskRunToFutureWithLocal$
implements Serializable {
    public static final TaskRunToFutureWithLocal$ MODULE$ = new TaskRunToFutureWithLocal$();

    private TaskRunToFutureWithLocal$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TaskRunToFutureWithLocal$.class);
    }

    public <A> CancelableFuture<A> startFuture(Task<A> source, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Function1 bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = TaskRunLoop$.MODULE$.frameStart(em);
        StackTracedContext tracingCtx = null;
        Local.Context prev = Local$.MODULE$.getContext();
        Local.Context isolated = prev.isolate();
        while (true) {
            if (frameIndex != 0) {
                Task<Object> task = current;
                if (task instanceof Task.FlatMap) {
                    Task.FlatMap flatMap = (Task.FlatMap)task;
                    Task.FlatMap flatMap2 = Task$FlatMap$.MODULE$.unapply(flatMap);
                    Task task2 = flatMap2._1();
                    Function1 function1 = flatMap2._2();
                    Object object = flatMap2._3();
                    Task fa = task2;
                    Function1 bindNext = function1;
                    Task.FlatMap bind = flatMap;
                    if (TracingPlatform.isStackTracing) {
                        Object trace = bind.trace();
                        if (tracingCtx == null) {
                            tracingCtx = new StackTracedContext();
                        }
                        if (trace != null) {
                            tracingCtx.pushEvent((TaskEvent)trace);
                        }
                    }
                    if (bFirst != null) {
                        if (bRest == null) {
                            bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                        }
                        bRest.push(bFirst);
                    }
                    bFirst = bindNext;
                    current = fa;
                } else if (task instanceof Task.Now) {
                    Object a;
                    Task.Now now = Task$Now$.MODULE$.unapply((Task.Now)task);
                    Object value = a = now._1();
                    unboxed = value;
                    hasUnboxed = true;
                } else if (task instanceof Task.Eval) {
                    Function0 function0;
                    Task.Eval eval = Task$Eval$.MODULE$.unapply((Task.Eval)task);
                    Function0 thunk = function0 = eval._1();
                    Local$.MODULE$.setContext(isolated);
                    try {
                        unboxed = thunk.apply();
                        hasUnboxed = true;
                        current = null;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable e = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(e)) {
                            current = Task$Error$.MODULE$.apply(e);
                        }
                        throw throwable;
                    }
                } else if (task instanceof Task.Map) {
                    Task.Map map = (Task.Map)task;
                    Task.Map map2 = Task$Map$.MODULE$.unapply(map);
                    Task task3 = map2._1();
                    Function1 function1 = map2._2();
                    Object object = map2._3();
                    Task fa = task3;
                    Task.Map bindNext = map;
                    if (TracingPlatform.isStackTracing) {
                        Object trace = bindNext.trace();
                        if (tracingCtx == null) {
                            tracingCtx = new StackTracedContext();
                        }
                        if (trace != null) {
                            tracingCtx.pushEvent((TaskEvent)trace);
                        }
                    }
                    if (bFirst != null) {
                        if (bRest == null) {
                            bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                        }
                        bRest.push((Object)bFirst);
                    }
                    bFirst = bindNext;
                    current = fa;
                } else if (task instanceof Task.Suspend) {
                    Function0 function0;
                    Task.Suspend suspend = Task$Suspend$.MODULE$.unapply((Task.Suspend)task);
                    Function0 thunk = function0 = suspend._1();
                    Local$.MODULE$.setContext(isolated);
                    try {
                        current = (Task.Error)thunk.apply();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            current = Task$Error$.MODULE$.apply(ex);
                        }
                        throw throwable;
                    }
                } else if (task instanceof Task.Error) {
                    StackFrame<Object, Task<Object>> stackFrame;
                    Throwable throwable;
                    Task.Error error = Task$Error$.MODULE$.unapply((Task.Error)task);
                    Throwable error2 = throwable = error._1();
                    if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions) {
                        if (tracingCtx == null) {
                            tracingCtx = new StackTracedContext();
                        }
                        TaskRunLoop$.MODULE$.augmentException(error2, tracingCtx);
                    }
                    if ((stackFrame = TaskRunLoop$.MODULE$.findErrorHandler(bFirst, bRest)) == null) {
                        return CancelableFuture$.MODULE$.failed(error2);
                    }
                    StackFrame<Object, Task<Object>> bind = stackFrame;
                    try {
                        current = bind.recover(error2);
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable5;
                        Throwable e = throwable5 = throwable4;
                        if (NonFatal$.MODULE$.apply(e)) {
                            current = Task$Error$.MODULE$.apply(e);
                        }
                        throw throwable4;
                    }
                    frameIndex = em.nextFrameIndex(frameIndex);
                    bFirst = null;
                } else if (task instanceof Task.Trace) {
                    Task.Trace trace = Task$Trace$.MODULE$.unapply((Task.Trace)task);
                    Task task4 = trace._1();
                    TaskEvent taskEvent = trace._2();
                    Task sourceTask = task4;
                    TaskEvent frame = taskEvent;
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    tracingCtx.pushEvent(frame);
                    current = sourceTask;
                } else {
                    Task<Object> async = task;
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    return this.goAsync4Future(async, scheduler, opts, bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false, prev, isolated, tracingCtx);
                }
                if (!hasUnboxed) continue;
                Function1<Object, Task<Object>> function1 = TaskRunLoop$.MODULE$.popNextBind(bFirst, bRest);
                if (function1 == null) {
                    Local$.MODULE$.setContext(prev);
                    return CancelableFuture$.MODULE$.successfulWithLocal(unboxed, isolated);
                }
                Function1<Object, Task<Object>> bind = function1;
                try {
                    current = (Task)bind.apply(unboxed);
                }
                catch (Throwable throwable) {
                    Throwable throwable6;
                    Throwable ex = throwable6 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        current = Task$Error$.MODULE$.apply(ex);
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                hasUnboxed = false;
                unboxed = null;
                bFirst = null;
                continue;
            }
            if (tracingCtx == null) {
                tracingCtx = new StackTracedContext();
            }
            return this.goAsync4Future(current, scheduler, opts, bFirst, bRest, frameIndex, true, prev, isolated, tracingCtx);
        }
        return null;
    }

    private <A> CancelableFuture<A> goAsync4Future(Task<Object> source, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork, Local.Context previousCtx, Local.Context isolatedCtx, StackTracedContext tracingCtx) {
        Local$.MODULE$.setContext(isolatedCtx);
        Promise p = Promise$.MODULE$.apply();
        Callback cb = Callback$.MODULE$.fromPromise(p);
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts, TaskConnection$.MODULE$.apply(), tracingCtx);
        if (!forceFork) {
            Task<Object> task = source;
            if (task instanceof Task.Async) {
                Task.Async async = (Task.Async)task;
                TaskRunLoop$.MODULE$.executeAsyncTask(async, context, (Callback<Throwable, Object>)cb, null, bFirst, bRest, 1);
            } else {
                TaskRunLoop$.MODULE$.startFull(source, context, cb, null, bFirst, bRest, nextFrame);
            }
        } else {
            TaskRunLoop$.MODULE$.restartAsync(source, context, cb, null, bFirst, bRest);
        }
        Local$.MODULE$.setContext(previousCtx);
        return CancelableFuture$.MODULE$.applyWithLocal(p.future(), context.connection().toCancelable(scheduler), isolatedCtx);
    }
}

