/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderDeflaterBufferPool;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.Adler32;

class PngEncoderDeflaterBuffer {
    final PngEncoderDeflaterBufferPool pool;
    final byte[] bytes;
    int length;

    PngEncoderDeflaterBuffer(PngEncoderDeflaterBufferPool pool, int maxLength) {
        this.pool = Objects.requireNonNull(pool, "pool");
        this.bytes = new byte[maxLength];
        this.length = 0;
    }

    void giveBack() {
        this.pool.giveBack(this);
    }

    long calculateAdler32() {
        Adler32 adler32 = new Adler32();
        adler32.update(this.bytes, 0, this.length);
        return adler32.getValue();
    }

    void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes, 0, this.length);
    }
}

