/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderDeflaterBuffer;
import com.pngencoder.PngEncoderDeflaterSegmentResult;
import com.pngencoder.PngEncoderDeflaterThreadLocalDeflater;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.Deflater;

class PngEncoderDeflaterSegmentTask
implements Supplier<PngEncoderDeflaterSegmentResult> {
    private final PngEncoderDeflaterBuffer originalSegment;
    private final PngEncoderDeflaterBuffer deflatedSegment;
    private final int compressionLevel;
    private final boolean lastSegment;

    public PngEncoderDeflaterSegmentTask(PngEncoderDeflaterBuffer originalSegment, PngEncoderDeflaterBuffer deflatedSegment, int compressionLevel, boolean lastSegment) {
        this.originalSegment = Objects.requireNonNull(originalSegment, "originalSegment");
        this.deflatedSegment = Objects.requireNonNull(deflatedSegment, "deflatedSegment");
        this.compressionLevel = compressionLevel;
        this.lastSegment = lastSegment;
    }

    @Override
    public PngEncoderDeflaterSegmentResult get() {
        long originalSegmentAdler32 = this.originalSegment.calculateAdler32();
        int originalSegmentLength = this.originalSegment.length;
        PngEncoderDeflaterSegmentTask.deflate(this.originalSegment, this.deflatedSegment, this.compressionLevel, this.lastSegment);
        return new PngEncoderDeflaterSegmentResult(this.originalSegment, this.deflatedSegment, originalSegmentAdler32, originalSegmentLength);
    }

    static void deflate(PngEncoderDeflaterBuffer originalSegment, PngEncoderDeflaterBuffer deflatedSegment, int compressionLevel, boolean lastSegment) {
        Deflater deflater = PngEncoderDeflaterThreadLocalDeflater.getInstance(compressionLevel);
        deflater.setInput(originalSegment.bytes, 0, originalSegment.length);
        if (lastSegment) {
            deflater.finish();
        }
        deflatedSegment.length = deflater.deflate(deflatedSegment.bytes, 0, deflatedSegment.bytes.length, lastSegment ? 0 : 2);
    }
}

