/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.ExitCase;
import cats.effect.ExitCase$;
import cats.effect.ExitCase$Canceled$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IO$ContextSwitch$;
import cats.effect.internals.ForwardCancelable;
import cats.effect.internals.IOBracket$;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOContext;
import cats.effect.internals.IOFrame;
import cats.effect.internals.IOFromFuture$;
import cats.effect.internals.IORunLoop$;
import cats.effect.internals.Logger$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class IOBracket {
    public static <A, B> IO<B> apply(IO<A> iO, Function1<A, IO<B>> function1, Function2<A, ExitCase<Throwable>, IO<BoxedUnit>> function2) {
        return IOBracket$.MODULE$.apply(iO, function1, function2);
    }

    public static <A> IO<A> guaranteeCase(IO<A> iO, Function1<ExitCase<Throwable>, IO<BoxedUnit>> function1) {
        return IOBracket$.MODULE$.guaranteeCase(iO, function1);
    }

    private static abstract class BaseReleaseFrame<A, B>
    extends IOFrame<B, IO<B>> {
        private final AtomicBoolean waitsForResult = new AtomicBoolean(true);
        private final Promise<BoxedUnit> p = Promise$.MODULE$.apply();
        private final IO cancel = this.applyRelease(ExitCase$Canceled$.MODULE$).uncancelable();

        public abstract IO<BoxedUnit> release(ExitCase<Throwable> var1);

        private IO<BoxedUnit> applyRelease(ExitCase<Throwable> e) {
            return IO$.MODULE$.defer(() -> this.applyRelease$$anonfun$1(e));
        }

        public final IO<BoxedUnit> cancel() {
            return this.cancel;
        }

        @Override
        public final IO<B> recover(Throwable e) {
            return IO$ContextSwitch$.MODULE$.apply(this.applyRelease(ExitCase$.MODULE$.error(e)), IOBracket$.cats$effect$internals$IOBracket$$$makeUncancelable, IOBracket$.cats$effect$internals$IOBracket$$$disableUncancelableAndPop).flatMap(new ReleaseRecover(e));
        }

        @Override
        public final IO<B> apply(B b) {
            return IO$ContextSwitch$.MODULE$.apply(this.applyRelease(ExitCase$.MODULE$.complete()), IOBracket$.cats$effect$internals$IOBracket$$$makeUncancelable, IOBracket$.cats$effect$internals$IOBracket$$$disableUncancelableAndPop).map((Function1 & Serializable)_$4 -> b);
        }

        private final Promise applyRelease$$anonfun$2$$anonfun$1$$anonfun$1() {
            return this.p.success((Object)BoxedUnit.UNIT);
        }

        private final void applyRelease$$anonfun$5$$anonfun$4$$anonfun$1() {
            this.p.success((Object)BoxedUnit.UNIT);
        }

        private final IO applyRelease$$anonfun$1(ExitCase e$1) {
            return this.waitsForResult.compareAndSet(true, false) ? this.release(e$1).redeemWith((Function1 & Serializable)ex -> IO$.MODULE$.apply(this::applyRelease$$anonfun$2$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)_$2 -> IO$.MODULE$.raiseError((Throwable)ex)), (Function1 & Serializable)_$3 -> IO$.MODULE$.apply(this::applyRelease$$anonfun$5$$anonfun$4$$anonfun$1)) : IOFromFuture$.MODULE$.apply(this.p.future());
        }
    }

    private static final class BracketReleaseFrame<A, B>
    extends BaseReleaseFrame<A, B> {
        private final A a;
        private final Function2<A, ExitCase<Throwable>, IO<BoxedUnit>> releaseFn;

        public BracketReleaseFrame(A a, Function2<A, ExitCase<Throwable>, IO<BoxedUnit>> releaseFn) {
            this.a = a;
            this.releaseFn = releaseFn;
        }

        @Override
        public IO<BoxedUnit> release(ExitCase<Throwable> c) {
            return (IO)this.releaseFn.apply(this.a, c);
        }
    }

    private static final class BracketStart<A, B>
    implements Function1<Either<Throwable, A>, BoxedUnit>,
    Runnable {
        private final Function1<A, IO<B>> use;
        private final Function2<A, ExitCase<Throwable>, IO<BoxedUnit>> release;
        private final IOContext ctx;
        private final IOConnection conn;
        private final ForwardCancelable deferredRelease;
        private final Function1<Either<Throwable, B>, BoxedUnit> cb;
        private Either<Throwable, A> result;

        public BracketStart(Function1<A, IO<B>> use, Function2<A, ExitCase<Throwable>, IO<BoxedUnit>> release, IOContext ctx, IOConnection conn, ForwardCancelable deferredRelease, Function1<Either<Throwable, B>, BoxedUnit> cb) {
            this.use = use;
            this.release = release;
            this.ctx = ctx;
            this.conn = conn;
            this.deferredRelease = deferredRelease;
            this.cb = cb;
        }

        public void apply(Either<Throwable, A> ea) {
            if (this.result != null) {
                throw new IllegalStateException("callback called multiple times!");
            }
            this.result = ea;
            IOBracket$.cats$effect$internals$IOBracket$$$ec.execute((Runnable)this);
        }

        @Override
        public void run() {
            Either<Throwable, A> either = this.result;
            if (either instanceof Right) {
                Object a = ((Right)either).value();
                BracketReleaseFrame frame = new BracketReleaseFrame(a, this.release);
                this.deferredRelease.complete(frame.cancel());
                if (!this.conn.isCanceled()) {
                    IO fb = this.liftedTree1$1(a);
                    IO onNext = fb.flatMap(frame);
                    IORunLoop$.MODULE$.restartCancelable(onNext, this.conn, this.ctx, this.cb);
                }
            } else if (either instanceof Left) {
                Left error = (Left)either;
                this.deferredRelease.complete(IO$.MODULE$.unit());
                this.cb.apply((Object)((Either)error));
            } else {
                throw new MatchError(either);
            }
        }

        private final IO liftedTree1$1(Object a$1) {
            IO iO;
            try {
                iO = (IO)this.use.apply(a$1);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    iO = IO$.MODULE$.raiseError(e);
                }
                throw throwable;
            }
            return iO;
        }
    }

    private static final class EnsureReleaseFrame<A>
    extends BaseReleaseFrame<BoxedUnit, A> {
        private final Function1<ExitCase<Throwable>, IO<BoxedUnit>> releaseFn;

        public EnsureReleaseFrame(Function1<ExitCase<Throwable>, IO<BoxedUnit>> releaseFn) {
            this.releaseFn = releaseFn;
        }

        @Override
        public IO<BoxedUnit> release(ExitCase<Throwable> c) {
            return (IO)this.releaseFn.apply(c);
        }
    }

    private static final class ReleaseRecover
    extends IOFrame<BoxedUnit, IO<Nothing$>> {
        private final Throwable e;

        public ReleaseRecover(Throwable e) {
            this.e = e;
        }

        @Override
        public IO<Nothing$> recover(Throwable e2) {
            Logger$.MODULE$.reportFailure(e2);
            return IO$.MODULE$.raiseError(this.e);
        }

        @Override
        public IO<Nothing$> apply(BoxedUnit a) {
            return IO$.MODULE$.raiseError(this.e);
        }
    }
}

