/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.internals.Callback$;
import cats.effect.internals.Callback$Extensions$;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOConnection$;
import cats.effect.internals.IOForkedStart$;
import cats.effect.internals.IOParMap$;
import cats.effect.internals.IORunLoop$;
import cats.effect.internals.Logger$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class IOParMap {
    public static <A, B, C> IO<C> apply(ContextShift<IO> contextShift, IO<A> iO, IO<B> iO2, Function2<A, B, C> function2) {
        return IOParMap$.MODULE$.apply(contextShift, iO, iO2, function2);
    }

    private static final class ParMapRunnable<A, B, C>
    implements Runnable {
        private final ContextShift<IO> cs;
        private final IO<A> fa;
        private final IO<B> fb;
        private final Function2<A, B, C> f;
        private final IOConnection conn;
        private final Function1<Either<Throwable, C>, BoxedUnit> cb;
        private final AtomicReference<Object> state;

        public ParMapRunnable(ContextShift<IO> cs, IO<A> fa, IO<B> fb, Function2<A, B, C> f, IOConnection conn, Function1<Either<Throwable, C>, BoxedUnit> cb) {
            this.cs = cs;
            this.fa = fa;
            this.fb = fb;
            this.f = f;
            this.conn = conn;
            this.cb = cb;
            this.state = new AtomicReference();
        }

        private Function1<Either<Throwable, A>, BoxedUnit> callbackA(IOConnection connB) {
            return (JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable e = (Throwable)((Left)either).value();
                    this.sendError(connB, e);
                } else if (either instanceof Right) {
                    Object a = ((Right)either).value();
                    Object object = this.state.getAndSet(package$.MODULE$.Left().apply(a));
                    if (object != null) {
                        if (object instanceof Right) {
                            Object b = ((Right)object).value();
                            this.complete(a, b);
                        } else if (!(object instanceof Throwable)) {
                            Object left = object;
                            throw new IllegalStateException("parMap: " + left);
                        }
                    }
                } else {
                    throw new MatchError((Object)either);
                }
            };
        }

        public Function1<Either<Throwable, B>, BoxedUnit> callbackB(IOConnection connA) {
            return (JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable e = (Throwable)((Left)either).value();
                    this.sendError(connA, e);
                } else if (either instanceof Right) {
                    Object b = ((Right)either).value();
                    Object object = this.state.getAndSet(package$.MODULE$.Right().apply(b));
                    if (object != null) {
                        if (object instanceof Left) {
                            Object a = ((Left)object).value();
                            this.complete(a, b);
                        } else if (!(object instanceof Throwable)) {
                            Object right = object;
                            throw new IllegalStateException("parMap: " + right);
                        }
                    }
                } else {
                    throw new MatchError((Object)either);
                }
            };
        }

        public void complete(A a, B b) {
            this.conn.pop();
            this.cb.apply((Object)this.liftedTree1$1(a, b));
        }

        private void sendError(IOConnection other, Throwable e) {
            Object object = this.state.getAndSet(e);
            if (object instanceof Throwable) {
                Logger$.MODULE$.reportFailure(e);
            } else if (object == null || object instanceof Left || object instanceof Right) {
                other.cancel().unsafeRunAsync((Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)(JProcedure1 & Serializable)r -> {
                    Throwable throwable;
                    this.conn.pop();
                    Function1 function1 = Callback$.MODULE$.Extensions(this.cb);
                    Left$ left$ = package$.MODULE$.Left();
                    Either either = r;
                    if (either instanceof Left) {
                        Throwable e2 = (Throwable)((Left)either).value();
                        Logger$.MODULE$.reportFailure(e2);
                        throwable = e;
                    } else {
                        throwable = e;
                    }
                    Callback$Extensions$.MODULE$.async$extension(function1, left$.apply((Object)throwable));
                });
            } else {
                throw new MatchError(object);
            }
        }

        @Override
        public void run() {
            IOConnection connA = IOConnection$.MODULE$.apply();
            IOConnection connB = IOConnection$.MODULE$.apply();
            this.conn.pushPair(connA, connB);
            IORunLoop$.MODULE$.startCancelable(IOForkedStart$.MODULE$.apply(this.fa, this.cs), connA, this.callbackA(connB));
            IORunLoop$.MODULE$.startCancelable(IOForkedStart$.MODULE$.apply(this.fb, this.cs), connB, this.callbackB(connA));
        }

        private final Either liftedTree1$1(Object a$1, Object b$1) {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(this.f.apply(a$1, b$1));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    right = package$.MODULE$.Left().apply((Object)e);
                }
                throw throwable;
            }
            return right;
        }
    }
}

