/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.IO;
import cats.effect.IO$ContextSwitch$;
import cats.effect.IO$Pure$;
import cats.effect.IO$RaiseError$;
import cats.effect.internals.ArrayStack;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOContext;
import cats.effect.internals.IOFrame;
import cats.effect.internals.IORunLoop$;
import cats.effect.internals.TrampolineEC$;
import java.io.Serializable;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class IORunLoop {
    public static <A> void restart(IO<A> iO, IOContext iOContext, Function1<Either<Throwable, A>, BoxedUnit> function1) {
        IORunLoop$.MODULE$.restart(iO, iOContext, function1);
    }

    public static <A> void restartCancelable(IO<A> iO, IOConnection iOConnection, IOContext iOContext, Function1<Either<Throwable, A>, BoxedUnit> function1) {
        IORunLoop$.MODULE$.restartCancelable(iO, iOConnection, iOContext, function1);
    }

    public static <A> void start(IO<A> iO, Function1<Either<Throwable, A>, BoxedUnit> function1) {
        IORunLoop$.MODULE$.start(iO, function1);
    }

    public static <A> void startCancelable(IO<A> iO, IOConnection iOConnection, Function1<Either<Throwable, A>, BoxedUnit> function1) {
        IORunLoop$.MODULE$.startCancelable(iO, iOConnection, function1);
    }

    public static <A> IO<A> step(IO<A> iO) {
        return IORunLoop$.MODULE$.step(iO);
    }

    private static final class RestartCallback
    implements Function1<Either<Throwable, Object>, BoxedUnit>,
    Runnable {
        private final Function1 cb;
        private IOConnection conn;
        private boolean canCall;
        private boolean trampolineAfter;
        private Function1 bFirst;
        private ArrayStack bRest;
        private IOContext ctx;
        private Either<Throwable, Object> value;

        public RestartCallback(IOConnection connInit, Function1 cb) {
            this.cb = cb;
            this.conn = connInit;
            this.canCall = false;
            this.trampolineAfter = false;
        }

        public void contextSwitch(IOConnection conn) {
            this.conn = conn;
        }

        public void start(IO.Async<Object> task, IOContext ctx, Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
            this.canCall = true;
            this.bFirst = bFirst;
            this.bRest = bRest;
            this.trampolineAfter = task.trampolineAfter();
            this.ctx = ctx;
            task.k().apply((Object)this.conn, (Object)ctx, (Object)this);
        }

        private void signal(Either<Throwable, Object> either) {
            Function1 bFirst = this.bFirst;
            ArrayStack bRest = this.bRest;
            IOContext ctx = this.ctx;
            this.bFirst = null;
            this.bRest = null;
            this.ctx = null;
            if (!this.conn.isCanceled()) {
                Either<Throwable, Object> either2 = either;
                if (either2 instanceof Right) {
                    Object success = ((Right)either2).value();
                    IORunLoop$.MODULE$.cats$effect$internals$IORunLoop$$$loop(IO$Pure$.MODULE$.apply(success), this.conn, (Function1<Either<Throwable, Object>, BoxedUnit>)this.cb, ctx, this, (Function1<Object, IO<Object>>)bFirst, bRest);
                } else if (either2 instanceof Left) {
                    Throwable e = (Throwable)((Left)either2).value();
                    IORunLoop$.MODULE$.cats$effect$internals$IORunLoop$$$loop(IO$RaiseError$.MODULE$.apply(e), this.conn, (Function1<Either<Throwable, Object>, BoxedUnit>)this.cb, ctx, this, (Function1<Object, IO<Object>>)bFirst, bRest);
                } else {
                    throw new MatchError(either2);
                }
            }
        }

        @Override
        public void run() {
            Either<Throwable, Object> v = this.value;
            this.value = null;
            this.signal(v);
        }

        public void apply(Either<Throwable, Object> either) {
            if (this.canCall) {
                this.canCall = false;
                if (this.trampolineAfter) {
                    this.value = either;
                    TrampolineEC$.MODULE$.immediate().execute(this);
                } else {
                    this.signal(either);
                }
            }
        }
    }

    private static final class RestoreContext
    extends IOFrame<Object, IO<Object>> {
        private final IOConnection old;
        private final Function4<Object, Throwable, IOConnection, IOConnection, IOConnection> restore;

        public RestoreContext(IOConnection old, Function4<Object, Throwable, IOConnection, IOConnection, IOConnection> restore) {
            this.old = old;
            this.restore = restore;
        }

        @Override
        public IO<Object> apply(Object a) {
            return IO$ContextSwitch$.MODULE$.apply(IO$Pure$.MODULE$.apply(a), (Function1<IOConnection, IOConnection>)(Function1 & Serializable)current -> (IOConnection)this.restore.apply(a, null, (Object)this.old, current), null);
        }

        @Override
        public IO<Object> recover(Throwable e) {
            return IO$ContextSwitch$.MODULE$.apply(IO$RaiseError$.MODULE$.apply(e), (Function1<IOConnection, IOConnection>)(Function1 & Serializable)current -> (IOConnection)this.restore.apply(null, (Object)e, (Object)this.old, current), null);
        }
    }
}

