/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.codex.memory;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexIndex;
import com.elixirtech.codex.CodexIndex$;
import com.elixirtech.codex.memory.InMemoryCodexCollection;
import com.elixirtech.codex.memory.InMemoryCodexDB$;
import com.elixirtech.codex.memory.InMemoryCodexDB$CltnFile$;
import com.elixirtech.codex.memory.InMemoryCodexDB$CltnInfo$;
import com.elixirtech.codex.memory.InMemoryContent;
import com.elixirtech.codex.memory.InMemoryContent$;
import com.elixirtech.codex.memory.InMemoryIndexes;
import com.elixirtech.codex.memory.InMemoryIndexes$;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sourcecode.FullName$;
import sourcecode.Line$;

public class InMemoryCodexDB
implements CodexDB {
    private final TrieMap<String, Task<InMemoryCodexCollection>> collections = new TrieMap();
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(InMemoryCodexDB$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(InMemoryCodexDB$.class.getDeclaredField("Temp$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(InMemoryCodexDB$.class.getDeclaredField("Root$lzy1"));

    public static HashMap<String, CltnFile> All() {
        return InMemoryCodexDB$.MODULE$.All();
    }

    public static File Root() {
        return InMemoryCodexDB$.MODULE$.Root();
    }

    public static File Temp() {
        return InMemoryCodexDB$.MODULE$.Temp();
    }

    public static Document ensureHasId(Document document) {
        return InMemoryCodexDB$.MODULE$.ensureHasId(document);
    }

    public static CltnFile getCltnFile(File file) {
        return InMemoryCodexDB$.MODULE$.getCltnFile(file);
    }

    public static File getDir(CltnInfo cltnInfo) {
        return InMemoryCodexDB$.MODULE$.getDir(cltnInfo);
    }

    public static LoggingInterface log() {
        return InMemoryCodexDB$.MODULE$.log();
    }

    public static Try<Vector<Document>> readDocuments(File file) {
        return InMemoryCodexDB$.MODULE$.readDocuments(file);
    }

    public static Try<Vector<Document>> readIndexes(CltnInfo cltnInfo) {
        return InMemoryCodexDB$.MODULE$.readIndexes(cltnInfo);
    }

    public static Try<Vector<Document>> readRecords(CltnInfo cltnInfo) {
        return InMemoryCodexDB$.MODULE$.readRecords(cltnInfo);
    }

    public static void writeDocuments(CltnInfo cltnInfo, File file, Vector<Document> vector) {
        InMemoryCodexDB$.MODULE$.writeDocuments(cltnInfo, file, vector);
    }

    public static void writeIndexes(CltnInfo cltnInfo, Vector<Document> vector) {
        InMemoryCodexDB$.MODULE$.writeIndexes(cltnInfo, vector);
    }

    public static void writeRecords(CltnInfo cltnInfo, Vector<Document> vector) {
        InMemoryCodexDB$.MODULE$.writeRecords(cltnInfo, vector);
    }

    @Override
    public Task<CodexCollection> getCodexCollection(String name) {
        return (Task)this.collections.getOrElseUpdate((Object)name, () -> this.getCodexCollection$$anonfun$1(name));
    }

    @Override
    public Task<CodexCollection> getAdminCodexCollection(String name) {
        return this.getCodexCollection(name);
    }

    @Override
    public Task<CodexCollection> getTempCodexCollection(String name) {
        return (Task)this.collections.getOrElseUpdate((Object)name, () -> this.getTempCodexCollection$$anonfun$1(name));
    }

    @Override
    public Task<CodexCollection> getLogCodexCollection(String name) {
        throw new RuntimeException("Logs database is not supported in InMemoryCodex");
    }

    @Override
    public Task<Set<String>> getCodexCollectionNames() {
        return Task$.MODULE$.apply(InMemoryCodexDB::getCodexCollectionNames$$anonfun$1);
    }

    @Override
    public Task<Set<String>> getTempCodexCollectionNames() {
        return Task$.MODULE$.apply(InMemoryCodexDB::getTempCodexCollectionNames$$anonfun$1);
    }

    @Override
    public Task<Set<String>> getLogCodexCollectionNames() {
        return Task$.MODULE$.now((Object)Predef$.MODULE$.Set().empty());
    }

    public Task<BoxedUnit> expireOldDocuments() {
        return this.expireOldDocuments((List<Task<InMemoryCodexCollection>>)this.collections.values().toList());
    }

    public void uncache(CltnInfo cltnInfo) {
        this.collections.$minus$eq((Object)cltnInfo.name());
    }

    private Task<InMemoryCodexCollection> buildCodexCollectionT(CltnInfo info) {
        return Task$.MODULE$.apply(() -> this.buildCodexCollectionT$$anonfun$1(info)).flatMap((Function1 & Serializable)cltn -> cltn.expireOldDocuments().map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return cltn;
        }));
    }

    private Task<BoxedUnit> expireOldDocuments(List<Task<InMemoryCodexCollection>> list) {
        List<Task<InMemoryCodexCollection>> list2 = list;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Task<InMemoryCodexCollection>> list3 = list2;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list2 instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list2;
            List list4 = colon2.next$access$1();
            Task head = (Task)colon2.head();
            List tail = list4;
            return head.flatMap((Function1 & Serializable)_$5 -> _$5.expireOldDocuments()).flatMap((Function1 & Serializable)_$6 -> this.expireOldDocuments((List<Task<InMemoryCodexCollection>>)tail));
        }
        throw new MatchError(list2);
    }

    public Option<InMemoryContent> loadContent(CltnInfo info) {
        Try<Vector<Document>> try_ = InMemoryCodexDB$.MODULE$.readRecords(info);
        if (try_ instanceof Success) {
            Vector records = (Vector)((Success)try_).value();
            return Some$.MODULE$.apply((Object)InMemoryContent$.MODULE$.apply((Vector<Document>)records));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            InMemoryCodexDB$.MODULE$.log().error(() -> InMemoryCodexDB.loadContent$$anonfun$1(info), ex, Line$.MODULE$.apply(196), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.loadContent"));
            return None$.MODULE$;
        }
        throw new MatchError(try_);
    }

    public Option<InMemoryIndexes> loadIndexes(CltnInfo info) {
        Try<Vector<Document>> try_ = InMemoryCodexDB$.MODULE$.readIndexes(info);
        if (try_ instanceof Success) {
            Vector documents = (Vector)((Success)try_).value();
            return Some$.MODULE$.apply((Object)InMemoryIndexes$.MODULE$.apply((Vector<CodexIndex>)((Vector)documents.flatMap((Function1 & Serializable)doc -> CodexIndex$.MODULE$.fromDocument((Document)doc)))));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            InMemoryCodexDB$.MODULE$.log().error(() -> InMemoryCodexDB.loadIndexes$$anonfun$2(info), ex, Line$.MODULE$.apply(205), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.loadIndexes"));
            return None$.MODULE$;
        }
        throw new MatchError(try_);
    }

    private final Task getCodexCollection$$anonfun$1(String name$1) {
        return this.buildCodexCollectionT(InMemoryCodexDB$CltnInfo$.MODULE$.apply(name$1, false)).memoize();
    }

    private final Task getTempCodexCollection$$anonfun$1(String name$2) {
        return this.buildCodexCollectionT(InMemoryCodexDB$CltnInfo$.MODULE$.apply(name$2, true)).memoize();
    }

    private static final File[] getCodexCollectionNames$$anonfun$1$$anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final Set getCodexCollectionNames$$anonfun$1() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)InMemoryCodexDB$.MODULE$.Root().listFiles()).getOrElse(InMemoryCodexDB::getCodexCollectionNames$$anonfun$1$$anonfun$1));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.isDirectory()));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$2 -> _$2.getName(), ClassTag$.MODULE$.apply(String.class))).toSet();
    }

    private static final File[] getTempCodexCollectionNames$$anonfun$1$$anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final Set getTempCodexCollectionNames$$anonfun$1() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)InMemoryCodexDB$.MODULE$.Temp().listFiles()).getOrElse(InMemoryCodexDB::getTempCodexCollectionNames$$anonfun$1$$anonfun$1));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$3 -> _$3.isDirectory()));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$4 -> _$4.getName(), ClassTag$.MODULE$.apply(String.class))).toSet();
    }

    private final InMemoryCodexCollection buildCodexCollectionT$$anonfun$1(CltnInfo info$1) {
        return new InMemoryCodexCollection(this, info$1, this.loadContent(info$1), this.loadIndexes(info$1));
    }

    private static final Object loadContent$$anonfun$1(CltnInfo info$2) {
        return "Can't read content for " + info$2.name();
    }

    private static final Object loadIndexes$$anonfun$2(CltnInfo info$3) {
        return "Can't read indexes for " + info$3.name();
    }

    public static final class CltnFile
    implements Product,
    Serializable {
        private final File file;

        public static CltnFile apply(File file) {
            return InMemoryCodexDB$CltnFile$.MODULE$.apply(file);
        }

        public static CltnFile fromProduct(Product product) {
            return InMemoryCodexDB$CltnFile$.MODULE$.fromProduct(product);
        }

        public static CltnFile unapply(CltnFile cltnFile) {
            return InMemoryCodexDB$CltnFile$.MODULE$.unapply(cltnFile);
        }

        public CltnFile(File file) {
            this.file = file;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CltnFile)) return false;
            CltnFile cltnFile = (CltnFile)object;
            File file = this.file();
            File file2 = cltnFile.file();
            if (file != null) {
                if (!((Object)file).equals(file2)) return false;
                return true;
            }
            if (file2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CltnFile;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CltnFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "file";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public File file() {
            return this.file;
        }

        public CltnFile copy(File file) {
            return new CltnFile(file);
        }

        public File copy$default$1() {
            return this.file();
        }

        public File _1() {
            return this.file();
        }
    }

    public static final class CltnInfo
    implements Product,
    Serializable {
        private final String name;
        private final boolean isTemp;

        public static CltnInfo apply(String string, boolean bl) {
            return InMemoryCodexDB$CltnInfo$.MODULE$.apply(string, bl);
        }

        public static CltnInfo fromProduct(Product product) {
            return InMemoryCodexDB$CltnInfo$.MODULE$.fromProduct(product);
        }

        public static CltnInfo unapply(CltnInfo cltnInfo) {
            return InMemoryCodexDB$CltnInfo$.MODULE$.unapply(cltnInfo);
        }

        public CltnInfo(String name, boolean isTemp) {
            this.name = name;
            this.isTemp = isTemp;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)(this.isTemp() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CltnInfo)) return false;
            CltnInfo cltnInfo = (CltnInfo)object;
            if (this.isTemp() != cltnInfo.isTemp()) return false;
            String string = this.name();
            String string2 = cltnInfo.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CltnInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CltnInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "isTemp";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public boolean isTemp() {
            return this.isTemp;
        }

        public CltnInfo copy(String name, boolean isTemp) {
            return new CltnInfo(name, isTemp);
        }

        public String copy$default$1() {
            return this.name();
        }

        public boolean copy$default$2() {
            return this.isTemp();
        }

        public String _1() {
            return this.name();
        }

        public boolean _2() {
            return this.isTemp();
        }
    }
}

