/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mail;

import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.package$;
import com.elixirtech.mail.DebugMailSender$;
import com.elixirtech.mail.DebugMailSender$DebugMail$;
import com.elixirtech.mail.MailAPI;
import com.elixirtech.mail.MailSender;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DebugMailSender
implements MailSender,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DebugMailSender.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final File folder;
    private final DateTimeFormatter formatter;

    public static String NAME() {
        return DebugMailSender$.MODULE$.NAME();
    }

    public static Option<DebugMail> lastMail() {
        return DebugMailSender$.MODULE$.lastMail();
    }

    public static void recordMail(MailAPI.Mail2 mail2) {
        DebugMailSender$.MODULE$.recordMail(mail2);
    }

    public DebugMailSender(Config config) {
        this.folder = new File(config.getString("folder"));
        this.folder().mkdirs();
        this.log().info(this::$init$$$anonfun$1, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("com.elixirtech.mail.DebugMailSender"));
        this.formatter = DateTimeFormatter.ofPattern("yyyy-MMdd-HHmmss");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File folder() {
        return this.folder;
    }

    public DateTimeFormatter formatter() {
        return this.formatter;
    }

    public void stop() {
    }

    @Override
    public LogMessage send(MailAPI.Mail2 mail) {
        DebugMailSender$.MODULE$.recordMail(mail);
        String ts = this.formatter().format(LocalDateTime.now());
        File output = this.safeFolder(ts, this.safeFolder$default$2());
        output.mkdirs();
        File file = new File(output, "mail.txt");
        ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
            OutputStreamWriter w = (OutputStreamWriter)arm.manage((Object)package$.MODULE$.enrichOutputStream((OutputStream)package$.MODULE$.enrichFile(file).output()).utf8());
            w.write(mail.toString());
            w.write("\n-- end --\n");
        });
        mail.attachments().foreach((Function1)(JProcedure1 & Serializable)a -> {
            File af = new File(output, a.name());
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                FileOutputStream os = (FileOutputStream)arm.manage((Object)package$.MODULE$.enrichFile(af).output());
                Object object = Predef$.MODULE$.byteArrayOps(a.bytes());
                os.write((byte[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(Byte.TYPE)));
            });
        });
        this.log().info(() -> DebugMailSender.send$$anonfun$3(output), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("com.elixirtech.mail.DebugMailSender.send"));
        return LogMessage.None$.MODULE$;
    }

    public File safeFolder(String prefix, int test) {
        File file = new File(this.folder(), (String)(test > 0 ? prefix + "-" + test : prefix));
        if (file.exists()) {
            return this.safeFolder(prefix, test + 1);
        }
        return file;
    }

    public int safeFolder$default$2() {
        return 0;
    }

    private final Object $init$$$anonfun$1() {
        return "Using DebugSMTP writing to " + this.folder().getAbsolutePath();
    }

    private static final Object send$$anonfun$3(File output$2) {
        return "sendMail contents written to " + output$2.getAbsolutePath();
    }

    public static final class DebugMail
    implements Product,
    Serializable {
        private final int serial;
        private final MailAPI.Mail2 mail;

        public static DebugMail apply(int n, MailAPI.Mail2 mail2) {
            return DebugMailSender$DebugMail$.MODULE$.apply(n, mail2);
        }

        public static DebugMail fromProduct(Product product) {
            return DebugMailSender$DebugMail$.MODULE$.fromProduct(product);
        }

        public static DebugMail unapply(DebugMail debugMail) {
            return DebugMailSender$DebugMail$.MODULE$.unapply(debugMail);
        }

        public DebugMail(int serial, MailAPI.Mail2 mail) {
            this.serial = serial;
            this.mail = mail;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.serial());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mail()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DebugMail)) return false;
            DebugMail debugMail = (DebugMail)object;
            if (this.serial() != debugMail.serial()) return false;
            MailAPI.Mail2 mail2 = this.mail();
            MailAPI.Mail2 mail22 = debugMail.mail();
            if (mail2 != null) {
                if (!((Object)mail2).equals(mail22)) return false;
                return true;
            }
            if (mail22 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DebugMail;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DebugMail";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "serial";
            }
            if (1 == n2) {
                return "mail";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int serial() {
            return this.serial;
        }

        public MailAPI.Mail2 mail() {
            return this.mail;
        }

        public DebugMail copy(int serial, MailAPI.Mail2 mail) {
            return new DebugMail(serial, mail);
        }

        public int copy$default$1() {
            return this.serial();
        }

        public MailAPI.Mail2 copy$default$2() {
            return this.mail();
        }

        public int _1() {
            return this.serial();
        }

        public MailAPI.Mail2 _2() {
            return this.mail();
        }
    }
}

